#include "c2_seqvar.h"

void
_c2_Create(Q) 
    _c2_SeqVarQ Q;
{
    int i;
    for (i=0; i<8; i++)
        Q[i] = ((_c2_SeqVar *)0);
}

void 
_c2_Destory(Q) 
    _c2_SeqVarQ Q; 
{ 
    _c2_SeqVar *ThisSeqVar, *FreeSeqVar;
    int i;

    for (i=0; i<8; i++) {
        ThisSeqVar = Q[i];
        while (ThisSeqVar != ((_c2_SeqVar *)0)) {
            FreeSeqVar = ThisSeqVar;
            ThisSeqVar = ThisSeqVar->next;
            _c2_shfree((char *) FreeSeqVar); 
 	}
        Q[i] = ((_c2_SeqVar *)0);
    }
}

void 
_c2_Insert(Q, I, V) 
    _c2_SeqVarQ Q; 
    _c2_Index *I;
    _c2_Value *V; 
{
    _c2_SeqVar *ThisSeqVar, *LastSeqVar; 

    ThisSeqVar = (_c2_SeqVar *)_c2_shmalloc(sizeof(_c2_SeqVar));
    ThisSeqVar->value = *V;
    ThisSeqVar->index = *I;
    ThisSeqVar->next = ((_c2_SeqVar *)0);

    LastSeqVar = Q[I->NumInd];
    if (LastSeqVar != ((_c2_SeqVar *)0)) {
        while (LastSeqVar->next != ((_c2_SeqVar *)0))
             LastSeqVar = LastSeqVar->next;
        LastSeqVar->next = ThisSeqVar;
    } else {
        Q[I->NumInd] = ThisSeqVar;
    }
}


#ifdef _C2_DBGR_
int 
_c2_Check(nodeaddr, Q, I) 
    _c2_NodeBase * nodeaddr;
#else
int _c2_Check(Q, I)
#endif
    _c2_SeqVarQ Q; 
    _c2_Index *I;
{
   _c2_SeqVar *ThisSeqVar;
   int i;

   ThisSeqVar = Q[I->NumInd];
   if (I->NumInd > 0) {
      while (ThisSeqVar != ((_c2_SeqVar *)0)) {
#         ifdef _C2_DBGR_
	 if ( _c2_chkFpBpAct(nodeaddr, ThisSeqVar->value.fplist)) 
#         endif
	     {
		for (i=0; i<I->NumInd; i++) {
		   if (ThisSeqVar->index.Ind[i] == I->Ind[i]) {
		      if (i == I->NumInd - 1) return 1;
		   } else
		       break;
		}
	     }
	 ThisSeqVar = ThisSeqVar->next;
      }
      return 0;
   } else {
      while (ThisSeqVar != ((_c2_SeqVar *)0)) {
#        ifdef _C2_DBGR_
	 if  (_c2_chkFpBpAct(nodeaddr, ThisSeqVar->value.fplist)) 
#        endif
	     {
		return 1;
	     }
#        ifdef _C2_DBGR_
	 ThisSeqVar = ThisSeqVar->next; /* Only for dbgr replay mode */
#        endif
      } 
      return 0;
   }
}

#ifdef _C2_DBGR_
int _c2_Remove(nodeaddr, Q, I, V) 
    _c2_NodeBase * nodeaddr;
#else
int _c2_Remove(Q, I, V)
#endif
    _c2_SeqVarQ Q; 
    _c2_Index *I;
    _c2_Value *V;
{
    _c2_SeqVar *ThisSeqVar, *PrevSeqVar;
    int i;

    PrevSeqVar = ((_c2_SeqVar *)0);

    ThisSeqVar = Q[I->NumInd];
    if (I->NumInd > 0) {
        while (ThisSeqVar != ((_c2_SeqVar *)0)) {
#        ifdef _C2_DBGR_
         if (_c2_chkFpBpAct(nodeaddr, ThisSeqVar->value.fplist)) 
             {
#        endif 
            for (i=0; i<I->NumInd; i++) {
                if (ThisSeqVar->index.Ind[i] == I->Ind[i]) {
                    if (i == I->NumInd - 1) {
                        *V = ThisSeqVar->value; 
                        if (PrevSeqVar != ((_c2_SeqVar *)0))
                            PrevSeqVar->next = ThisSeqVar->next;
                        else 
                            Q[I->NumInd] = Q[I->NumInd]->next;
                        _c2_shfree((char *) ThisSeqVar);
                        return 1;
		      }
                } else
                    break;
	    }
#            ifdef _C2_DBGR_
             }
#            endif
            PrevSeqVar = ThisSeqVar;
            ThisSeqVar = ThisSeqVar->next;
        }
        return 0;
    } else {
        if (ThisSeqVar != ((_c2_SeqVar *)0)) {
#        ifdef _C2_DBGR_
         if (_c2_chkFpBpAct(nodeaddr, ThisSeqVar->value.fplist)) 
#        endif
             {
                *V = ThisSeqVar->value; 
                if (PrevSeqVar != ((_c2_SeqVar *) 0) )
                    PrevSeqVar->next = ThisSeqVar->next;
                else 
                    Q[I->NumInd] = Q[I->NumInd]->next; /* normal operation */
                _c2_shfree((char *) ThisSeqVar);
                return 1;
             }
#        ifdef _C2_DBGR_
         PrevSeqVar = ThisSeqVar; /* only for debugger replay mode */
         ThisSeqVar = ThisSeqVar->next; 
#        endif
      }
            return 0;
    }
}


/* routines for SeqVarQ caches */

void _c2_CacheInit(c)
   struct _c2_Cache *c;
{
   c->Current = 0;
   c->Len = 0;
}


void _c2_EnCache(c, PortIndex, MappedPortIndex, GraphIndex, NodeIndex, NodeAddr, Id)
   struct _c2_Cache *c;
   _c2_Index *PortIndex;
   _c2_Index *MappedPortIndex;
   _c2_Index *GraphIndex;
   _c2_Index *NodeIndex;
   _c2_NodeBase *NodeAddr;
   int Id;
{
   c->Cache[c->Current].PortIndex = *PortIndex;
   c->Cache[c->Current].MappedPortIndex = *MappedPortIndex;
   c->Cache[c->Current].GraphIndex = *GraphIndex;
   c->Cache[c->Current].NodeIndex = *NodeIndex;
   c->Cache[c->Current].NodeAddr = NodeAddr;
   c->Cache[c->Current].TaskId = Id;
   c->Current += 1;
   if (c->Current >= _c2_CACHESIZE) c->Current = 0;
   c->Len += 1;
   if (c->Len > _c2_CACHESIZE) c->Len = _c2_CACHESIZE;

}


int _c2_FindCache(c, PortIndex, MappedPortIndex, GraphIndex, NodeIndex, NodeAddr, Id)
   struct _c2_Cache *c;
   _c2_Index *PortIndex;
   _c2_Index *MappedPortIndex;
   _c2_Index *GraphIndex;
   _c2_Index *NodeIndex;
   _c2_NodeBase **NodeAddr;
   int *Id;
{
   int i;
   int j;

   i = c->Current - 1;
   if (i < 0) i = _c2_CACHESIZE - 1;

   for (j = 0; j < c->Len; j++) {
      if (_c2_EqIndex(&(c->Cache[i].PortIndex), PortIndex)) {
         *MappedPortIndex = c->Cache[i].MappedPortIndex;
         *GraphIndex = c->Cache[i].GraphIndex;
         *NodeIndex = c->Cache[i].NodeIndex;
         *NodeAddr = c->Cache[i].NodeAddr;
         *Id = c->Cache[i].TaskId;
         return 1;
      }
      i -= 1;
      if (i < 0) i = _c2_CACHESIZE - 1;
   }

   return 0;
}



