/*
 *  Address Map functions
 */

#include "c2_misc.h"
#include "c2_addrmap.h"
#include "c2_workers.h"

 /* Return address within Graph's map of object with given UID and
    Index.  UID of _c2_PARENT yields address of parent graph */

void *_c2_GetAddr(Graph, UID, Index)
   _c2_GraphBase *Graph;
   int UID;
   _c2_Index *Index;
{
   _c2_AddrMap *m;
   _c2_AddrLink *tmp;
   int ObjType;

   if (UID == _c2_PARENT) return (void *) Graph->Parent;

   m = Graph->Map;

   /* Search for entry in address map */

   tmp = m->Head;
   
   while (tmp != 0) {
      if (tmp->UID == UID && _c2_EqIndex(&(tmp->Index), Index)) break;
      tmp = tmp->Next;
   }

   if (tmp != 0) {
      return tmp->Entry;   /* Found it */
   }

   /* Need to create object */

   tmp = (_c2_AddrLink *) _c2_shmalloc(sizeof(_c2_AddrLink));

   tmp->UID = UID;
   tmp->Index = *Index;
   tmp->Entry = _c2_MakeObj(UID, Index, Graph, &ObjType);
   tmp->ObjType = ObjType;

   /* Add to address map */

   tmp->Next = m->Head;
   m->Head = tmp;

   return tmp->Entry;
}


_c2_GraphBase *_c2_MakeGraph(UID, Index, ParentGraph, LocalData)
   int UID;
   _c2_Index *Index;
   _c2_GraphBase *ParentGraph;
   void *LocalData;
{
  _c2_GraphBase *tmp;
  _c2_AddrMap *tmpMap;

  tmp = (_c2_GraphBase *) _c2_shmalloc(sizeof(_c2_GraphBase));
  tmp->UID = UID;
  tmp->Index = *Index;
  tmp->Parent = ParentGraph;
  tmpMap = (_c2_AddrMap *) _c2_shmalloc(sizeof(_c2_AddrMap));
  tmpMap->Head = 0;
  tmp->Map = tmpMap;
  tmp->LocalData = LocalData;
#ifdef _C2_DBGR_
  _c2_allocDbgGph(tmp);		/* allocate a struct in tmp for debugging */
#endif
  return tmp;
}


_c2_NodeBase *
_c2_MakeNode(UID, Index, Graph, LocalData, Comp, Init, Crepped)
   int UID; 
   _c2_Index *Index;
   _c2_GraphBase *Graph;
   void *LocalData;
   void (*Comp)();
   void (*Init)();
   int Crepped;
{
   _c2_NodeBase *tmpN;

   tmpN = (_c2_NodeBase *) _c2_shmalloc(sizeof(_c2_NodeBase));
   tmpN->QueueStatus = _c2_IDLE;
   tmpN->UID = UID;
   tmpN->Index = *Index;
   tmpN->LocalData = LocalData;
   tmpN->MyGraph = Graph;
   tmpN->CompProc = Comp;
   tmpN->NSState = _c2_NOTINIT;
   tmpN->InitProc = Init;
   tmpN->Crepped = Crepped;
   tmpN->HeadLock = tmpN->NextLock = (_c2_LockSet *) 0;
   if (Crepped) 
     if (Init != 0) Init(tmpN);
#ifdef _C2_DBGR_
   _c2_allocDbgUc(tmpN);	/* allocate a struct in tmpN for debugging */
#endif

   return tmpN;
}


_c2_NSRelBase *_c2_MakeNSRel(UID, Index, Graph, LocalData, Init, Crepped)
   int UID; 
   _c2_Index *Index;
   _c2_GraphBase *Graph;
   void *LocalData;
   void (*Init)();
   int Crepped;
{
   _c2_NSRelBase *tmpN;

   tmpN = (_c2_NSRelBase *) _c2_shmalloc(sizeof(_c2_NSRelBase));
   tmpN->UID = UID;
   tmpN->Index = *Index;
   tmpN->LocalData = LocalData;
   tmpN->MyGraph = Graph;
   tmpN->InitProc = Init;
   tmpN->Crepped = Crepped;
   if (Crepped) 
     if (Init != 0) Init(tmpN);
   return tmpN;
}


   /* Initialize all uninitialized nodes in map.  Assumes map is locked */
#ifdef _C2_DBGR_
void _c2_InitWaitingNodes(fplist, g)
_c2_List fplist;
#else
void _c2_InitWaitingNodes(g)
#endif
   _c2_GraphBase *g;
{
   _c2_AddrMap *M;
   _c2_AddrLink *tmp;
   _c2_NSRelBase *n;
   _c2_NodeBase *u;

   g->CrepsToGo -= 1;
#  ifdef _C2_DBGR_
      _c2_dbgGphCreatAction(g, fplist);
#  endif
   if (g->CrepsToGo > 0) return;

   M = g->Map;

   tmp = M->Head;

   while (tmp != 0) {
      if (tmp->ObjType == _c2_UCNODE) {
	 u = (_c2_NodeBase *) (tmp->Entry);
	 if (!(u->Crepped)) {
#           ifdef DEBUG	    
	       printf("initing a uc %d\n", u->UID);
#           endif
	    u->InitProc(u);
	    u->Crepped = 1;
	    _c2_EnQueue(u);
	 }
      } else if (tmp->ObjType == _c2_NSRELNODE) {
	 n = (_c2_NSRelBase *) (tmp->Entry);
	 if (!(n->Crepped)) {
#           ifdef DEBUG
	       printf("initing nsrel %d\n", u->UID);
#           endif
	    n->InitProc(n);
	    n->Crepped = 1;
	 }
      }
      tmp = tmp->Next;
   }

}


  /* Add NS lock to sorted list of locks.  Sort by UID of shared var
     in NSRel.  This allows detection of use of two instances of same
     shared var  */

void _c2_InsertLock(HeadLock, NewLock)
   _c2_LockSet **HeadLock;
   _c2_LockSet *NewLock;
{
   _c2_LockSet *cur;
   _c2_LockSet *prev;

   /* Find link that new one must come before */

   cur = *HeadLock;
   prev = cur;       /* just to avoid warning about prev being uninitialized */
   while (cur != 0) {

      if (NewLock->UID == cur->UID)
	 fprintf(stderr, "\n ****** Warning: %s\n         %s\n\n",
		 "Attempt to use two instances of the same shared variable", 
                 "from the same UC innstance.  This is illegal!!!");

      if (NewLock->UID < cur->UID) break;
      prev = cur;
      cur = cur->Next;
   }

   if (*HeadLock == 0) {  /* NewLock is first to go into List */
      *HeadLock = NewLock;
      NewLock->Next = 0;
   } else if (cur == *HeadLock) {  /* New first in non-empty list */
      NewLock->Next = cur;
      *HeadLock = NewLock;
   } else { 
      NewLock->Next = cur;
      prev->Next = NewLock;
   }
}
#ifdef _C2_DBGR_

  /* Add node to list of those waiting for lock
   * This is similar to the one for sequent. Interactive
   * debugging may introduce non-determinism in this serial  implementation.
   * Note that we may stop a UC before computation, and let the others
   * run. This may cause other UC's to acquire shared access in an order
   * that is different from the one recorded, causing the replay to fail.
   */

static void _c2_AddToNSQ(UCAddr, Q)
   _c2_NodeBase *UCAddr;
   _c2_NSLink **Q;
{
   _c2_NSLink *Cur;
   _c2_NSLink *New = (_c2_NSLink *) _c2_shmalloc(sizeof(_c2_NSLink));

   New->Node = UCAddr;

   if (*Q == 0) {
      New->Next = 0;
      *Q = New;
      return;
   }

   /* Only add if not already there */

   Cur = *Q;
   while (Cur != 0) {
      if (Cur->Node == UCAddr) return;
      Cur = Cur->Next;
   }

   New->Next = *Q;
   *Q = New;
}

  /* Enqueue and remoce from list all nodes waiting for lock-- does not
     mean that they get lock.  Means that they try again */

static void  _c2_ClearNSQ(Q)
   _c2_NSLink **Q;
{
   _c2_NSLink *Cur, *Tmp;

   Cur = *Q;

   while (Cur != 0) {
      _c2_EnQueue(Cur->Node);
      Tmp = Cur;
      Cur = Cur->Next;
      free(Tmp);
   }

   *Q = 0;
}

#endif /* _C2_DBGR_ */

  /* copy value of all shared variables into local space */

int  _c2_GetAllLocks(_c2_na, NextLock)
   _c2_NodeBase * _c2_na;
   _c2_LockSet **NextLock;
{
   _c2_LockSet *cur;

   cur = *NextLock;

   while (cur != 0) {

#     ifdef _C2_DBGR_
      if (_c2_readSpBpAct(_c2_na, cur->psplist,
				(cur->ReqType == _c2_WRITER))) { 
	 _c2_AddToNSQ(_c2_na, cur->Q);
	 warning("non-determinism detected; didn't find the desired shared pred");
	 return 0;
      }
	  
#    endif
      switch (cur->TypeTag) {
       case _c2_IsAnInt:
	 *((int *)(cur->LocalAddr)) = *((int *)(cur->SharedAddr));
	 break;
       case  _c2_IsADouble:
	 *((double *)(cur->LocalAddr)) = *((double *)(cur->SharedAddr));
	 break;
       case _c2_IsAnArrayPtr:
       case _c2_IsAStructPtr:
	 *((void **)(cur->LocalAddr)) = *((void **)(cur->SharedAddr));
	 break;
       case _c2_IsAChar:
	 *((char *)(cur->LocalAddr)) = *((char *)(cur->SharedAddr));
	 break;
      }
      cur = cur->Next;
   }
   return 1;
}


  /* copy local value of shared vars back to nsrel node */

#ifdef _C2_DBGR_
void _c2_RelAllLocks(na, HeadLock, NextLock)
   _c2_NodeBase *na;
#else
void _c2_RelAllLocks(HeadLock, NextLock)
#endif
   _c2_LockSet **HeadLock;
   _c2_LockSet **NextLock;
{
   _c2_LockSet *cur;

   /* Release all locks in node's list */

   cur = *HeadLock;
   while (cur != 0) {
      switch (cur->TypeTag) {
       case _c2_IsAnInt:
	 *((int *)(cur->SharedAddr)) = *((int *)(cur->LocalAddr));
	 break;
       case  _c2_IsADouble:
	 *((double *)(cur->SharedAddr)) = *((double *)(cur->LocalAddr));
	 break;
       case _c2_IsAChar:
	 *((char *)(cur->SharedAddr)) = *((char *)(cur->LocalAddr));
	 break;
      case _c2_IsAnArrayPtr:
      case _c2_IsAStructPtr:
	*((void **)(cur->SharedAddr)) = *((void **)(cur->LocalAddr));
	break;
      }
#     ifdef _C2_DBGR_
      if  (cur->ReqType == _c2_WRITER) {
	 _c2_writeSpBpAct(na, cur->psplist);
      }
      if (*(cur->Q) != 0) {
	    _c2_ClearNSQ(cur->Q);
	    warning("nondeterminism resolved\n");
	 }
#     endif

      cur = cur->Next;
   }

   *NextLock = *HeadLock;  /* Set NextLock to first lock */
}
