/*

fsynch.h

This set of routines is designed to emulate the FastThreads package
(used in the Sequent Symmetry implementation) on a Sparc platform with
Solaris threads.

By providing this emulation, we will be able to use the sequent backend
almost as-is, as we will be "plugging-in" the only architecture dependent
bit.

===
Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
Systems Analyst                 @          <mailto: emery@cs.utexas.edu>
Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
Department of Computer Sciences |             <http://www.cs.utexas.edu>
University of Texas at Austin   |                <http://www.utexas.edu>

*/

#ifndef _fastsynch_x
#define _fastsynch_x

#include <synch.h>
#include "fthread.h"

/* define lock routines */

typedef mutex_t Lock;


extern void LockInit (Lock *lock, ...);
#define LockAcquire(lock) mutex_lock(lock)
#define LockRelease(lock) mutex_unlock(lock)

/*
extern void LockAcquire (Lock *lock);
extern void LockRelease (Lock *lock);
*/

#endif
