/* FastThreads Example Program

   Spawns 10 threads which increment counters that are guarded by a lock.
   One counter is allocated statically, the other dynamically.
*/

#include <stdio.h>
#include <fthread.h>
#include <fsynch.h>

extern char *shmalloc( /* unsigned size */ );
extern shfree( /* char *ptr */ );

static Lock fooLock;   /* Note that these things have to be in shared mem */
static int fooCount;

/* The threads run this procedure */

void foo (I_Ptr)
   int *I_Ptr;
{
   int i;

   for (i=0; i< 100; i++) {
      LockAcquire(&fooLock);
      fooCount += 1;
      (*I_Ptr) += 1;
      LockRelease(&fooLock);
   }
} /* foo */


static Thread *proc[10];   /* Note this has to be shared.  Could put it */
                           /*   on stack in main */


Main ()    /* Note it's Main not main */
{
   int i;
   int *I_Ptr;

   printf("Starting program now-- run with -nX to use X processors.\n");

   LockInit(&fooLock, "fooLock");
   fooCount = 0;

   I_Ptr = (int *) shmalloc(sizeof(int));
   *I_Ptr = 0;

   for (i=0; i<10; i++)
      proc[i] = ThreadStart(foo, 1, "foo", 1, I_Ptr);

   for (i=0; i<10; i++)
      ThreadJoin(proc[i]);

   printf("Program done.\n");
   printf("fooCount = %d (should be 1000)\n", fooCount);
   printf("*I_Ptr = %d (should be 1000)\n", *I_Ptr);

   shfree(I_Ptr);

   ProgramDone();     /* Do not forget this! */
}
