#
# ArcElbow.tcl
# ------------------------------------------------------------------------
# The "elbow" points of an Arc.
# ------------------------------------------------------------------------
# @(#) $Id: ArcElbow.tcl,v 1.5 1996/03/05 17:07:09 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class Code::ArcElbow {

    inherit Code::CodeObj


    constructor {w x y parc args} { eval Code::CodeObj::constructor $w } {}
    destructor {

	# Delete the elbow from arc's list.
	# (note the use of the variable "name" --
	#  for some reason (bug? feature?),
	#  destructor doesn't maintain $this.)

	catch { $arc delete-elbow $name }

	# delete objects
	$canvas delete $box
    }

    itk_option define -editable editable Editable 1

    public method deselect {}
    public method move {dx dy}
    public method select {}

    public method coords {}
    public method reshape {}
    public method no-reshape {}
    public method update_coords {points}
    public method set_incoming {line}
    public method set_outgoing {line}
    public method incoming {}
    public method outgoing {}

    #
    # we disable these, since
    # ArcElbows are second-class
    # objects (yes, byte trash.)
    #

    public method attributes {} {}
    public method print_attributes {} {}
    public method save {out} {}

    private method update-visibility {}

    public variable incoming ""      ;# incoming line
    public variable outgoing ""      ;# outgoing line

    public variable editable 1       ;# if we are allowed to modify this elbow

    private variable visibility 0    ;# if the elbow is visible
    private variable selectable 0    ;# if we are allowed to select this elbow
    private variable box ""
    private variable coords ""       ;# the (x,y) coords of the elbow
    private variable arc ""          ;# the arc to which the elbow belongs

}


configbody Code::ArcElbow::editable {
    set editable $itk_option(-editable)
}


body Code::ArcElbow::constructor {w x y parc args} {
    set box [eval $canvas create bitmap $x $y -anchor center -parent $this]
    $canvas addtag $this withtag $box

    foreach classname [info heritage] {
	$canvas addtag $classname withtag $box
    }
    
    update-visibility
    
    set arc $parc
    set coords "$x $y"

    eval itk_initialize $args
}
    

body Code::ArcElbow::coords {} {
    return $coords
}

body Code::ArcElbow::move {dx dy} {
    scan $coords "%f %f" x y
    update_coords "[expr $x+$dx] [expr $y+$dy]"
}
    
body Code::ArcElbow::select {} {
    if {$selectable} {
	Code::CodeObj::select
	$canvas itemconfigure $box -foreground [$canvas info variable SelectedFGColor -value]
    }
}

body Code::ArcElbow::reshape {} {
    if {$editable} {
	set visibility 1
	update-visibility
	set selectable 1
    }
}

body Code::ArcElbow::no-reshape {} {
    if {$editable} {
	set visibility 0
	update-visibility
	set selectable 0
    }
}

body Code::ArcElbow::deselect {} {
    if {$selectable} {
	Code::CodeObj::deselect
	$canvas itemconfigure $box -foreground [$canvas info variable FGColor -value]
    }
}
    
body Code::ArcElbow::update_coords {points} {
    scan $coords "%f %f" x y
    scan $points "%f %f" newx newy
    Code::CodeObj::move [expr $newx-$x] [expr $newy-$y]
    
    # change incoming endpoint
    if { $incoming != "" } {
	scan [$canvas coords $incoming] "%f %f %f %f" x1 y1 d d
	eval "$canvas coords $incoming [concat $x1 $y1 $points]"
    }
    
    # change outgoing startpoint
    
    if { $outgoing != "" } {
	scan [$canvas coords $outgoing] "%f %f %f %f" d d x2 y2
	eval "$canvas coords $outgoing [concat $points $x2 $y2]"
    }
    
    set coords $points
}
    
body Code::ArcElbow::set_incoming {line} {
    set incoming $line
}

body Code::ArcElbow::set_outgoing {line} {
    set outgoing $line
}

body Code::ArcElbow::incoming {} {
    return $incoming
}

body Code::ArcElbow::outgoing {} {
    return $outgoing
}

body Code::ArcElbow::update-visibility {} {
    if {$visibility} {
	$canvas itemconfigure $box -bitmap "@[$canvas info variable ReleaseDirectory -value]/bitmaps/ArcElbow.bit"
    } else {
	$canvas itemconfigure $box -bitmap ""
    }
}
