#
# CompNode.tcl
# ------------------------------------------------------------------------
# The node which holds sequential computations.
# ------------------------------------------------------------------------
# @(#) $Id: CompNode.tcl,v 1.5 1996/02/01 02:38:34 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class Code::CompNode {

    inherit Code::Node

    constructor {args} { 
	if {!$_initialized} {
	    init
	}
	eval Code::Node::constructor $args
    } {}

    public method attributes {}
    public method bitmap {}
    public method thisimage {}
    public method translate {ProgramAST GraphAST}

    protected method draw_node {x y}

    private method init {}
    private common _initialized 0

    common image
    
    public variable IsStartNode 0
    public variable IsTerminationNode 0
    public variable InitComputation ""
    public variable Computation ""
    public variable LocalVariables ""
    public variable SharedVariables ""
    public variable FiringRules ""
    public variable InputPorts ""
    public variable RoutingRules ""
    public variable OutputPorts ""

    public variable Documentation ""
    public variable TraceEnable 0
    public variable IsBreakPoint 0
    public variable TracePointBeforeNode 0
    public variable TraceWhen ""
    public variable TraceFrequency ""
    public variable VariablesToTrace ""

    protected variable attributes {Name IsStartNode IsTerminationNode \
	    InitComputation Computation LocalVariables SharedVariables \
	    FiringRules InputPorts RoutingRules OutputPorts \
	    Documentation TraceEnable IsBreakPoint TracePointBeforeNode \
	    TraceWhen TraceFrequency VariablesToTrace}
}


body Code::CompNode::constructor {args} {
    addport InputPort top
    addport OutputPort bottom
    itk_initialize
}


body Code::CompNode::attributes {} {
    Node::attributes
}


body Code::CompNode::bitmap {} {
    return "@[$canvas info variable ReleaseDirectory -value]/bitmaps/CompNode.bit"
}


body Code::CompNode::draw_node {x y} {
    set node [$canvas create image $x $y \
	    -image [thisimage] \
	    -parent $this]
}


body Code::CompNode::init {} {
    global c2_ReleaseDirectory
    set image(0) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/CompNode.gif"]
    set image(1) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/CompNode-Selected.gif"]
    set _initialized 1
}


body Code::CompNode::thisimage {} {
    return $image($selected)
}


body Code::CompNode::translate {ProgramAST GraphAST} {
    set Specification [format "input_ports \{%s\}\noutput_ports \{%s\}\nshared_vars \{%s\}\nvars \{%s\}\ninit_comp \{%s\}\nfiring_rules \{%s\}\ncomp \{%s\}\nrouting_rules \{%s\}" $InputPorts $OutputPorts $SharedVariables $LocalVariables $InitComputation $FiringRules $Computation $RoutingRules]

    ## FOR DEBUGGING ONLY!!! REMOVE ME!!!
    puts $Specification

    return [c2_CreateCompNodeAST $ProgramAST $GraphAST $Name $id \
	    $IsStartNode $IsTerminationNode "$Specification" "$Documentation" \
	    $TraceEnable $IsBreakPoint $TracePointBeforeNode "$TraceWhen" \
	    "$TraceFrequency" "$VariablesToTrace"]
}


