#
# LabeledEntry.tcl
# ------------------------------------------------------------------------
# A GUI widget (to be replaced by a Tix widget?) which is essentially a
# thin wrapper around an iwidgets::Labeledwidget.
# ------------------------------------------------------------------------
# @(#) $Id: LabeledEntry.tcl,v 1.4 1996/01/10 19:42:59 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class LabeledEntry {
    inherit iwidgets::Labeledwidget

    constructor {args} {
	eval iwidgets::Labeledwidget::constructor
    } {
	itk_component add entry {
	    entry [childsite].entry
	} {
	    keep -textvariable -width
	    rename -textvariable -text text Text
	}
	pack [childsite].entry -expand yes -fill both
	eval itk_initialize $args

	# WORKAROUND since itk_initialize doesn't seem
	# to do the trick...

	component entry configure -text $itk_option(-text)
	component entry configure -width $itk_option(-width)
    }

    destructor {}


    itk_option define -label label Label ""
    itk_option define -state state State normal
}


configbody LabeledEntry::label {
    $this configure -labeltext $itk_option(-label)
}


configbody LabeledEntry::state {
    component entry configure -state $itk_option(-state)
    switch $itk_option(-state) {
	normal {
	    component label configure -fg Black
	}
	disabled {
	    component label configure -fg Gray
	}
	default {}
    }
    # configure -labelstate $itk_option(-state)
}
