#
# NameSharingNode.tcl
# ------------------------------------------------------------------------
# The shared variable node.
# ------------------------------------------------------------------------
# @(#) $Id: NameSharingNode.tcl,v 1.5 1996/02/01 02:38:42 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class Code::NameSharingNode {

    inherit Code::Node

    constructor {args} { 
	if {!$_initialized} {
	    init
	}
	eval Code::Node::constructor $args
    } {}

    public method attributes {}
    public method bitmap {}
    public method translate {ProgramAST GraphAST}
    public method thisimage {}

    protected method draw_node {x y}

    private method init {}


    public common image
    private common _initialized 0

    public variable SharedVars ""
    public variable LocalVars ""
    public variable InitComp ""
    public variable Docs ""
    
    protected variable attributes {Name Docs SharedVars LocalVars InitComp}
    

}

body Code::NameSharingNode::constructor {args} {
    addport InputPort top
    addport InputPort left
    addport InputPort right
    addport InputPort bottom

    eval itk_initialize
}


body Code::NameSharingNode::attributes {} {
    Node::attributes
}


body Code::NameSharingNode::bitmap {} {
    return "@[$canvas info variable ReleaseDirectory -value]/bitmaps/NameSharingNode.bit"
}


body Code::NameSharingNode::draw_node {x y} {
    set node [$canvas create image $x $y \
	    -image [thisimage] \
	    -parent $this]
}


body Code::NameSharingNode::init {} {
    global c2_ReleaseDirectory
    set image(0) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/NameSharingNode.gif"]
    set image(1) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/NameSharingNode-Selected.gif"]
    set _initialized 1
}


body Code::NameSharingNode::thisimage {} {
    return $image($selected)
}


body Code::NameSharingNode::translate {ProgramAST GraphAST} {
    set Spec [format "shared_vars \{%s\}\nvars \{%s\}\ninit_comp \{%s\}" \
	    $SharedVars $LocalVars $InitComp]
    return [c2_CreateNameSharingNodeAST $ProgramAST $GraphAST $Name $id \
	    "$Spec" "$Docs"]
}
