#
# OutInterfaceNode.tcl
# ------------------------------------------------------------------------
# Provides output from a subgraph.
# ------------------------------------------------------------------------
# @(#) $Id: OutInterfaceNode.tcl,v 1.6 1996/01/11 21:15:52 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class Code::OutInterfaceNode {

    inherit Code::Node

    constructor {args} {
	if {!$_initialized} {
	    init
	}
	eval Code::Node::constructor $args
    } {
	addport InputPort top 1
    }

    public method bitmap {}
    public method translate {ProgramAST GraphAST}
    public method thisimage {}

    protected method draw_node {x y}

    private method init {}


    public common image
    private common _initialized 0

    public variable Type ""
    protected variable attributes {Name Type}


}


body Code::OutInterfaceNode::bitmap {} {
    return "@[$canvas info variable ReleaseDirectory -value]/bitmaps/OutInterfaceNode.bit"
}


body Code::OutInterfaceNode::draw_node {x y} {
    set node [$canvas create image $x $y \
	    -image [thisimage] \
	    -parent $this]
}


body Code::OutInterfaceNode::init {} {
    global c2_ReleaseDirectory
    set image(0) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/OutInterfaceNode.gif"]
    set image(1) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/OutInterfaceNode-Selected.gif"]
    set _initialized 1
}


body Code::OutInterfaceNode::thisimage {} {
    return $image($selected)
}


body Code::OutInterfaceNode::translate {ProgramAST GraphAST} {
    return [c2_CreateOutInterfaceNodeAST $ProgramAST $GraphAST $Name $id "$Type"]
}

