#
# Port.tcl
# ------------------------------------------------------------------------
# The base class for {Input|Output}Port.
# ------------------------------------------------------------------------
# @(#) $Id: Port.tcl,v 1.5 1996/02/01 02:38:46 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class Code::Port {

    inherit Code::CodeObj

    constructor {w dir node x y args}  { eval Code::CodeObj::constructor $w $args } {} 
    destructor {
	$canvas delete $port
	foreach arc $attached_arcs {
	    catch { rename $arc "" }
	}
    }

    itk_option define -limit limit Limit -1

    public method attributes {}
    public method scale {}
    public method thisimage {}
    public method accepts {}
    public method attach-arc {arc}
    public method detach-arc {arc}
    public method arc_position {}
    public method attached-node {}
    public method attach-node {n}
    public method activate {}
    public method deactivate {}
    public method move {dx dy}

    # undefined in Port base class

    # WORKAROUND

    # public method draw_port {x y args}

    private method update_port {}


    public variable direction
    public variable limit -1  ;# -1 = no limit; positive number = max attached arcs allowed.

    protected variable attached_arcs ""
    protected variable active 0  ;# whether the cursor is close enough to the hot spot
    protected variable port
    protected variable node ""   ;# the node to which this port is attached

}

#
# OPTIONS
#
#

configbody Code::Port::limit {
    set limit $itk_option(-limit)
}


#
# METHODS
#
#

body Code::Port::constructor {w dir node x y args} {
    set direction $dir
    set node $node

    # eval draw_port $x $y $args  (WORKAROUND - moved)

    #  this binding is to trash the defaults
    #  in CodeObj.

    $canvas bind $this <Button-1> "if !\[string compare \[$w tool\] \"Query\"\] \{ $this attributes \} ; break"
    $canvas bind $this <ButtonRelease-1> "break"

    eval itk_initialize $args

}



# This provides a guard to enforce numeric limits on attached arcs.

body Code::Port::accepts {} {
    if { $limit == -1 } {
	return 1
    } else {
	return [expr [llength $attached_arcs] < $limit]
    }
}

# arc management

body Code::Port::attach-arc {arc} {
    lappend attached_arcs $arc
    return $arc
}

body Code::Port::detach-arc {arc} {
    set pos [lsearch -exact $attached_arcs $arc]
    set attached_arcs [lreplace $attached_arcs $pos $pos]
}


#
#  return the coordinates where the
#  arc should connect to the port.
#

body Code::Port::arc_position {} {
    scan [eval "$canvas coords $port"] "%f %f %f %f" x y dummy dummy
    
    # modify offset of arc according to position
    # of port
    
    switch $direction {
	bottom {
	    set y [expr $y+3]
	}
	top {
	    set y [expr $y-3]
	}
	left {
	    set x [expr $x-3]
	}
	right {
	    set x [expr $x+3]
	}
    }
    return "$x $y"
}


body Code::Port::attached-node {} {
    return $node
}


body Code::Port::attach-node {n} {
    set node $n
}


body Code::Port::scale {} {
    set s [$canvas info variable scale -value]
    set thisimage [$canvas itemcget $port -image]
    set baseimage [image create photo -format GIF -file [$thisimage cget -file]]
    if { $s >= 1 } {
	set ints [expr int($s)]
	$thisimage copy $baseimage -shrink -zoom $ints $ints
    } else {
	set rs [expr int(1/$s)]
	$thisimage copy $baseimage -shrink -subsample $rs $rs
    }
}

body Code::Port::attributes {} {
    if { [string compare $node ""] } {
	$node attributes
    }
}

body Code::Port::update_port {} {
    $canvas itemconfigure $port -image [thisimage]
    $this scale
}

body Code::Port::activate {} {
    set active 1
    update_port
}

body Code::Port::deactivate {} {
    set active 0
    update_port
}

body Code::Port::move {dx dy} {
    Code::CodeObj::move $dx $dy
}
