#include <config.h>
#include <stream.h>
#include <setjmp.h>

#include "../misc/general.h"
#include "../exmodel/abstree.h"
#include "../exmodel/exmodel.h"
#include "../parser/parser.h"

#include "Syntax.h"
#include "UidTable.h"
#include "MsgUI.h"
#include "../translate/translate.h"

#include <tcl.h>
#include <tk.h>

#include "astcreate.h"


cProgram *ProgramRoot;
MString FilesToLink;
TranslateType TranslatorT;
TraceLevel_t TraceLevel;
int OptimizeProg;
int ProduceSummaryStats;
int AddDbgrCode;


int
C2_TranslateAST(
   ClientData dummy,
   Tcl_Interp *interp,
   int argc,
   char *argv[])
{
  int result = 1;
  dummy = dummy; argc = argc;  // silly code : eliminates compiler warning
  // argv[0]  c2_TranslateAST
  // argv[1]  program AST
  // argv[2]  target
  
  if ( argv[1] != "" ) {
    
    /*
       
       int result;
       result = strcmp(argv[2], "Serial");
       result = strcmp(argv[2], "Sequent");
       result = strcmp(argv[2], "PVM");
       result = strcmp(argv[2], "List");
       */
    
    if ( strcmp(argv[2], "Serial") == 0 ) {
      TranslatorT = SERIAL;
      result = Translate(DOSERIAL);
    } else if ( strcmp(argv[2], "Sequent") == 0 ) {
      TranslatorT = SEQUENT;
      result = Translate(DOSEQUENT);
    } else if ( strcmp(argv[2], "PVM") == 0 ) {
      TranslatorT = PVM;
      result = Translate(DOPVM);
    } else if ( strcmp(argv[2], "List") == 0 ) {
      TranslatorT = LIST;
      result = Translate(DOLISTING);
    } else if ( strcmp(argv[2], "Sparc") == 0 ) {
      TranslatorT = SPARC;
      result = Translate(DOSPARC);
    } else if ( strcmp(argv[2], "Cray") == 0 ) {
      TranslatorT = CRAY;
      result = Translate(DOCRAY);
    }else {
      YYUIMessage(ErrorLevel,"The wheels have come off the wagon in C2_TranslateAST");
      YYUIMessageDisplay();
    }
  } else {
    YYUIMessageDisplay();
  }
  
  FreeUidTable();
  ProgramRoot = 0;
  
  cout << "\n";
  cout << "\n********* translation completed ****************\n";
  
  cout.flush();
  fflush(stdout);
  cerr.flush();
  fflush(stderr);
  
  sprintf(interp->result, "%d", result);
  return TCL_OK;
}

int 
C2_CreateProgramAST(
   ClientData dummy,
   Tcl_Interp *interp,
   int argc,
   char *argv[])
{
   dummy = dummy; argc = argc;  // silly code : eliminates compiler warning
   // argv[0]  c2_CreateProgramAST
   // argv[1]  program name
   // argv[2]  uid
   // argv[3]  global types
   // argv[4]  global function signatures
   // argv[5]  global function definitions
   // argv[6]  global documentation
   // argv[7]  summary statitics boolean
   // argv[8]  optimize program boolean
   // argv[9]  object files to link
   // argv[10] debugger on boolean
   // argv[11] buffer trace events boolean

   cProgram *Program;
   cAbsTree *FunctionSignatures, *GlobalTypes;
   int ParseOK;
   const int DoListing = 0;
   const int MakeTree = 1;

   cout << "\n********* translation started ****************\n";
   cout.flush();

   CreateUidTable();

   ParseOK = yyDoParse("qqtypedef", argv[3], DoListing, GlobalTypes, MakeTree);
   if ( ParseOK ) {

      ParseOK = yyDoParse("qqfuncsig", argv[4], DoListing, FunctionSignatures, MakeTree);
      if ( ParseOK ) {

         Program = new cProgram;
         Program->Name = argv[1];
         sscanf(argv[2], "%d", &Program->UID);
         Program->Types = ((cGather *) GlobalTypes)->L;
         Program->FuncSigs = ((cGather *) FunctionSignatures)->L;
         Program->FuncDefs = argv[5];
         sscanf(argv[7], "%d", &ProduceSummaryStats);
         sscanf(argv[8], "%d", &OptimizeProg);
         FilesToLink = argv[9];
         sscanf(argv[10], "%d", &AddDbgrCode);
         TraceLevel = tr_no_nodes;

         ProgramRoot = Program;

         sprintf(interp->result, "%#08x", int(Program));
//cout << form("C2_CreateProgramAST : result is %s.\n", interp->result);

      } else {
         YYUIMessage(ErrorLevel,"Syntax error line %d col %d in Program Function Signature field\n",
            yylinenum, yycolumn); 
         YYUIMessageDisplay();
	 sprintf(interp->result, "%s", "");
      }
   } else {
      YYUIMessage(ErrorLevel,"Syntax error line %d col %d in Program Type Definition field\n",
         yylinenum, yycolumn);
      YYUIMessageDisplay();
      sprintf(interp->result, "%s", "");
   }

   return TCL_OK;
}

int 
C2_CreateGraphAST(
   ClientData dummy,
   Tcl_Interp *interp,
   int argc,
   char *argv[])
{
   dummy = dummy; argc = argc;  // silly code : eliminates compiler warning
   // argv[0]  c2_CreateGraphAST
   // argv[1]  program AST
   // argv[2]  graph name
   // argv[3]  uid
   // argv[4]  graph function signatures
   // argv[5]  graph function definitions
   // argv[6]  graph documentation

   cProgram *Program;
   cGraph *Graph;
   cAbsTree *FunctionSignatures;
   int ParseOK;
   const int DoListing = 0;
   const int MakeTree = 1;

   ParseOK = yyDoParse("qqfuncsig", argv[4], DoListing, FunctionSignatures, MakeTree);
   if ( ParseOK ) {

      Graph = new cGraph;
      Graph->Name = argv[2];
      sscanf(argv[3], "%d", &Graph->UID);
      Graph->FuncSigs = ((cGather *) FunctionSignatures)->L;
      Graph->FuncDefs = argv[5];

      sscanf(argv[1], "0x%x", &Program);
      Program->Graphs.Insert(Graph);

      sprintf(interp->result, "%#08x", int(Graph));
//cout << form("C2_CreateGraphAST : result is %s.\n", interp->result);

   } else {
      YYUIMessage(ErrorLevel, "Syntax error line %d col %d in Graph %s Function Signature field\n",
          yylinenum, yycolumn, argv[2]);
      YYUIMessageDisplay();
      sprintf(interp->result, "%s", "");
   }
   return TCL_OK;
}


int 
C2_CreateCallNodeAST(
   ClientData dummy,
   Tcl_Interp *interp,
   int argc,
   char *argv[])
{
   dummy = dummy; argc = argc;  // silly code : eliminates compiler warning
   // argv[0]  c2_CreateCallNodeAST
   // argv[1]  program AST
   // argv[2]  graph AST
   // argv[3]  name
   // argv[4]  uid
   // argv[5]  called graph name
   // argv[6]  trace call boolean

   cGraph *Graph;
   cCallNode *CallNode;

   CallNode = new cCallNode;
   CallNode->Name = argv[3];
   sscanf(argv[4], "%d", &CallNode->UID);
   CallNode->CalledGraph = argv[5];

   sscanf(argv[2], "0x%x", &Graph);
   Graph->CallNodes.Insert(CallNode);

   sprintf(interp->result, "%#08x", int(CallNode));
//cout << form("C2_CreateCallNodeAST : result is %s.\n", interp->result);
   return TCL_OK;
}


int 
C2_CreateCompNodeAST(
   ClientData dummy,
   Tcl_Interp *interp,
   int argc,
   char *argv[])
{
   dummy = dummy; argc = argc;  // silly code : eliminates compiler warning
   // argv[0]  c2_CreateCompNodeAST
   // argv[1]  program AST
   // argv[2]  graph AST
   // argv[3]  name
   // argv[4]  uid
   // argv[5]  start node boolean
   // argv[6]  terminating node boolean
   // argv[7]  specification
   // argv[8]  documentation
   // argv[9]  trace enable boolean
   // argv[10] break point boolean
   // argv[11] trace point before node boolean
   // argv[12] trace when
   // argv[13] trace frequency
   // argv[14] variables to trace

   cGraph *Graph;
   cUC *UC;
   cAbsTree *Specification;
   int ParseOK;
   const int DoListing = 0;
   const int MakeTree = 1;

   ParseOK = yyDoParse("qquc", argv[7], DoListing, Specification, MakeTree);
   if ( ParseOK ) {

      UC = (cUC *)Specification;
      UC->Name =argv[3];
      sscanf(argv[4], "%d", &UC->UID);
      sscanf(argv[5], "%d", &UC->StartNode);
      sscanf(argv[6], "%d", &UC->TermNode);

      sscanf(argv[2], "0x%x", &Graph);
      Graph->UCNodes.Insert(UC);

      sprintf(interp->result, "%#08x", int(UC));
//cout << form("C2_CreateCompNodeAST : result is %s.\n", interp->result);
   } else {
      YYUIMessage(ErrorLevel, "UID %s: Syntax error line %d col %d in UC %s Function Signature field\n",
          argv[4], yylinenum, yycolumn, argv[3]);
      YYUIMessageDisplay();
      sprintf(interp->result, "%s", "");
   }
   return TCL_OK;
}


int 
C2_CreateCreationParameterNodeAST(
   ClientData dummy,
   Tcl_Interp *interp,
   int argc,
   char *argv[])
{
   dummy = dummy; argc = argc;  // silly code : eliminates compiler warning
   // argv[0]  c2_CreateCreationParameterNodeAST
   // argv[1]  program AST
   // argv[2]  graph AST
   // argv[3]  name
   // argv[4]  uid
   // argv[5]  type

   cGraph *Graph;
   cCrepNode *CrepNode;

   CrepNode = new cCrepNode;
   CrepNode->Name = argv[3];
   sscanf(argv[4], "%d", &CrepNode->UID);
   CrepNode->Type = argv[5];

   sscanf(argv[2], "0x%x", &Graph);
   Graph->CrepNodes.Insert(CrepNode);

   sprintf(interp->result, "%#08x", int(CrepNode));
//cout << form("C2_CreateCreationParameterNodeAST : result is %s.\n", interp->result);
   return TCL_OK;
}


int 
C2_CreateNameSharingNodeAST(
   ClientData dummy,
   Tcl_Interp *interp,
   int argc,
   char *argv[])
{
   dummy = dummy; argc = argc;  // silly code : eliminates compiler warning
   // argv[0]  c2_CreateNameSharingNodeAST
   // argv[1]  program AST
   // argv[2]  graph AST
   // argv[3]  name
   // argv[4]  uid
   // argv[5]  specification
   // argv[6]  documentation

   cGraph *Graph;
   cNSRel *NSRel;
   cAbsTree *Specification;
   int ParseOK;
   const int DoListing = 0;
   const int MakeTree = 1;

   ParseOK = yyDoParse("qqnsicomp", argv[5], DoListing, Specification, MakeTree);
   if ( ParseOK ) {

      NSRel = (cNSRel *)Specification;
      NSRel->Name = argv[3];
      sscanf(argv[4], "%d", &NSRel->UID);

      sscanf(argv[2], "0x%x", &Graph);
      Graph->NSRelNodes.Insert(NSRel);

      sprintf(interp->result, "%#08x", 0xDEADBEEF);
//cout << form("C2_CreateNameSharingNodeAST : result is %s.\n", interp->result);
   } else {
      YYUIMessage(ErrorLevel, "UID %s: syntax error line %d col %d in NS Node %s spec field\n",
         argv[4], yylinenum, yycolumn,argv[3]);
      YYUIMessageDisplay();
      sprintf(interp->result, "%s", "");
   }
   return TCL_OK;
}


int 
C2_CreateInInterfaceNodeAST(
   ClientData dummy,
   Tcl_Interp *interp,
   int argc,
   char *argv[])
{
   dummy = dummy; argc = argc;  // silly code : eliminates compiler warning
   // argv[0]  c2_CreateCreationParameterNodeAST
   // argv[1]  program AST
   // argv[2]  graph AST
   // argv[3]  name
   // argv[4]  uid
   // argv[5]  type

   cGraph *Graph;
   cIntNode *IntNode;

   IntNode = new cIntNode;
   IntNode->Name = argv[3];
   sscanf(argv[4], "%d", &IntNode->UID);
   IntNode->Type = argv[5];
   IntNode->InParam = 1;

   sscanf(argv[2], "0x%x", &Graph);
   Graph->IntNodes.Insert(IntNode);

   sprintf(interp->result, "%#08x", int(IntNode));
//cout << form("C2_CreateInInterfaceNodeAST : result is %s.\n", interp->result);
   return TCL_OK;
}


int 
C2_CreateOutInterfaceNodeAST(
   ClientData dummy,
   Tcl_Interp *interp,
   int argc,
   char *argv[])
{
   dummy = dummy; argc = argc;  // silly code : eliminates compiler warning
   // argv[0]  c2_CreateCreationParameterNodeAST
   // argv[1]  program AST
   // argv[2]  graph AST
   // argv[3]  name
   // argv[4]  uid
   // argv[5]  type

   cGraph *Graph;
   cIntNode *IntNode;

   IntNode = new cIntNode;
   IntNode->Name = argv[3];
   sscanf(argv[4], "%d", &IntNode->UID);
   IntNode->Type = argv[5];
   IntNode->InParam = 0;

   sscanf(argv[2], "0x%x", &Graph);
   Graph->IntNodes.Insert(IntNode);

   sprintf(interp->result, "%#08x", int(IntNode));
//cout << form("C2_CreateOutInterfaceNodeAST : result is %s.\n", interp->result);
   return TCL_OK;
}


int 
C2_CreateArcAST(
   ClientData dummy,
   Tcl_Interp *interp,
   int argc,
   char *argv[])
{
   dummy = dummy; argc = argc;  // silly code : eliminates compiler warning
   // argv[0]  c2_CreateArcAST
   // argv[1]  program AST
   // argv[2]  graph AST
   // argv[3]  name
   // argv[4]  uid
   // argv[5]  topology rule
   // argv[6]  from uid
   // argv[7]  to uid

   cGraph *Graph;
   cArc *Arc;
   cAbsTree *TopologyRule;
   int ParseOK;
   const int DoListing = 0;
   const int MakeTree = 1;

   ParseOK = yyDoParse("qqarctopo", argv[5], DoListing, TopologyRule, MakeTree);
   if ( ParseOK ) {

      Arc = (cArc *)TopologyRule;
      Arc->Name = argv[3];
      sscanf(argv[4], "%d", &Arc->UID);
      sscanf(argv[6], "%d", &Arc->FromUID);
      sscanf(argv[7], "%d", &Arc->ToUID);

      sscanf(argv[2], "0x%x", &Graph);
      Graph->Arcs.Insert(Arc);

      sprintf(interp->result, "%#08x", int(Arc));
//cout << form("C2_CreateArcAST : result is %s.\n", interp->result);
   } else {
      YYUIMessage(ErrorLevel, "UID %s: syntax error line %d col %d in arc %s topology def field\n",
           argv[4], yylinenum, yycolumn, argv[3]);
      YYUIMessageDisplay();
      sprintf(interp->result, "%s", "");
   }
   return TCL_OK;
}

int 
C2_ParseCompNodeSpecification(
   ClientData dummy, 
   Tcl_Interp *interp, 
   int argc, 
   char *argv[])
{
   dummy = dummy; argc = argc;  // silly code : eliminates compiler warning
   // argv[0] C2_ParseCompNodeSpecification
   // argv[1] node specification

   cAbsTree *Specification;
   int ParseOK;
   const int DoListing = 0;
   const int MakeTree = 1;

   ParseOK = yyDoParse("qquc", argv[1], DoListing, Specification, MakeTree);
   if ( ParseOK ) {
      sprintf(interp->result, "%d", 1);
   } else {
      sprintf(interp->result, "%d", 0);
   }
   return TCL_OK;
}

int 
C2_ParseArcTopologyRule(
   ClientData dummy, 
   Tcl_Interp *interp, 
   int argc, 
   char *argv[])
{
   dummy = dummy; argc = argc;  // silly code : eliminates compiler warning
   // argv[0] C2_ParseArcTopologyRule
   // argv[1] topology rule

   cAbsTree *TopologyRule;
   int ParseOK;
   const int DoListing = 0;
   const int MakeTree = 1;

   ParseOK = yyDoParse("qqarctopo", argv[1], DoListing, TopologyRule, MakeTree);
   if ( ParseOK ) {
      sprintf(interp->result, "%d", 1);
   } else {
      sprintf(interp->result, "%d", 0);
   }
   return TCL_OK;
}

int 
C2_ParseFunctionSignatures(
   ClientData dummy, 
   Tcl_Interp *interp, 
   int argc, 
   char *argv[])
{
   dummy = dummy; argc = argc;  // silly code : eliminates compiler warning
   // argv[0] C2_ParseFunctionSignatures
   // argv[0] function signatures

   cAbsTree *FunctionSignatures;
   int ParseOK;
   const int DoListing = 0;
   const int MakeTree = 1;

   ParseOK = yyDoParse("qqfuncsig", argv[1], DoListing, FunctionSignatures, MakeTree);
   if ( ParseOK ) {
      sprintf(interp->result, "%d", 1);
   } else {
      sprintf(interp->result, "%d", 0);
   }
   return TCL_OK;
}

int 
C2_ParseTypeDefinitions(
   ClientData dummy, 
   Tcl_Interp *interp, 
   int argc, 
   char *argv[])
{
   dummy = dummy; argc = argc;  // silly code : eliminates compiler warning
   // argv[0] C2_ParseTypeDefinitions
   // argv[0] type definitions

   cAbsTree *GlobalTypes;
   int ParseOK;
   const int DoListing = 0;
   const int MakeTree = 1;

   ParseOK = yyDoParse("qqtypedef", argv[1], DoListing, GlobalTypes, MakeTree);
   if ( ParseOK ) {
      sprintf(interp->result, "%d", 1);
   } else {
      sprintf(interp->result, "%d", 0);
   }
   return TCL_OK;
}

int 
C2_ParseNameSharingSpecification(
   ClientData dummy, 
   Tcl_Interp *interp, 
   int argc, 
   char *argv[])
{
   dummy = dummy; argc = argc;  // silly code : eliminates compiler warning
   // argv[0] C2_ParseNameSharingSpecification
   // argv[0] node specification

   cAbsTree *Specification;
   int ParseOK;
   const int DoListing = 0;
   const int MakeTree = 1;

   ParseOK = yyDoParse("qquc", argv[1], DoListing, Specification, MakeTree);
   if ( ParseOK ) {
      sprintf(interp->result, "%d", 1);
   } else {
      sprintf(interp->result, "%d", 0);
   }
   return TCL_OK;
}
