/*
#
# code2.C
# ------------------------------------------------------------------------
# The main program -- starts up the GUI, connecting to it the translation
# procedures. Originally written by Brian West, somewhat modified by me.
# ------------------------------------------------------------------------
# @(#) $Id: code2.C,v 1.5 1996/03/05 17:07:25 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================
*/


#include <config.h>
#include <stream.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

#include "../misc/mstring.h"
#include "../misc/fileutil.h"

#include "../misc/general.h"
#include "../exmodel/abstree.h"
#include "../exmodel/exmodel.h"
#include "../parser/parser.h"

#include <tcl.h>
/* #include <expect_tcl.h> */
#include <tk.h>
#include <itcl.h>
#include <itk.h>
#include <tix.h>

#include "massage.h"
#include "astcreate.h"

void Die(char *Message);  // Print Message, clean up, and quit.
#include "../misc/sfile.h"
#include "../exmodel/object.h"
#include "../symtab/stype.h"

#define DEFAULT_CODE2_EDITOR "emacs"

#define DEFAULT_SEQUENTCC "/bin/cc"
#define DEFAULT_SEQUENTLD "/bin/ld"
#define DEFAULT_PVMCC "gcc"
#define DEFAULT_SERIALCC "gcc"

/* I really want this scheme to go away -- the Makefiles
   that Code produces are too brittle -- I'd rather use
   autoconf. Anyway... */

#define DEFAULT_SPARCCC "cc"
#define DEFAULT_SPARCLD "ld"

#define DEFAULT_CRAYCC "cc"
#define DEFAULT_CRAYLD "ld"


#define DEFAULT_CODEDIR "/v/peaches/v1/code2/code"

/*
 * Global variables used by the main program:
 */

char sequentcc[48];
char sequentld[48];
char pvmcc[48];
char serialcc[48];
char sparccc[48];
char sparcld[48];
char craycc[48];
char crayld[48];
char codedir[80];
char editor[80];

cBlock *cCursor::Root = 0;
cSType *cSType::Head = 0;


/* extern "C" int Tcl_dotGraph_Init(Tcl_Interp*); */

int Tcl_AppInit(Tcl_Interp *interp)
{
   if (Tcl_Init(interp) == TCL_ERROR)  return TCL_ERROR;
   if (Tk_Init(interp) == TCL_ERROR)   return TCL_ERROR;
   if (Itcl_Init(interp) == TCL_ERROR) return TCL_ERROR;
   if (Itk_Init(interp) == TCL_ERROR) {
     return TCL_ERROR;
   }
   /* Dot package */
   /*
   if (Tcl_dotGraph_Init(interp) == TCL_ERROR) {
     return TCL_ERROR;
   }
   */
   if (Tix_Init(interp) == TCL_ERROR)  return TCL_ERROR;
   /* if (Exp_Init(interp) == TCL_ERROR)  return TCL_ERROR; */

   return TCL_OK;
}

void Setup();


Tcl_Interp *main_interp;	/* Interpreter for this application. */


int
main(
   int argc,
   char **argv)
{
   char *SourceFile;
   char *c2_ProgramFileName;
   char *c2_ProgramName;
   char *c2_ReleaseDirectory;
   char *c2_GuiReleaseDirectory;
   char *c2_Code2_TCL;
   int j, n;
   Tk_Window mainWindow; 
   int code;


   main_interp = Tcl_CreateInterp();
   mainWindow = Tk_CreateMainWindow(main_interp, (char *)NULL, "code", "Code 2.1");
   if (Tcl_AppInit(main_interp) != TCL_OK) return(1);


   Tcl_CreateCommand(main_interp, "c2_CreateProgramAST", C2_CreateProgramAST,
		  (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateGraphAST", C2_CreateGraphAST,
		  (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateCallNodeAST", C2_CreateCallNodeAST,
		  (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateCompNodeAST", C2_CreateCompNodeAST,
		  (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateCreationParameterNodeAST", C2_CreateCreationParameterNodeAST,
		  (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateNameSharingNodeAST", C2_CreateNameSharingNodeAST,
		  (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateInInterfaceNodeAST", C2_CreateInInterfaceNodeAST,
		  (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateOutInterfaceNodeAST", C2_CreateOutInterfaceNodeAST,
		  (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_CreateArcAST", C2_CreateArcAST,
		  (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_TranslateAST", C2_TranslateAST,
		  (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_ParseCompNodeSpecification", C2_ParseCompNodeSpecification,
		  (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_ParseArcTopologyRule", C2_ParseArcTopologyRule,
		  (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_ParseFunctionSignatures", C2_ParseFunctionSignatures,
		  (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_ParseTypeDefinitions", C2_ParseTypeDefinitions,
		  (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);
   Tcl_CreateCommand(main_interp, "c2_ParseNameSharingSpecification", C2_ParseNameSharingSpecification,
		  (ClientData) NULL, (Tcl_CmdDeleteProc *) NULL);


   Setup();

   TestDirectory = new char[255];
   sprintf (TestDirectory, "");

   Tcl_LinkVar(main_interp, "c2_SaveDirectory", (char *) &TestDirectory, TCL_LINK_STRING);
   Tcl_LinkVar(main_interp, "c2_yycolumn", (char *) &yycolumn, TCL_LINK_INT|TCL_LINK_READ_ONLY);
   Tcl_LinkVar(main_interp, "c2_yylinenum", (char *) &yylinenum, TCL_LINK_INT|TCL_LINK_READ_ONLY);


   char *path;
   path = new char[255];
   char *s;
   s = new char[255];

   if (!(s = getenv("CODEDIR"))) return(1);
   sprintf (codedir, "%s", s);
   sprintf (path, "%s/ui/init.code2", codedir);

   code = Tcl_EvalFile(main_interp, path);

   // If specified on command line, try to open an input file

   if (argc == 2) {
     int result;
     char ss[255];
     sprintf (ss, "$c2_MainCanvas attempt_open \"%s\"", argv[1]);
     result = Tcl_GlobalEval(main_interp, ss);
   }

   // If -T is specified, compile for a particular target
   // and then exit.

   if (argc == 4) {
     if (strcmp(argv[2],"-T") == 0) {
       if ((strcmp(argv[3], "Cray") == 0) ||
	   (strcmp(argv[3], "Sparc") == 0) ||
	   (strcmp(argv[3], "Sequent") == 0) ||
	   (strcmp(argv[3], "PVM") == 0) ||
	   (strcmp(argv[3], "Serial") == 0)) {
	 int result;
	 char ss[255];
	 sprintf (ss, "set c2_TranslationTarget %s; c2_RunProgram", argv[3]);
	 result = Tcl_GlobalEval(main_interp, ss);
       } else {
	 printf("\"%s\" is an invalid target.\n", argv[3]);
	 return(1);
       }
     }
     Tcl_Eval(main_interp, "exit");
     return (0);
   }


   Tk_MainLoop();

   if (code) {
     fprintf(stderr,"Error message = %s\n", main_interp->result);
     return(1);
   }

   /*
    * Don't exit directly, but rather invoke the Tcl "exit" command.
    * This gives the application the opportunity to redefine "exit"
    * to do additional cleanup.
    */

   Tcl_Eval(main_interp, "exit");

   return (0);

}


void Setup() {
   char *s;

   // Set up config file defaults

   s = getenv("VISUAL");
   if (s == 0)
     s = getenv("EDITOR");
   if (s == 0)
     strcpy(editor, DEFAULT_CODE2_EDITOR);
   else
     strcpy(editor, s);

   strcpy(sequentcc, DEFAULT_SEQUENTCC);
   strcpy(sequentld, DEFAULT_SEQUENTLD);
   strcpy(pvmcc,     DEFAULT_PVMCC);
   strcpy(serialcc,  DEFAULT_SERIALCC);
   strcpy(sparccc,   DEFAULT_SPARCCC);
   strcpy(sparcld,   DEFAULT_SPARCLD);
   strcpy(craycc,    DEFAULT_CRAYCC);
   strcpy(crayld,    DEFAULT_CRAYLD);

   strcpy(codedir,   DEFAULT_CODEDIR);

   // Read config file

   if (OpenConfigFile()) {
      char *Key, *Value;
      while(GetKeyAndValue(&Key, &Value)) {
         if        (strcmp("codedir", Key) == 0) {
            strcpy(codedir, Value);
         } else if (strcmp("editor", Key) == 0) {
            strcpy(editor, Value);
         } else if (strcmp("sequentcc", Key) == 0) {
            strcpy(sequentcc, Value);
         } else if (strcmp("sequentld", Key) == 0) {
            strcpy(sequentld, Value);
         } else if (strcmp("pvmcc", Key) == 0) {
            strcpy(pvmcc, Value);
         } else if (strcmp("serialcc", Key) == 0) {
            strcpy(serialcc, Value);
	  } else {
            cerr << "** Warning: unknown config key " << Key << "\n";
            cerr.flush();
         }
      }
      CloseConfigFile();
   }

   if (codedir[strlen(codedir)-1] != '/')
     strcat(codedir, "/");
}
