#
# hierarchy.tcl
# ------------------------------------------------------------------------
# A widget to handle hierarchy traversal (through the levels of subgraphs).
# ------------------------------------------------------------------------
# @(#) $Id: hierarchy.tcl,v 1.4 1996/03/15 18:01:26 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


itk::usual Code::CodeHierarchy {
    keep -background -cursor -foreground
}


class Code::CodeHierarchy {

    inherit Code::Dialog

    constructor {canv args} {}

    itk_option define -callnodesonly callnodesonly CallNodesOnly 0

    public method hlist {}
    public method activate {}
    public method select_all {}

    protected method canvas_kids {parent canvas {callnodes_only 0}}
    protected variable canvas ""

    private variable first_item
    private variable last_item
}


body Code::CodeHierarchy::constructor {canv args} {
    set canvas $canv
    eval itk_initialize $args

    itk_component add shlist {
	tixScrolledHList [info namespace tail $this].shlist
    }  {
	keep -background -cursor
    }

    [$itk_component(shlist) subwidget hlist] configure \
	-selectmode extended -separator ":"
    pack $itk_component(shlist) -expand yes -fill both

}


body Code::CodeHierarchy::hlist {} {
    return [$itk_component(shlist) subwidget hlist]
}


body Code::CodeHierarchy::select_all {} {
    [$this hlist] selection set $first_item $last_item
}


body Code::CodeHierarchy::activate {} {

    set kids_list [concat [list "$canvas $canvas"] [canvas_kids "${canvas}:" $canvas $itk_option(-callnodesonly)]]

    set i -1

    #
    # delete everything from the list
    #

    [$this hlist] delete all


    #
    # now add all the items to the hierarchical list
    #

    foreach item $kids_list {
	incr i

	# remove all spaces for the pathname

	regsub -all " " "[lrange $item 1 end]" "" pathname

	set items($i) $pathname

	if {![string compare [lindex $item 0] [$canvas info variable MainCanvas -value]]} {
	    set itemname "Main"
	} else {
	    set itemname [[lindex $item 0] info variable Name -value]
	}

	[$this hlist] add $pathname -text $itemname -data [lindex $item 0] -itemtype imagetext
	[$this hlist] item create $pathname 0 -itemtype imagetext -bitmap [[lindex $item 0] bitmap] -text $itemname
    }

    set first_item $items(0)
    set last_item $items($i)

    Code::Dialog::activate
}


body Code::CodeHierarchy::canvas_kids {parent canvas {callnodes_only 0}} {
    if { $canvas == "" } {
	return ""
    }
    
    set items ""
    set callnodes ""

    set kids [winfo children [info namespace tail $canvas]]

    foreach kid $kids {
	if { [$kid isa ::Code::Node] || [$kid isa ::Code::Arc] } {
	    if { [$kid isa ::Code::CallNode] } {
		lappend callnodes $kid
	    } else {
		if { !$callnodes_only } {
		    lappend items "$kid ${parent}$kid"
		}
	    }
	}
    }

    foreach cn $callnodes {
	lappend items "$cn ${parent}$cn"
	set newparent "${parent}${cn}:"
	set items \
		[concat $items \
		[canvas_kids "$newparent" [$cn info variable subgraph -value] $callnodes_only]]
    }

    return $items
}