proc build_iconbar {w statusbar} {

    global c2_MenuFont c2_ReleaseDirectory

    # build widget $w.frame4
    frame $w.frame4 \
	    -borderwidth {0} \
	    -relief {raised}
    
    # build widget $w.frame4.frame1
    frame $w.frame4.frame1

    # build widget $w.frame4.frame2
    frame $w.frame4.frame2

    # build widget $w.frame4.frame1.button0
    button $w.frame4.frame1.button0 \
	    -bitmap "@$c2_ReleaseDirectory/bitmaps/left_ptr" \
	    -command {Code::CodeCanvas::set_tool Select} \
	    -font {9x15} \
	    -height {26} \
	    -text {button0} \
	    -width {25}


    makeBalloon $w.selectballoon \
	    $w.frame4.frame1.button0 \
	    "Arrow tool: Use to select, move, or draw arcs between nodes." $statusbar

    # build widget $w.frame4.frame1.button2
    button $w.frame4.frame1.button2 \
	    -bitmap "@$c2_ReleaseDirectory/bitmaps/CommentMode.bit" \
	    -command {Code::CodeCanvas::set_tool Comment} \
	    -height {26} \
	    -width {25}

    makeBalloon $w.commentballoon \
	    $w.frame4.frame1.button2 \
	    "Text tool: Click on the canvas to edit labels or write comments." $statusbar

    # build widget $w.frame4.frame2.button0
    button $w.frame4.frame2.button0 \
	    -bitmap "@$c2_ReleaseDirectory/bitmaps/info" \
	    -command {Code::CodeCanvas::set_tool Query} \
	    -height {26} \
	    -text {button3} \
	    -width {25}

    makeBalloon $w.queryballoon \
	    $w.frame4.frame2.button0 \
	    "Info tool: Click on an item to view its annotations." $statusbar

    # build widget $w.frame4.frame2.button1
    button $w.frame4.frame2.button1 \
	    -bitmap "@$c2_ReleaseDirectory/bitmaps/HandDrag.bit" \
	    -command {Code::CodeCanvas::set_tool Drag} \
	    -height {26} \
	    -text {button3} \
	    -width {25}

    makeBalloon $w.dragballoon \
	    $w.frame4.frame2.button1 \
	    "Drag tool: Click and drag on the canvas to scroll." $statusbar

    # pack widget $w.frame4.frame1
    pack append $w.frame4.frame1 \
	    $w.frame4.frame1.button0 {left frame nw} \
	    $w.frame4.frame1.button2 {left frame ne}

    # pack widget $w.frame4.frame2
    pack append $w.frame4.frame2 \
	    $w.frame4.frame2.button0 {left frame nw} \
	    $w.frame4.frame2.button1 {left frame ne}

    # pack widget $w.frame4
    pack append $w.frame4 \
	    $w.frame4.frame1 {top frame nw fillx} \
	    $w.frame4.frame2 {top frame sw fillx}

    frame $w.frame5 \
	    -borderwidth {0} \
	    -relief {sunken}

    if 0 {
	tixScrolledWindow $w.frame5.swindow
	set window [$w.frame5.swindow subwidget window]
    } else {
	set window [frame $w.frame5.swindow]
    }

    # build widget $window.button1
    button $window.button1 \
	    -bitmap "@$c2_ReleaseDirectory/bitmaps/CallNode.bit" \
	    -command {Code::CodeCanvas::set_tool CallNode} \
	    -font "$c2_MenuFont" \
	    -text {button1}

    makeBalloon $w.callnodeballoon \
	    $window.button1 \
	    "Call node: Contains a subgraph (double-click to enter)." $statusbar

    # build widget $window.button2
    button $window.button2 \
	    -bitmap "@$c2_ReleaseDirectory/bitmaps/CompNode.bit" \
	    -command {Code::CodeCanvas::set_tool CompNode} \
	    -font "$c2_MenuFont" \
	    -text {button2}

    makeBalloon $w.compnodeballoon \
	    $window.button2 \
	    "Computation node: Performs sequential computations." $statusbar

    # build widget $window.button3
    button $window.button3 \
	    -bitmap "@$c2_ReleaseDirectory/bitmaps/CreationParameterNode.bit" \
	    -command {Code::CodeCanvas::set_tool CreationParameterNode} \
	    -font "$c2_MenuFont" \
	    -text {button3}

    makeBalloon $w.cpnodeballoon \
	    $window.button3 \
	    "Creation node: Provides a read-only input parameter local to the subgraph." $statusbar

    # build widget $window.button4
    button $window.button4 \
	    -bitmap "@$c2_ReleaseDirectory/bitmaps/NameSharingNode.bit" \
	    -command {Code::CodeCanvas::set_tool NameSharingNode} \
	    -font "$c2_MenuFont" \
	    -text {button4}

    makeBalloon $w.nsnodeballoon \
	    $window.button4 \
	    "Name Sharing node: Provides a shared variable (many-readers, one-writer)." $statusbar

    # build widget $window.button6
    button $window.button6 \
	    -bitmap "@$c2_ReleaseDirectory/bitmaps/InInterfaceNode.bit" \
	    -command {Code::CodeCanvas::set_tool InInterfaceNode} \
	    -font "$c2_MenuFont" \
	    -text {button6}

    makeBalloon $w.innodeballoon \
	    $window.button6 \
	    "Input node: Defines the input to a subgraph." $statusbar

    # build widget $window.button5
    button $window.button5 \
	    -bitmap "@$c2_ReleaseDirectory/bitmaps/OutInterfaceNode.bit" \
	    -command {Code::CodeCanvas::set_tool OutInterfaceNode} \
	    -font "$c2_MenuFont" \
	    -text {button5}

    makeBalloon $w.outnodeballoon \
	    $window.button5 \
	    "Output node: Defines the output from a subgraph." $statusbar

    # pack widget $window
    pack append $window \
	    $window.button2 {}\
	    $window.button1 {}\
	    $window.button6 {}\
	    $window.button3 {}\
	    $window.button5 {}\
	    $window.button4 {}

    pack append $w.frame5 \
	    $w.frame5.swindow {top frame center expand fill}


    frame $w.frame6

    button $w.frame6.button0 \
	    -bitmap "@$c2_ReleaseDirectory/bitmaps/ZoomIn.bit" \
	    -command {Code::CodeCanvas::set_tool ZoomIn} \
	    -height {26} \
	    -text {button4} \
	    -width {25}

    makeBalloon $w.zoominballoon \
	    $w.frame6.button0 \
	    "Magnify tool: Click on the canvas to zoom in on a particular spot." $statusbar

    button $w.frame6.button1 \
	    -bitmap "@$c2_ReleaseDirectory/bitmaps/ZoomOut.bit" \
	    -command {Code::CodeCanvas::set_tool ZoomOut} \
	    -height {26} \
	    -text {button5} \
	    -width {25}

    makeBalloon $w.zoomoutballoon \
	    $w.frame6.button1 \
	    "Shrink tool: Click on the canvas to zoom out from a particular spot." $statusbar

    pack append $w.frame6 \
	    $w.frame6.button0 {left frame nw expand fillx} \
	    $w.frame6.button1 {right frame ne expand fillx}

    # pack widget $w
    pack append $w \
	    $w.frame4 {top frame nw expand fill} \
	    $w.frame6 {bottom frame se expand fillx} \
	    $w.frame5 {left frame center expand fill}

}