/* c2_workers.h */

#ifndef _C2_WORKERS_
#define _C2_WORKERS_

extern int _c2_Terminated;  /* 1 iff term node has fired */

  /* Initial worker manager-- call this first with address of start node */
void _c2_RunWorkers( /* _c2_NodeBase *InitNode */ );

  /* Add a NodeTask to the list to be run */
void _c2_EnQueue( /* _c2_NodeBase *Node */ );

  /* Signal end to computation */
void _c2_StopAll();

  /* Stop computation after error */
void _c2_KillComp( /* int Reason */ );


         /* Node queue states */

#define _c2_IDLE 1       /* Node is not running, and does not need to */
#define _c2_ONQUEUE 2    /* Node is queued to run, but has not started */
#define _c2_RUNNING 3    /* Node is running */
#define _c2_NEEDSRUN 4   /* Node needs to be queued to run again */
#define _c2_ONDBGQ 5     /* node is stopped and on the debug Q */

         /* AbEnd reasons */

#define _c2_CREPTWICE 1
#define _c2_RMFROMEMPTY 2

#ifdef _C2_DBGR_
   /* runs the debugger task after the initialization of runtime system */
void _c2_RunDebugger(/* _c2_NodeBase *InitNode, int argc, char **argv */);

   /* empty ready q in preparation for a new run by the debugger */
void _c2_emptyRdyQ();

   /* Dummy routines to provide compatiblity with sequent runtime*/
void _c2_KillWorkers();
void _c2_inthandler();
void _c2_ChldHndler();

#endif

#endif
