class Code::Scrolledtext {

    inherit wigwam::itcl_frame

    itk_option define -variable variable Variable ""
    itk_option define -labeltext labeltext Labeltext ""

    constructor {args} { eval wigwam::itcl_frame::constructor $args } {}
    destructor {
	trace vdelete $itk_option(-variable) r "$oldthis update_variable"
	trace vdelete $itk_option(-variable) w "$oldthis update_text"
    }

    protected method update_variable {name e op}
    protected method update_text {name e op}
    
    protected variable oldthis
}


configbody Code::Scrolledtext::variable {
    eval upvar #0 $itk_option(-variable) x

    component text delete 1.0 end
    component text insert 1.0 $x

    trace variable x r "$oldthis update_variable"
    trace variable x w "$oldthis update_text"
}

configbody Code::Scrolledtext::labeltext {
    component label configure -text $itk_option(-labeltext)
}

body Code::Scrolledtext::constructor {args} {
    set oldthis [info namespace tail $this]

    tixScrolledText $oldthis.stext

    itk_component add text {
	$oldthis.stext subwidget text
    } {
	keep -background -cursor -width -height
    }

    itk_component add label {
	label $oldthis.label
    } {}

    pack $itk_component(label) -side top -anchor center
    pack $oldthis.stext -fill both -expand yes
    eval itk_initialize $args

} 



body Code::Scrolledtext::update_variable {name e op} {
    eval upvar #0 $itk_option(-variable) x
    eval set x {[component text get 1.0 end-1char]}
}

body Code::Scrolledtext::update_text {name e op} {
    eval upvar #0 $itk_option(-variable) x
    component text delete 1.0 end
    component text insert 1.0 $x
}

