/* c2_globtype.h */

#define TRUE 1
#define FALSE 0

typedef double real;

typedef struct {
  real x;
  real y;
} *Point; 

typedef struct {
  real Mag;
  real Angle;
} *Vector; 

typedef struct {
  Point LL;
  Point UR;
} *Box; 

typedef int *IntArray;

typedef struct {
  real Mass;
  Point Pos;
  Vector Vel;
  Box BoundBox;
  IntArray Child;
} *TreeNode; 

typedef TreeNode *TreeNodeArray;

typedef struct {
  int NextFree;
  TreeNodeArray Nodes;
} *TreeType; 

typedef struct {
  real Mass;
  Point Pos;
  Vector Vel;
} *PartNode; 

typedef PartNode *PartArray;

typedef struct {
  PartArray Part;
  int NumPart;
  Box SpaceBox;
} *NodeInfo; 

typedef NodeInfo *SplitPartArray;

void srand();
void ReadInputs();
void InitializeParticle();
void PrintParticle();
void enter_particle();
void print_tree();
void PrintInt();
void Move();
void get_new_space_box();
void PrintPos();
