/* convex hull algorithm
 * Reads a data file with
 *
 * x1 y2 x2 y2 ...........
 *
 */

#include <math.h>
#include <stdio.h>

#define BIG 1000000000.0
#define MAXPOINTS 100

struct point {
   float x, y;
};

main ()
{
   int i, i_min, i_max, num_pts, i_cur, i_min_theta, going_up;
   float theta, find_theta(), miny, maxy, min_theta;
   struct point p[MAXPOINTS];

   /* read and count the points; while doing so find the
      index of the min and max y values */

   i = 0;
   miny = BIG;
   maxy = - BIG;
   while (scanf("%f %f", &p[i].x, &p[i].y) != EOF) {
      printf("read x[%d] = %f and y[%d] = %f\n", i, p[i].x, i, p[i].y);
      if (p[i].y > maxy) {
	 maxy = p[i].y;
	 i_max = i;
      }
      if (p[i].y < miny) {
	 miny = p[i].y;
	 i_min = i;
      }
      i += 1;
      if (i >= MAXPOINTS) {
         fprintf(stderr, "Error: too many points\n");
         exit(1);
      }
   }

   num_pts = i;
   printf("Reading of %d points complete\n", num_pts);
   printf("Min and max y indices are %d and %d\n", i_min, i_max);

   /* Now find the convex hull */

   i_cur = i_min;
   going_up = 1;

   do {
      printf("Point %d : (%f, %f) is in\n", i_cur, p[i_cur].x, p[i_cur].y);
      min_theta = BIG;
      for (i=0; i<num_pts; i++) {
	 theta = find_theta(p[i_cur].x, p[i_cur].y, p[i].x, p[i].y, going_up);
	 if (theta < min_theta) {
	    min_theta = theta;
	    i_min_theta = i;
	 }
      }
      i_cur = i_min_theta;
      if (i_cur == i_max) going_up = 0;
   } while (i_cur != i_min);

}


float find_theta(x1, y1, x2, y2, going_up)
   float x1, y1, x2, y2;
   int going_up;
{
   float dx, dy, theta, ax, ay;

   dx = x2 - x1;
   dy = y2 - y1;
   ax = fabs(dx);
   ay = fabs(dy);

   if ((dx == 0.0) && (dy == 0.0))
      theta = BIG;
   else
      theta = dy/(ax + ay);

   if (dx < 0.0)
      theta  = 2.0 - theta;
   else if (dy < 0.0)
      theta = 4.0 + theta;
   if (!going_up) {
      theta += 2.0;
      if (theta >= 4.0) theta -= 4.0;
   }

   return theta;

}
