/* allocate_main allocate space from the heap for the main
   array; here this array is generated for testing purposes
*/
double **allocate_main(m,n)
int m,n;
{
double **A;
int i;
A=(double **) malloc(m*sizeof(double *));
for(i=0;i<m;i++) 
  A[i]= (double *) malloc(n * sizeof(double ));

return A;
}


/*  frees the space for the main array */
void free_main(A,m)
double **A;
int m;
{
int i;
for(i=m-1;i>=0;i--)  free((void *) A[i]);
free((void **) A);
}


/* frees the space alloacated to hold the decompositions
   (blocks in this case); space was allocated through 
   functions block() and block_overlap()
*/
void free_block(M,brow,bcol)
double ****M;
int brow,bcol;
{
int i,j;
for (i=0;i<brow;i++){
  for(j=0;j<bcol;j++)
    free((void **) M[i][j]);
  free((void ***) M[i]);
  }
free((void ****) M);
}


/* frees the space alloacated to hold the decompositions
   (rows in this case); space was allocated through 
   functions rows() and rows_overlap()
*/
void free_row(R,brow)
double ***R;
int brow;
{
int i;
for(i=0; i<brow; i++)
  free((void **) R[i]);
free((void ***) R);
}


/* block() first allocates space to hold the decomposed 
  blocks from array A in the array M. Then the pointers 
  are manipulated so that the blocks of A are properly
  stored in M
*/
double ****block(A, m, n, brow, bcol)
double **A;
int m, n, brow, bcol;

{
double ****M;
int i,j,k;

M=(double ****) malloc(brow*sizeof(double ***));
for(i=0;i<brow;i++) {
  M[i]= (double ***) malloc(bcol * sizeof(double **));
  for(j=0; j< bcol; j++)
    M[i][j] = (double **) malloc((m/brow)* sizeof(double *));
  }


for(i=0; i< brow; i++)
  for(j=0; j< bcol; j++)
   for(k=0; k< m/brow; k++)
      M[i][j][k]=(*(A+i*(m/brow)+k) + j*(n/bcol) );

return M;

}



void merge_block(A,M, m, n, brow, bcol)
double ****M, **A;
int m, n, brow, bcol;

{
int i,j,k;

for(i=0; i< brow; i++)
   for(k=0; k< m/brow; k++)
        A[i*(m/brow)+k]=M[i][0][k];


}



double ****block_overlap(A, m, n, brow, bcol)
double **A;
int m, n, brow, bcol;

{
double ****M, ***M1d, **M2d;
int i,j,k,l,p;

M=(double ****) _c2_shmalloc(brow*sizeof(double ***));
_c2_AddrHashTabAdd((char *) M, brow);
for(i=0;i<brow;i++) {
  M[i]= (double ***) _c2_shmalloc(bcol * sizeof(double **));
  M1d=M[i];
  _c2_AddrHashTabAdd((char *) M1d, bcol);
  for(j=0; j< bcol; j++) {
    M1d[j] = (double **) _c2_shmalloc(((m/brow)+2)* sizeof(double *));
    _c2_AddrHashTabAdd((char *) M1d[j], (m/brow + 2));
   }
  }


for(i=0; i< brow; i++) {
  M1d=M[i];
  if ((i == 0) || (i == brow -1 )) {
    p= (i == 0) ? 0 : -1;
    for(j=0; j< bcol; j++ )  {
      M2d=M1d[j];
      if (j == 0) 
        for(k=0; k< m/brow+1; k++) 
          M2d[k]=(*(A+i*(m/brow)+k+p) + j*(n/bcol) );
      else
        for(k=0; k< m/brow+1; k++)
          M2d[k]=(*(A+i*(m/brow)+k+p) + j*(n/bcol)-1 );
      }
  }
  else
    for(j=0; j< bcol; j++)  {
      M2d=M[i][j];
      if (j == 0) 
        for(k=0; k< m/brow+2; k++)
          M2d[k]=(*(A+i*(m/brow)+k-1) + j*(n/bcol) );
      else
        for(k=0; k< m/brow+2; k++)
          M2d[k]=(*(A+i*(m/brow)+k-1) + j*(n/bcol)-1 );
    }
  }

return M;

}



void merge_block_overlap(A,M, m, n, brow, bcol)
double ****M, **A;
int m, n, brow, bcol;

{
int i,j,k;
double **M2d;

for(i=0; i< brow; i++)  {
  M2d=M[i][0];
  if (i == 0)
     for(k=0; k< m/brow; k++)
        A[i*(m/brow)+k]=M2d[k];
  else if (i == brow -1 )
     for(k=0; k< m/brow; k++)
        A[i*(m/brow)+k]=M2d[k+1];
  else
     for(k=0; k< m/brow; k++)
        A[i*(m/brow)+k]=M2d[k+1];
}


}




double ***row(A, m, n, brow)
double **A;
int m, n, brow;

{
double ***M;
int i,j,k;

M=(double ***) malloc(brow*sizeof(double **));
for(i=0;i<brow;i++) {
  M[i]= (double **) malloc((m/brow) * sizeof(double *));
  }


for(i=0; i< brow; i++)
   for(j=0; j< m/brow; j++)
      M[i][j]=(*(A+i*(m/brow)+j)) ;

return M;

}



void merge_row(A,R, m, n, brow)
double ***R, **A;
int m, n, brow;

{
int i,j,k;

for(i=0; i< brow; i++)
   for(k=0; k< m/brow; k++)
        A[i*(m/brow)+k]=R[i][k];


}




double ***row_overlap(A, m, n, brow)
double **A;
int m, n, brow;

{
double ***M;
int i,j,k,p;

M=(double ***) malloc(brow*sizeof(double **));
for(i=0;i<brow;i++) 
  M[i]= (double **) malloc((m/brow+2) * sizeof(double *));
  


for(i=0; i< brow; i++)
   if ((i == 0) || (i == brow -1)) {
     p=(i ==0) ? 0 : -1;
     for(j=0; j< m/brow+1; j++)
        M[i][j]=(*(A+i*(m/brow)+j+p)) ;
   }
   else
     for(j=0; j< m/brow+2; j++)
        M[i][j]=(*(A+i*(m/brow)+j-1)) ;

return M;

}



void merge_row_overlap(A,R, m, n, brow)
double ***R, **A;
int m, n, brow;

{
int i,j,k;

for(i=0; i< brow; i++)
  if (i == 0)
     for(k=0; k< m/brow; k++)
        A[i*(m/brow)+k]=R[i][k];
  else if (i == brow -1 )
     for(k=0; k< m/brow; k++)
        A[i*(m/brow)+k]=R[i][k+1];
  else
     for(k=0; k< m/brow; k++)
        A[i*(m/brow)+k]=R[i][k+1];


}
