/* Assembly language defines -- this includes defines for both 
 *
 * externally callable routines
 * internally called routines
 *
 * in order to isolate all machine specific stuff in this file
 */

#include "asmdefs.h"

/* Externally callable routines -- for SpinLocks */

#define lockValue	%al
#define delayWord	%eax
#define delayByte	%al
#define meanDelay	%cl

#ifndef LINT
/* Acquire a SpinLock -- lockValue = delay = eax; meanDelay = ecx; lptr = edx */

asm void MY_LOCK(laddr)
{
%reg laddr; lab loop, ndelay, spin, done;
/PEEPOFF
	movb	$1 , meanDelay					
loop:									
	movb	$1 , lockValue			
	cmpb	lockValue , SpinLock_lock(laddr)	
	je      ndelay							
	xchgb	lockValue , SpinLock_lock(laddr)
	cmpb	$0 , lockValue					
	je	done	 /* if 0, we got the lock -- otherwise increase backoff */
	cmpb	$31 , meanDelay					
	je		ndelay						
	addb	meanDelay , meanDelay	
	orb		$1 , meanDelay		
ndelay:		 /* compute delay */
	movl	[_pP + pP_seed] , delayWord
	imull   $1103515245 , delayWord		
	addl    $12345 , delayWord		
	movl	delayWord , [_pP + pP_seed]			
	andb	meanDelay , delayByte			
	cmpb	$0 , delayByte				
	je		loop				
spin:						
	decb	delayByte		
	jnz		spin	
	jmp		loop
done:
/PEEPON
%mem laddr; lab loop, ndelay, spin, done;
	movl laddr,%edx
/PEEPOFF
	movb	$1 , meanDelay					
loop:									
	movb	$1 , lockValue			
	cmpb	lockValue , SpinLock_lock(%edx)	
	je      ndelay							
	xchgb	lockValue , SpinLock_lock(%edx)
	cmpb	$0 , lockValue					
	je	done	 /* if 0, we got the lock -- otherwise increase backoff */
	cmpb	$31 , meanDelay					
	je		ndelay						
	addb	meanDelay , meanDelay	
	orb		$1 , meanDelay		
ndelay:		 /* compute delay */
	movl	[_pP + pP_seed] , delayWord		
	imull   $1103515245 , delayWord		
	addl    $12345 , delayWord		
	movl	delayWord , [_pP + pP_seed]			
	andb	meanDelay , delayByte			
	cmpb	$0 , delayByte				
	je		loop				
spin:						
	decb	delayByte		
	jnz		spin	
	jmp		loop
done:
/PEEPON
}

/* unlock a SpinLock */
asm void MY_UNLOCK(laddr)
{
%reg laddr;
	movb	$0 , lockValue
	xchgb	lockValue , SpinLock_lock(laddr)
%mem laddr;
	movl	laddr, %ecx
	movb	$0 , lockValue
	xchgb	lockValue , SpinLock_lock(%ecx)
}

/* Check and acquire a SpinLock (uses eax; ecx; edx) */
asm int MY_CLOCK(laddr)
{
%reg laddr; lab fail, done;
/PEEPOFF
	movl	$1 , %eax						
	movb	$1 , %dl					
	cmpb	%dl , SpinLock_lock(laddr)
	je      fail					
	xchgb	%dl , SpinLock_lock(laddr)
	cmpb	$0 , %dl				
	je		done	/* success */
fail: movl	$0 , %eax			
done:
/PEEPON
%mem laddr; lab fail, done;
	movl laddr,%ecx
/PEEPOFF
	movl	$1 , %eax						
	movb	$1 , %dl					
	cmpb	%dl , SpinLock_lock(%ecx)
	je      fail					
	xchgb	%dl , SpinLock_lock(%ecx)
	cmpb	$0 , %dl				
	je		done	/* success */
fail: movl	$0 , %eax			
done:
/PEEPON
}

#ifndef PRESTO

/* Internal thread package routines */

asm void INIT()
{
	movl %esp,  %eax
	addl $-8,  %eax
	movl %eax, [_pP + pP_sp]
	movl %ebp, [_pP + pP_fp]
}

asm void RESUME (t)
{
%reg t;
	movl Thread_sp(t), %esp
	ret		/* pops label off stack */
}

asm int DUMMYFRAME (bot)
{
%reg bot;
	addl	$-4, bot
	movl	$ _Dummy , (bot)
	addl	$-4, bot
	movl	%ebp , (bot)
}

/* sp = thread sp
	call f
 */
asm void STARTUP (t, newsp, newfp)
{
%reg t, newsp; mem newfp;
	movl newsp, %esp
	movl newfp, %ebp
	call *Thread_func(t)
}

/* Jump back to the idle loop when a thread finishes */
asm void THREAD_EXIT()
{
    movl [_pP + pP_fp] , %ebp
	movl [_pP + pP_sp] , %esp
	movl $1 , IdleLoop_Arg1(%esp)
	movl $_IdleLoop , %eax
	jmp *%eax
}

/* BLOCK: save registers, release the SpinLock, jump to the idle loop
 * and when you come back, restore the registers
 *
 * restoring ebp when jumping to the idle loop makes dbx a lot happier.
 * move off the stack before unlocking, for interrupts
 *
 * jump to IdleLoop (instead of calling it),
 * to convince dbx the caller was Startup
 */

asm void MY_BLOCK(l)
{
%reg l;
	pushl %ebp 
	pushl %ebx
	pushl %edi 
	pushl %esi
	pushl $9f
	movl [_pP + pP_thread] , %eax
	movl %esp , Thread_sp(%eax)
	movl [_pP + pP_sp] , %esp
	movl [_pP + pP_fp] , %ebp
	pushl l
	call _SpinLockRelBlock
	popl l
	movl $0 , IdleLoop_Arg1(%esp)
	movl $_IdleLoop , %eax
	jmp  *%eax 
9:
	popl %esi
	popl %edi 
	popl %ebx
	popl %ebp
%mem l;
	movl l,%ecx
	pushl %ebp 
	pushl %ebx
	pushl %edi 
	pushl %esi
	pushl $9f
	movl [_pP + pP_thread] , %eax
	movl %esp , Thread_sp(%eax)
	movl [_pP + pP_sp] , %esp
	movl [_pP + pP_fp] , %ebp
	pushl %ecx
	call _SpinLockRelBlock
	popl %ecx
	movl $0 , IdleLoop_Arg1(%esp)
	movl $_IdleLoop , %eax
	jmp  *%eax 
9:
	popl %esi
	popl %edi 
	popl %ebx
	popl %ebp
}

asm void NP_BLOCK(l)
{
%reg l;
	pushl %ebp 
	pushl %ebx
	pushl %edi 
	pushl %esi
	pushl $9f
	movl [_pP + pP_thread] , %eax
	movl %esp , Thread_sp(%eax)
	movl [_pP + pP_sp] , %esp
	movl [_pP + pP_fp] , %ebp
	movb	$0 , lockValue
	xchgb	lockValue , SpinLock_lock(l)
	movl $0 , IdleLoop_Arg1(%esp)
	movl $_IdleLoop , %eax
	jmp  *%eax 
9:
	popl %esi
	popl %edi 
	popl %ebx
	popl %ebp
%mem l;
	movl l,%ecx
	pushl %ebp 
	pushl %ebx
	pushl %edi 
	pushl %esi
	pushl $9f
	movl [_pP + pP_thread] , %eax
	movl %esp , Thread_sp(%eax)
	movl [_pP + pP_sp] , %esp
	movl [_pP + pP_fp] , %ebp
	movb	$0 , lockValue
	xchgb	lockValue , SpinLock_lock(%ecx)
	movl $0 , IdleLoop_Arg1(%esp)
	movl $_IdleLoop , %eax
	jmp  *%eax 
9:
	popl %esi
	popl %edi 
	popl %ebx
	popl %ebp
}

#endif	/* ifndef PRESTO */

asm void AtomicIncrP(m)
{
%mem m;
	movl m , %eax
	lock 
	incl (%eax)
}
asm void AtomicDecrP(m)
{
%mem m;
	movl m , %eax
	lock 
	decl (%eax)
}

asm void AtomicIncr(m)
{
%mem m;
	lock 
	incl m
}

asm void AtomicDecr(m)
{
%mem m;
	lock 
	decl m
}

asm void PushArg(m)
{
%mem m;
	pushl m
}

asm void PushNArgs(n,m)
{
%mem n, m; lab fred, snork; 
	movl	m,%eax
	movl	n,%ecx
	cmpl	$0,%ecx
	je		snork
fred:
	pushl	(%eax)
	addl	$4,%eax
	decl	%ecx
	jne		fred
snork:
}

asm void PopNArgs(n)
{
%mem n;
	movl n,%eax
	shll $2,%eax
	addl %eax,%esp
}
#endif LINT
