#include "c2_misc.h"

/* Hash table routines used to implement size.  This is an expensive
   way to implement this, but other methods are not practical if we
   wish users to be able to link in source code that is not parsed 
   by the CODE system */

/* See c2_misc.h for interface description */


static Lock SizeTableLock;

/*
 These addresses should be double aligned so the 3 ls bits are 0 and
 thus are used by the hashing function.
*/

static int
HashingFunction(Addr) 
char *Addr; 
{ 
   /* return 1; */
   return (((int)Addr >> 3) & 0x03FF);
}

typedef struct _c2_sHashRec {
   char *addr;
   int size;
   struct _c2_sHashRec *next; 
 } _c2_HashRec;


static _c2_HashRec *_c2_HashBuckets[0x0400];



int 
_c2_AddrHashTabAdd(Addr, Size)
   char *Addr;
   int Size;
{
   int SearchBucket;
   _c2_HashRec *HashLink, *LastLink;

   LockAcquire(&SizeTableLock);
   SearchBucket = HashingFunction(Addr);
   HashLink = _c2_HashBuckets[SearchBucket];
   LastLink = ((_c2_HashRec *)0);
   if (HashLink != ((_c2_HashRec *)0)) {
      while (HashLink != ((_c2_HashRec *)0)) {
         if (HashLink->addr == Addr) {
            if (HashLink->size == Size) {
	       LockRelease(&SizeTableLock);
               return 1;
            } else {
	       LockRelease(&SizeTableLock);
               return 0;
	    }
         }
         LastLink = HashLink;
         HashLink = HashLink->next;
      }
      LastLink->next = (_c2_HashRec *)malloc(sizeof(_c2_HashRec));
      LastLink->next->addr = Addr;
      LastLink->next->size = Size;
      LastLink->next->next = ((_c2_HashRec *)0);
   } else {
      _c2_HashBuckets[SearchBucket] = 
	(_c2_HashRec *)malloc(sizeof(_c2_HashRec));
      _c2_HashBuckets[SearchBucket]->addr = Addr;
      _c2_HashBuckets[SearchBucket]->size = Size;
      _c2_HashBuckets[SearchBucket]->next = ((_c2_HashRec *)0);
   }

   LockRelease(&SizeTableLock);
   return 1;
}


int 
_c2_AddrHashTabRemove(Addr)
   char *Addr;
{
   int SearchBucket;
   _c2_HashRec *HashLink, *LastLink;

   LockAcquire(&SizeTableLock);
   SearchBucket = HashingFunction(Addr);
   HashLink = _c2_HashBuckets[SearchBucket];
   LastLink = ((_c2_HashRec *)0);
   if (HashLink != ((_c2_HashRec *)0)) {
      while (HashLink != ((_c2_HashRec *)0)) {
         if (HashLink->addr == Addr) {
            if (LastLink != ((_c2_HashRec *)0)) 
	      LastLink->next = HashLink->next;
	    else 
	      _c2_HashBuckets[SearchBucket] = HashLink->next;
            free(HashLink);
	    LockRelease(&SizeTableLock);
            return 1;
         }
         LastLink = HashLink;
         HashLink = HashLink->next;
      }
      LockRelease(&SizeTableLock);
      return 0;
   } else {
      LockRelease(&SizeTableLock);
      return 0;
   }
}


int 
_c2_AddrHashTabSplit(Addr, SplittingPoint)
   char *Addr;
   int SplittingPoint;
{
   int SearchBucket;
   _c2_HashRec *HashLink;

   LockAcquire(&SizeTableLock);
   SearchBucket = HashingFunction(Addr);
   HashLink = _c2_HashBuckets[SearchBucket];
   if (HashLink != ((_c2_HashRec *)0)) {
      while (HashLink != ((_c2_HashRec *)0)) {
         if (HashLink->addr == Addr) {
            if (HashLink->size >= SplittingPoint) {
               _c2_AddrHashTabAdd(Addr + SplittingPoint, 
				  HashLink->size - SplittingPoint);
               HashLink->size = SplittingPoint;
	       LockRelease(&SizeTableLock);
               return 1;
	    }
         }
         HashLink = HashLink->next;
      }
      LockRelease(&SizeTableLock);
      return 0;
   } else {
      LockRelease(&SizeTableLock);
      return 0;
   }
}


int 
asize(Addr)
   char *Addr;
{
   int SearchBucket;
   _c2_HashRec *HashLink;

   LockAcquire(&SizeTableLock);
   SearchBucket = HashingFunction(Addr);
   HashLink = _c2_HashBuckets[SearchBucket];
   if (HashLink != ((_c2_HashRec *)0)) {
      while (HashLink != ((_c2_HashRec *)0)) {
         if (HashLink->addr == Addr) {
	    LockRelease(&SizeTableLock);
	    return HashLink->size;
	 }
         HashLink = HashLink->next;
      }
      LockRelease(&SizeTableLock);
      /*
      fprintf(stderr, "*** Error: CODE tried to free array it didnt alloc\n");
      fflush(stderr);
      */
      return 0;
   } else {
      LockRelease(&SizeTableLock);
      /*
      fprintf(stderr, "*** Error: CODE tried to free array it didnt alloc\n");
      fflush(stderr);
      */
      return 0;
   }
}


static int 
_c2_AddrHashTabDump()
{
   int i;
   _c2_HashRec *HashLink;

   for (i=0; i<0x0400; i++) {
      if (_c2_HashBuckets[i] != ((_c2_HashRec *)0)) {
         HashLink = _c2_HashBuckets[i];
         printf("HashBucket[%d] :", i);
         while (HashLink != ((_c2_HashRec *)0)) {
            printf(" (%x,%d)", HashLink->addr, HashLink->size);
            HashLink = HashLink->next;
         }
         printf("\n");
      }
   }
   printf("\n");
}


void _c2_AddrHashTabInit()
{
   LockInit(&SizeTableLock, "SizeTableLock");
}

#ifdef _C2_DBGR_

void _c2_reinitAddrHashTab()
{
   int i;
   _c2_HashRec *HashLink, *tmp;

   LockAcquire(&SizeTableLock);
   for (i=0; i< 0x0400; i++) {
      if (_c2_HashBuckets[i] != (_c2_HashRec *)0) {
	 HashLink = _c2_HashBuckets[i];
	 _c2_HashBuckets[i] = (_c2_HashRec *) 0;
	 while (HashLink != (_c2_HashRec *)0) {
	    free(HashLink->addr);
	    tmp = HashLink->next;
	    free(HashLink);
	    HashLink = tmp;
	 }
      }
   }
   LockRelease(&SizeTableLock);
}

#endif /* _C2_DBGR_ */

