/*

fthread.h

This set of routines is designed to emulate the FastThreads package
(used in the Sequent Symmetry implementation) on a Sparc platform
with Solaris threads.

By providing this emulation, we will be able to use the sequent backend
almost as-is, as we will be "plugging-in" the only architecture dependent
bit.

Although the FastThreads package provides barriers, conditions, etc.,
CODE only uses locks and threads, so those are the only ones implemented
here.


===
Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
Systems Analyst                 @          <mailto: emery@cs.utexas.edu>
Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
Department of Computer Sciences |             <http://www.cs.utexas.edu>
University of Texas at Austin   |                <http://www.utexas.edu>

*/


#ifndef _fastthreads_x
#define _fastthreads_x

#include <pthread.h>

/* define thread routines */

typedef pthread_t Thread;

/*
  Define the FastThread join status values, which have no
  effect here.
*/

#define NOJOIN          0
#define JOIN            1
#define CALLEE_DONE     2
#define CALLER_READY    3


/*
   NOTE: due to shortcomings in UNICOS, it is not possible to completely
         emulate FastThreads (which allows multiple arguments).
	 However, since CODE (conveniently) only uses one-argument
	 procedure arguments in ThreadStart calls, this is not
	 a problem.
*/

extern Thread *ThreadStart (void (*procedureToRun)(),
			    int willJoin, 
			    char *name,
			    int numberOfArguments,
			    int *arg1);
extern void ThreadJoin (Thread *thread);
extern void ProgramDone ();

#endif
