/*
 *  Address Map functions
 */

#include "c2_misc.h"
#include "c2_addrmap.h"
#include "c2_workers.h"

void 
_c2_reverse(s)  /* from K & R */
char *s;
{
  int c, i, j;

  for (i = 0, j = strlen(s) - 1; i < j; i++,j--)
   {   c = s[i]; 
       s[i] = s[j]; 
       s[j] = c;
   }
}

void 
_c2_itoa(n, s)  /* from K & R */
int n;
char *s;
{
  int i, sign;

  if ((sign = n) < 0)
      n = -n;
  i = 0;
  do {
      s[i++] = n % 10 + '0';
  } while ((n /= 10) > 0);
  s[i] = '\0';
  _c2_reverse(s);
}

 /* Return address within Graph's map of object with given UID and
    Index.  UID of _c2_PARENT yields address of parent graph */

void *
_c2_GetAddr(Graph, UID, Index)
   _c2_GraphBase *Graph;
   int UID;
   _c2_Index *Index;
{
   _c2_AddrMap *m;
   _c2_AddrLink *tmp;
   int ObjType;

   if (UID == _c2_PARENT) return (void *) Graph->Parent;

   m = Graph->Map;

   /* Search for entry in address map */

   tmp = m->Head;
   
   while (tmp != 0) {
      if (tmp->UID == UID && _c2_EqIndex(&(tmp->Index), Index)) break;
      tmp = tmp->Next;
   }

   if (tmp != 0) {
      return tmp->Entry;   /* Found it */
   }

   /* Need to create object */

   tmp = (_c2_AddrLink *) _c2_shmalloc(sizeof(_c2_AddrLink));

   tmp->UID = UID;
   tmp->Index = *Index;
   tmp->Entry = _c2_MakeObj(UID, Index, Graph, &ObjType);
   tmp->ObjType = ObjType;

   /* Add to address map */

   tmp->Next = m->Head;
   m->Head = tmp;

   return tmp->Entry;
}


_c2_GraphBase *
_c2_MakeGraph(UID, Index, ParentGraph, LocalData)
   int UID;
   _c2_Index *Index;
   _c2_GraphBase *ParentGraph;
   void *LocalData;
{
  _c2_GraphBase *tmp;
  _c2_AddrMap *tmpMap;
  char *tmpPath;

  tmp = (_c2_GraphBase *) _c2_shmalloc(sizeof(_c2_GraphBase));
  tmp->UID = UID;
  tmp->Index = *Index;
  if (ParentGraph) 
  {
    int j,i=0;

    strcpy(tmp->Path, ParentGraph->Path);
    tmpPath = tmp->Path;
    while(*++tmpPath != '\0');
    *tmpPath = '/';
    tmpPath++;
    _c2_itoa(UID, tmpPath);
    while(*++tmpPath != '\0');
    j = Index->NumInd;

    while(j > 0)
    {
      *tmpPath++ = '[';
      _c2_itoa (Index->Ind[i++], tmpPath);
      while(*++tmpPath != '\0');
      *tmpPath++ = ']';
      j--;
    }
    *tmpPath = '\0';
  }
  else
    _c2_itoa(UID, tmp->Path);

  tmp->Parent = ParentGraph;
  tmpMap = (_c2_AddrMap *) _c2_shmalloc(sizeof(_c2_AddrMap));
  tmpMap->Head = 0;
  tmp->Map = tmpMap;
  tmp->LocalData = LocalData;

#ifdef _C2_DBGR_
  _c2_allocDbgGph(tmp);      /* allocate debugging info for graph*/
#endif

  return tmp;

}


_c2_NodeBase *
_c2_MakeNode(UID, Index, Graph, LocalData, Comp, Init, Crepped)
   int UID; 
   _c2_Index *Index;
   _c2_GraphBase *Graph;
   void *LocalData;
   void (*Comp)();
   void (*Init)();
   int Crepped;
{
   _c2_NodeBase *tmpN;
   char *tmpPath; 
   int j,i=0;

   tmpN = (_c2_NodeBase *) _c2_shmalloc(sizeof(_c2_NodeBase));
   tmpN->QueueStatus = _c2_IDLE;
   tmpN->UID = UID;
   tmpN->Index = *Index;

   strcpy(tmpN->Path, Graph->Path);
   tmpPath = tmpN->Path;
   while(*++tmpPath != '\0');
   *tmpPath = '/';
   tmpPath++;
   _c2_itoa(UID, tmpPath);
   while(*++tmpPath != '\0');
   j = Index->NumInd;
   while(j > 0)
   {
     *tmpPath++ = '[';
     _c2_itoa (Index->Ind[i++], tmpPath);
     while(*++tmpPath != '\0');
     *tmpPath++ = ']';
     j--;
   }
   *tmpPath = '\0';

   tmpN->LocalData = LocalData;
   tmpN->MyGraph = Graph;
   tmpN->CompProc = Comp;
   tmpN->NSState = _c2_NOTINIT;
   tmpN->InitProc = Init;
   tmpN->Crepped = Crepped;
   if (Crepped) 
     if (Init != 0) Init(tmpN);

#ifdef _C2_DBGR_
   _c2_allocDbgUc(tmpN);   /* allocate a struct in tmpN for debugging */
#endif

   return tmpN;
}


_c2_NSRelBase *
_c2_MakeNSRel(UID, Index, Graph, LocalData, Init, Crepped)
   int UID; 
   _c2_Index *Index;
   _c2_GraphBase *Graph;
   void *LocalData;
   void (*Init)();
   int Crepped;
{
   _c2_NSRelBase *tmpN;
   char *tmpPath; 
   int j,i=0;

   tmpN = (_c2_NSRelBase *) _c2_shmalloc(sizeof(_c2_NSRelBase));
   tmpN->UID = UID;
   tmpN->Index = *Index;

   strcpy(tmpN->Path, Graph->Path);
   tmpPath = tmpN->Path;
   while(*++tmpPath != '\0');
   *tmpPath = '/';
   tmpPath++;
   _c2_itoa(UID, tmpPath);
   while(*++tmpPath != '\0');
   j = Index->NumInd;
   while(j > 0)
   {
     *tmpPath++ = '[';
     _c2_itoa (Index->Ind[i++], tmpPath);
     while(*++tmpPath != '\0');
     *tmpPath++ = ']';
     j--;
   }
   *tmpPath = '\0';

   tmpN->LocalData = LocalData;
   tmpN->MyGraph = Graph;
   tmpN->InitProc = Init;
   tmpN->Crepped = Crepped;
   if (Crepped) 
     if (Init != 0) Init(tmpN);
   return tmpN;
}


   /* Initialize all uninitialized nodes in map.  Assumes map is locked */

#ifdef _C2_DBGR_
void 
_c2_InitWaitingNodes(fplist, g)
_c2_List fplist;
#else
void 
_c2_InitWaitingNodes(g)
#endif
   _c2_GraphBase *g;
{
   _c2_AddrMap *M;
   _c2_AddrLink *tmp;
   _c2_NSRelBase *n;
   _c2_NodeBase *u;

   g->CrepsToGo -= 1;
#ifdef _C2_DBGR_
   _c2_dbgGphCreatAction(g, fplist);
#endif
   if (g->CrepsToGo > 0) return;

   M = g->Map;

   tmp = M->Head;

   while (tmp != 0) {
      if (tmp->ObjType == _c2_UCNODE) {
	 u = (_c2_NodeBase *) (tmp->Entry);
	 if (!(u->Crepped)) {
	    printf("initing a uc %d\n", u->UID);
	    u->InitProc(u);
	    u->Crepped = 1;
	    _c2_EnQueue(u);
	 }
      } else if (tmp->ObjType == _c2_NSRELNODE) {
	 n = (_c2_NSRelBase *) (tmp->Entry);
	 if (!(n->Crepped)) {
	    printf("initing nsrel %d\n", u->UID);
	    n->InitProc(n);
	    n->Crepped = 1;
	 }
      }
      tmp = tmp->Next;
   }

}


  /* Add node to list of those waiting for lock */

static void _c2_RemoteAddToNSQ(UCPath, Q)
   char  *UCPath;
   _c2_NSLink **Q;
{
   _c2_NSLink *Cur;
   _c2_NSLink *New = (_c2_NSLink *) _c2_shmalloc(sizeof(_c2_NSLink));

   New->IsRemote = 1;
   New->NodePath = _c2_shmalloc(sizeof(UCPath) + 6);
   strcpy(New->NodePath, UCPath);
   New->Node = 0;

   if (*Q == 0) {
      New->Next = 0;
      *Q = New;
      return;
   }

   /* Only add if not already there */

   Cur = *Q;
   while (Cur != 0) {
     if ((Cur->IsRemote) && (strcmp(Cur->NodePath, New->NodePath) == 0)) return;
      Cur = Cur->Next;
   }

   New->Next = *Q;
   *Q = New;
}
  
static void 
_c2_AddToNSQ(UCAddr, Q)
   _c2_NodeBase *UCAddr;
   _c2_NSLink **Q;
{
   _c2_NSLink *Cur;
   _c2_NSLink *New = (_c2_NSLink *) _c2_shmalloc(sizeof(_c2_NSLink));

   New->Node = UCAddr;
   New->IsRemote = 0;

   if (*Q == 0) {
      New->Next = 0;
      *Q = New;
      return;
   }

   /* Only add if not already there */

   Cur = *Q;
   while (Cur != 0) {
      if (Cur->Node == UCAddr) return;
      Cur = Cur->Next;
   }

   New->Next = *Q;
   *Q = New;
}

  /* Enqueue and remove from list all nodes waiting for lock-- does not
     mean that they get lock.  Means that they try again */

static void  
_c2_ClearNSQ(Q)
   _c2_NSLink **Q;
{
   _c2_NSLink *Cur, *Tmp;

   Cur = *Q;

   while (Cur != 0) {
      if (Cur->IsRemote)
      { 
        int i;
        pvm_initsend(PVMDATATYPE);
        pvm_pkstr(Cur->NodePath);
        i = _c2_PvmPathSum(Cur->NodePath);
        pvm_send(_c2_tids[i % _c2_nhost], 6);
      }
      else 
        _c2_EnQueue(Cur->Node);

      Tmp = Cur;
      Cur = Cur->Next;
      _c2_shfree((char *) Tmp);
   }

   *Q = 0;
}


int 
_c2_RemoteGetLock(NSRelAddr, RCount, RQ, WCount, WQ, ReqType, UCPath)
   _c2_NSRelBase *NSRelAddr;
   int *RCount;                 /* Count of active readers */
   _c2_NSLink **RQ;             /* Reader wannabes */
   int *WCount;                 /* Count of active writers (0 or 1) */
   _c2_NSLink **WQ;             /* Writer wannabes */
   int ReqType;
   char *UCPath;
{
   int GotIt;


   /* There are three cases: there are active readers, writers, or neither */

   if (*RCount > 0) {   /* Active readers */

      if (ReqType == _c2_READER) {
         /* Allow another reader if no writers queued */
         if (*WQ == 0) {
            *RCount += 1;
            GotIt = 1;
         } else {
            _c2_RemoteAddToNSQ(UCPath, RQ);
            GotIt = 0;
         }
      } else { /* Write request */
         /* Always Q it. */
         _c2_RemoteAddToNSQ(UCPath, WQ);
         GotIt = 0;
      }

   } else if (*WCount > 0) { /* Active writers */

      if (ReqType == _c2_READER) {
         /* Always Q it. */
         _c2_RemoteAddToNSQ(UCPath, RQ);
         GotIt = 0;
      } else { /* Write request */
         /* Always Q it. */
         _c2_RemoteAddToNSQ(UCPath, WQ);
         GotIt = 0;
      }

   } else { /* No current readers or writers */

      if (ReqType == _c2_READER) {
         *RCount += 1;
         GotIt = 1;
      } else { /* Write request */
         *WCount += 1;
         GotIt = 1;
      }

   }

   return GotIt;
}


#ifdef _C2_DBGR_
int 
_c2_GetLock(psplist, NSRelAddr, RCount, RQ, WCount, WQ, ReqType, UCAddr)
   _c2_List *psplist;
#else
int 
_c2_GetLock(NSRelAddr, RCount, RQ, WCount, WQ, ReqType, UCAddr)
#endif
   _c2_NSRelBase *NSRelAddr;
   int *RCount;                 /* Count of active readers */
   _c2_NSLink **RQ;             /* Reader wannabes */
   int *WCount;                 /* Count of active writers (0 or 1) */
   _c2_NSLink **WQ;             /* Writer wannabes */
   int ReqType;
   _c2_NodeBase *UCAddr;
{
   int GotIt;
   /* There are three cases: there are active readers, writers, or neither */

   if (*RCount > 0) {		/* Active readers */
      if (ReqType == _c2_READER) {
	 /* Allow another reader if no writers queued */
	 if ((*WQ == 0) 
#          ifdef _C2_DBGR_
	     && !_c2_readSpBpAct(UCAddr, psplist, ReqType == _c2_WRITER)
#          endif
	     ) {
	    *RCount += 1;
	    GotIt = 1;
	 } else {
	    _c2_AddToNSQ(UCAddr, RQ);
	    GotIt = 0;
	 }
      } else {			/* Write request */
	 /* Always Q it. */
	 _c2_AddToNSQ(UCAddr, WQ);
	 GotIt = 0;
      }

   } else if (*WCount > 0) {	/* Active writers */

      if (ReqType == _c2_READER) {
	 /* Always Q it. */
	 _c2_AddToNSQ(UCAddr, RQ);
	 GotIt = 0;
      } else {			/* Write request */
	 /* Always Q it. */
	 _c2_AddToNSQ(UCAddr, WQ);
	 GotIt = 0;
      }

   } else {			/* No current readers or writers */
#     ifdef _C2_DBGR_
      if (!_c2_readSpBpAct(UCAddr, psplist, ReqType == _c2_WRITER)) {
#     endif
	 if (ReqType == _c2_READER) {
	    *RCount += 1;
	    GotIt = 1;
	 } else {		/* Write request */
	    *WCount += 1;
	    GotIt = 1;
	 }
#    ifdef _C2_DBGR_
      } else {                  /* only here in the replay mode */
         GotIt = 0; 
         if (ReqType == _c2_READER) {
            _c2_AddToNSQ(UCAddr, RQ); 
            _c2_ClearNSQ(WQ);
         } else {
            if (*WQ != 0) _c2_ClearNSQ(WQ); /* a writer can be waiting for a */
            if (*RQ != 0) _c2_ClearNSQ(RQ); /* reader/writer in the replay mode 
					     */
            _c2_AddToNSQ(UCAddr, WQ); 
         }
      }
#     endif
   }
   return GotIt;
} 


  /* Release an NSRel read or write lock */

void 
_c2_RelLock(NSRelAddr, RCount, RQ, WCount, WQ, ReqType)
   _c2_NSRelBase *NSRelAddr;
   int *RCount;                 /* Count of active readers */
   _c2_NSLink **RQ;             /* Reader wannabes */
   int *WCount;                 /* Count of active writers (0 or 1) */
   _c2_NSLink **WQ;             /* Writer wannabes */
   int ReqType;
{
   if (ReqType == _c2_READER) {

      *RCount -= 1;
      if (*RCount == 0)  _c2_ClearNSQ(WQ);

   } else { /* Write request */

      *WCount -= 1;
      if (*WQ != 0) _c2_ClearNSQ(WQ);
      else          _c2_ClearNSQ(RQ);
   }
}


  /* Add NS lock to *sorted* list of locks.  Sort by UID of shared var
     in NSRel.  This avoids deadlock. */

void 
_c2_InsertLock(HeadLock, NewLock)
   _c2_LockSet **HeadLock;
   _c2_LockSet *NewLock;
{
   _c2_LockSet *cur;
   _c2_LockSet *prev;

   /* Find link that new one must come before */

   cur = *HeadLock;
   while (cur != 0) {

      if (NewLock->UID == cur->UID)
	 fprintf(stderr, "\n ****** Warning: %s\n         %s\n\n",
		 "Attempt to use two instances of the same shared variable", 
                 "from the same UC innstance.  This is illegal!!!");

      if (NewLock->UID < cur->UID) break;
      prev = cur;
      cur = cur->Next;
   }

   if (*HeadLock == 0) {  /* NewLock is first to go into List */
      *HeadLock = NewLock;
      NewLock->Next = 0;
   } else if (cur == *HeadLock) {  /* New first in non-empty list */
      NewLock->Next = cur;
      *HeadLock = NewLock;
   } else { 
      NewLock->Next = cur;
      prev->Next = NewLock;
   }
}


  /* Acquire all locks in list from NextLock to end.  If fail to get a
     lock, leave NextLock pointing at it to try again next time.
     Return 1 if reach end of list (all locks acquired), return 0 if
     fail to get one-- hence more locks needed */

int 
_c2_GetAllLocks(_c2_na, NextLock)
   _c2_NodeBase * _c2_na;
   _c2_LockSet **NextLock;
{
   _c2_LockSet *cur;

   cur = *NextLock;
   while (cur != 0) {
      if (!cur->IsRemote) {	/* Is the NSRel on the same pvm task ? */
#       ifdef _C2_DBGR_
            if (_c2_GetLock(cur->psplist, cur->NSRelAddr, cur->RCount,
		cur->RQ, cur->WCount, cur->WQ, cur->ReqType, _c2_na)) {
#       else
            if (_c2_GetLock(cur->NSRelAddr, cur->RCount, cur->RQ,
                      cur->WCount, cur->WQ, cur->ReqType, _c2_na)) {
#       endif
	    switch (cur->TypeTag) {
	     case _c2_IsAnInt:
	       *((int *)(cur->LocalAddr)) = *((int *)(cur->SharedAddr));
	       break;
	     case  _c2_IsADouble:
	       *((double *)(cur->LocalAddr)) = *((double *)(cur->SharedAddr));
	       break;
	     case _c2_IsAnArrayPtr:
	     case _c2_IsAStructPtr:
	       *((void **)(cur->LocalAddr)) = *((void **)(cur->SharedAddr));
	       break;
	     case _c2_IsAChar:
	       *((char *)(cur->LocalAddr)) = *((char *)(cur->SharedAddr));
	       break;
	    }
	 } else {
	    *NextLock = cur;
	    return 0;		/* Failed to get this lock */
	 }
	 cur = cur->Next;
      } else {			/* or on a different Pvm task ? */
	 if (cur->RequestSent == 0) {
	    int tempsum;
	    int i;
	    int TaskID;

	    /* Map NSRel to PVM task */

	    tempsum = _c2_PvmPathSum(cur->NSRelGraphPath);
	    for (i = 0; i < cur->NSRelIndex.NumInd; i++)
		tempsum += cur->NSRelIndex.Ind[i];
	    tempsum += cur->NSRelUID;
	    TaskID = tempsum % _c2_nhost;

	    /*      i = cur->NSRelUID % _c2_nhost;*/

	    pvm_initsend(PVMDATATYPE);
	    pvm_pkstr(cur->NSRelGraphPath);
	    pvm_pkint(&cur->NSRelUID, 1, 1);
	    pvm_pkint(&cur->NSRelIndex.NumInd, 1, 1);
	    pvm_pkint(&cur->NSRelIndex.Ind[0], cur->NSRelIndex.NumInd, 1);
	    pvm_pkstr(_c2_na->Path);
	    pvm_pkint(&cur->ReqType, 1, 1);
	    pvm_pkint(&cur->UID, 1, 1);
	    pvm_pkint(&_c2_me, 1, 1);
	    pvm_send(_c2_tids[TaskID], 3);
	    *NextLock = cur;
	    cur->RequestSent = 1;
	 }
	 return 0;
      }
   }
   return 1;
}


  /* Release a list of locks, resetting the next lock pointer */

#ifdef _C2_DBGR_
void 
_c2_RelAllLocks(na, HeadLock, NextLock)
   _c2_NodeBase *na;
#else
void 
_c2_RelAllLocks(HeadLock, NextLock)
#endif
   _c2_LockSet **HeadLock;
   _c2_LockSet **NextLock;
{
   _c2_LockSet *cur;

   /* Release all locks in node's list */
   cur = *HeadLock;
   while (cur != 0) {
      if (!cur->IsRemote) {
	 switch (cur->TypeTag) {
	  case _c2_IsAnInt:
	    *((int *)(cur->SharedAddr)) = *((int *)(cur->LocalAddr));
	    break;
	  case  _c2_IsADouble:
	    *((double *)(cur->SharedAddr)) = *((double *)(cur->LocalAddr));
	    break;
	  case _c2_IsAChar:
	    *((char *)(cur->SharedAddr)) = *((char *)(cur->LocalAddr));
	    break;
	 }
#        ifdef _C2_DBGR_
	 if (cur->ReqType == _c2_WRITER) 
	     _c2_writeSpBpAct(na, cur->psplist);
#        endif

	 _c2_RelLock(cur->NSRelAddr, cur->RCount, cur->RQ, cur->WCount, cur->WQ,
		     cur->ReqType);
      } else {
	 int tempsum;
	 int i;
	 int TaskID;

	 /* Map NSRel to PVM task */

	 tempsum = _c2_PvmPathSum(cur->NSRelGraphPath);
	 for (i = 0; i < cur->NSRelIndex.NumInd; i++)
	     tempsum += cur->NSRelIndex.Ind[i];
	 tempsum += cur->NSRelUID;
	 TaskID = tempsum % _c2_nhost;

	 /*      i = cur->NSRelUID % _c2_nhost; */

	 pvm_initsend(PVMDATATYPE);
	 pvm_pkstr(cur->NSRelGraphPath);
	 pvm_pkint(&cur->NSRelUID, 1, 1);
	 pvm_pkint(&cur->NSRelIndex.NumInd, 1, 1);
	 pvm_pkint(&cur->NSRelIndex.Ind[0], cur->NSRelIndex.NumInd, 1);
	 pvm_pkint(&cur->ReqType, 1, 1);
	 pvm_pkint(&cur->UID, 1, 1);
	 if (cur->ReqType == _c2_WRITER) {

#        ifdef _C2_DBGR_
	    _c2_writeSpBpAct(na, cur->psplist);
            _c2_packSPList(*cur->psplist);
#        endif
            
	    pvm_pkint(&cur->TypeTag, 1, 1);
	    switch (cur->TypeTag) {
	     case _c2_IsAnInt:
	       pvm_pkint(&(*((int *) cur->LocalAddr)), 1, 1);
	       break;
	     case  _c2_IsADouble:
	       pvm_pkdouble(&(*((double *) cur->LocalAddr)), 1, 1);
	       break;
	     case _c2_IsAChar:
	       pvm_pkbyte(&(*((char*)cur->LocalAddr)), 1 ,1);
	       break;
	     case _c2_IsAnArrayPtr:
	     case _c2_IsAStructPtr:
	       _c2_PvmPackData(cur->NSRelUID, cur->UID, &cur->LocalAddr); 
	     default:
	       break;
	    }
	 }
	 pvm_send(_c2_tids[TaskID], 5);

      }
      cur = cur->Next;
   }
   *NextLock = *HeadLock;	/* Set NextLock to first lock */
}

