/* c2_misc.h      Things included in all files.
 * 
 */

#ifndef _C2_MISC_
#define _C2_MISC_

/* Include pvm stuff */

#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include <stdio.h>

#define PATH_ID_LENGTH 50

#include "pvm3.h"
#include "c2_forward.h"

#ifdef _C2_DBGR_
#include <c2_udbg_intrf.h>
#endif


/* The following definition must be changed if more than one architecture is
  present in the PVM cluster */

/*#define PVMDATATYPE PvmDataDefault*/
#define PVMDATATYPE PvmDataRaw
/*#define PVMDATATYPE PvmDataInPlace*/


extern int _c2_nhost;
extern int _c2_narch;
extern struct pvmhostinfo **_c2_hostp; 

#define MaxPvmTasks 32
extern int _c2_tids[MaxPvmTasks];

extern char *_c2_cwd; /* Current working directory */
extern int _c2_mytid; /* My pvm task id */
extern int _c2_me;    /* My index in the list of pvm tasks */ 
extern int _c2_Terminated; /* Signal for global terminate */


extern 
char *
_c2_shmalloc(/* unsigned size */);

extern 
void 
_c2_shfree( /* char *ptr */ );

extern 
_c2_NodeBase *
_c2_PathName_Decode(/* char *String */);

extern 
_c2_GraphBase *
_c2_GPathName_Decode(/* char *String */);


 /* Type to hold port indices */

struct _c2_sIndex   {    /* A port can have up to 7 indices */
   int NumInd; 
   int Ind[7];
};

/* this include needs to follow the _c2_sIndex struct definition */
#include "c2_addrmap.h"

  /* Common data for all UC nodes, used by task manager */

enum _c2_ValueType 
 {_c2_IsAChar, _c2_IsAnInt, _c2_IsADouble, _c2_IsAStructPtr, _c2_IsAnArrayPtr};


  /* NSRel Link Set */

typedef struct _c2_sNSLink {
   _c2_NodeBase *Node;
   int IsRemote;      /* Two fields added to account for remote NSRels */
   char *NodePath;
   struct _c2_sNSLink *Next;
} _c2_NSLink;


typedef struct _c2_sLockSet {
   int IsRemote;      /* four fields added on May 26,94 to account for remote */
   int NSRelUID;      /* Name Sharing Relations */
   char *NSRelGraphPath;
   _c2_Index NSRelIndex;

   int RequestSent;   /* Flag to indicate if a remote lock request was made */

   _c2_NSRelBase *NSRelAddr;
   int *RCount;
   _c2_NSLink **RQ;
   int *WCount;
   _c2_NSLink **WQ;
   int ReqType;
   void *SharedAddr;
   void *LocalAddr;
   enum _c2_ValueType TypeTag;
   struct _c2_sLockSet *Next;
   int UID;
#  ifdef _C2_DBGR_
   _c2_List *psplist;
#  endif
} _c2_LockSet;

   /* A UC Node */
 
struct _c2_sNodeBase { 
   int QueueStatus;
   int NSState;
   _c2_LockSet *HeadLock;  /* List of NS locks needed to run */
   _c2_LockSet *NextLock;  /* Next NS lock needed */
   int UID;
   char Path[PATH_ID_LENGTH];   /* New -- for the pvm translator */
   int Crepped;
   _c2_GraphBase *MyGraph;
   _c2_Index Index;

   void (*InitProc)();
   void (*CompProc)();

   void *LocalData;    /* Pointer to struct with local variables */
#ifdef _C2_DBGR_
   _c2_DbgUc dbg;
#endif
};


 /* Common data structure for all graphs. */

struct _c2_sGraphBase {
   int UID;
   _c2_Index Index;
   char Path[PATH_ID_LENGTH];   /* New -- for the pvm translator */

   _c2_GraphBase *Parent;   /* Pointer to calling Graph */
   int CrepsToGo;           /* Count of unbound Creation Params */
   _c2_AddrMap *Map;

   void *LocalData;         /* Pointer to struct of creation params */

#ifdef _C2_DBGR_
   _c2_DbgGph dbg;
#endif
};

 /* Common MainGraph address */

extern _c2_GraphBase *MainGraph;

  /* Common data for all NSRel nodes */

struct _c2_sNSRelBase { 
   int UID;
   _c2_Index Index;
   char Path[PATH_ID_LENGTH];   /* New -- for the pvm translator */
   int Crepped;
   _c2_GraphBase *MyGraph;

   void (*InitProc)();

   void *LocalData;    /* Pointer to struct with local variables */
};


 /* Test for index equality */

int _c2_EqIndex(/* _c2_Index  *i1, _c2_Index *i2 */);

 /* Function mapping node instances to Pvm tasks */

int _c2_PvmTaskMap(/* int UID */);

int _c2_PvmPathSum(/* char *String */);


/* AddrHashTab stuff */


  /* add array with given address and size to size table */

extern 
int 
_c2_AddrHashTabAdd(/* char *Addr, int Size */);

  /* Remove entry from size table */

extern 
int 
_c2_AddrHashTabRemove(/* char *Addr */);

  /* Split entry in table into two-- for when arrays are "split" by
     array distribution functions.  SplittingPoint is in bytes */

extern 
int 
_c2_AddrHashTabSplit(/* char *Addr, int SplittingPoint */);

  /* Look up size of array at addr */

extern 
int 
asize(/* char *Addr */);

  /* Initialize size table-- call before using other size table
     routines */

extern 
void 
_c2_AddrHashTabInit();

/* 
 * for debugger restarting the execution,  we need to deallocate all the
 * LocalData objects in various structs. This is the fastest and the 
 * easiest way of doing it. see cmddbgr.h for rationale
 */

#ifdef _C2_DBGR_
extern 
void 
_c2_reinitAddrHashTab();
#endif 

  /* keep track of amount of space allocated on heap */
extern unsigned _c2_totalloc;

#ifdef _C2_DBGR_
extern int _c2_Master;
extern int _c2_Slave;
#endif 

/* 
 * 
 * PVM message tags (pvm requires that they be greater than zero) :
 * 
 * _c2_Message_Handler() uses tags 1, 2, 3, 4, 5, 6, and 99.
 * 
*/

/* this should be an enum! */

#define _c2_REMOTE_ARC_DATA_TRANSFER      001
#define _c2_REMOTE_RETURN_FROM_GRAPH      002

#define _c2_REMOTE_LOCK_REQUEST           003
#define _c2_REMOTE_LOCK_GRANTED           004
#define _c2_REMOTE_LOCK_RELEASE           005
#define _c2_REMOTE_RETRY_LOCK_REQUEST     006

#define _c2_TERMINATE_ALL_PROCESSES       099

#define _c2_CHILDREN_TASK_ID_ARRAY        100
#define _c2_START_INSTANCE_ID             101

#ifdef _C2_DBGR_
#define _c2_TERMINATION_INSTANCE_ID       102
#define _c2_INSTANCE                      103
#define _c2_EVENT                         104
#define _c2_NEWS_EVENT                    105
#define _c2_SLAVE_DEBUGGER_COMMAND        106
#endif


#endif
