/* workers.c */

#include <stdio.h>
#include "c2_misc.h"
#include "c2_workers.h"

#ifdef _C2_DBGR_
#include <setjmp.h>
#include <signal.h>
#include <errno.h>
#include "debugQ.h"
#endif


   /* Signal a halt to the computation */

void _c2_StopAll()
{
#     ifdef DEBUG
         printf("_c2_StopAll called to end computation\n");
#     endif
      _c2_Terminated = 1;
}


void _c2_KillComp(Reason)
   int Reason;
{
   fprintf(stderr, "\n\n*** CODE fatal runtime error: ");
   switch (Reason) {
     case _c2_CREPTWICE:
       fprintf(stderr, "Attempt to bind 2nd value to creation parameter\n");
       break;
     case _c2_RMFROMEMPTY:
       fprintf(stderr, "Attempt to remove from empty arc\n");
       break;
     default:
       fprintf(stderr, "Unknown problem (internal error?)\n");
       break;
   }
   fflush(stdout);
   fflush(stderr);

   _c2_Terminated = 1;
}

   /* Add a node to the Ready Q */

void _c2_EnQueue(NodeToAdd)
   _c2_NodeBase *NodeToAdd;
{
   _c2_RQLink *tmp;

#ifdef DEBUG
   printf("Adding node with UID %d to Ready Q\n",
	  NodeToAdd->UID); 
#endif


   if (!(NodeToAdd->Crepped)) {  /* Node cannot be run until creps are bound */
      return;
   }

   switch (NodeToAdd->QueueStatus) {
    case _c2_IDLE:
      NodeToAdd->QueueStatus = _c2_ONQUEUE;
#     ifdef _C2_DBGR_
         _c2_timeUcPutOnRdyQ(NodeToAdd); /* performance measurement */
#     endif
      break;
    case _c2_RUNNING:
      NodeToAdd->QueueStatus = _c2_NEEDSRUN;
      return;
      break;

#   ifdef _C2_DBGR_
    case _c2_ONDBGQ: /* debugger will later run it */
#   endif
    case _c2_ONQUEUE:
    case _c2_NEEDSRUN:
      return;
      break;
    default:
      fprintf(stderr, "Error: Illegal Q status in _c2_EnQueue\n");
      fflush(stdout);
      fflush(stderr);
      _c2_StopAll();
   }

   /* If we get here, we need to Q the node */

   if (_c2_FreeList != 0) {
      tmp = _c2_FreeList;
      _c2_FreeList = _c2_FreeList->Next;
   } else {
     tmp = (_c2_RQLink *) _c2_shmalloc(sizeof(_c2_RQLink));
   }

   tmp->Node = NodeToAdd;
   tmp->Next = _c2_Head;
   _c2_Head = tmp;

   return;
}


   /* Get a node to run from the ready Q, return 0 if Q empty */

static _c2_NodeBase *_c2_PopNode()
{
   _c2_NodeBase *ReturnTask;
   _c2_RQLink *TmpHead;


   if (_c2_Head == 0) {
      return 0;
   }

   TmpHead = _c2_Head;
   _c2_Head = _c2_Head->Next;
   ReturnTask = TmpHead->Node;

   TmpHead->Next = _c2_FreeList;
   _c2_FreeList = TmpHead;

   switch (ReturnTask->QueueStatus) {
    case _c2_ONQUEUE:
      ReturnTask->QueueStatus = _c2_RUNNING;
      break;
    default:
      fprintf(stderr, "Error: Illegal Q status in _c2_PopNode\n");
      fflush(stderr);
      fflush(stdout);
      _c2_StopAll();
   }

   return ReturnTask;
}

   /* Process for a worker-- a FastThreads Thread that runs nodes on the
      ready Q */

void _c2_WorkerTask(ID)
   int ID;
{
   _c2_NodeBase *NodeToRun;
   int RunCount = 0;
   int ReRunCount = 0;
   int IdleCount = 0;
   int TotalCount = 0;

#  ifdef DEBUG
     printf("Worker %d starts\n", ID);
#  endif

   while (!_c2_Terminated) {

      TotalCount++;
#     ifdef DEBUG
      if (TotalCount % 50000 == 0) {
	 printf("Worker %d: Total %d, Idle %d, Runs %d, Reruns %d\n",
		ID, TotalCount, IdleCount, RunCount, ReRunCount);
	 fflush(stdout);
      } 
#      endif
#     ifdef _C2_DBGR_
        if (_c2_GlobalState == _c2_STOPPED)  break; /* go look at news */
#     endif

      /* Check to see if you have received any message */

      _c2_Message_Handler();

      /* Check ready queue for a node to run */

      if ( _c2_Head == 0 || (NodeToRun = _c2_PopNode()) == 0) {

#     ifdef _C2_DBGR_
         if (_c2_sizeOutDbgQ() == 0 || (NodeToRun = _c2_PopOutDbgQ()) == 0) {
            _c2_assertWrkrState(ID);
            IdleCount++;
            break;
         }
#     else
         IdleCount++;
         continue;		/* nothing to do */
#     endif/* _C2_DBGR_ */

      }

      RunCount++;

#ifdef DEBUG
      printf("Worker %d Running a %d\n", ID, NodeToRun->UID);
      fflush(stdout);
#endif

    Again:
      NodeToRun->CompProc(NodeToRun);

      switch (NodeToRun->QueueStatus) {
#      ifdef _C2_DBGR_
       case _c2_ONDBGQ:         /* debugger will run it later on */
         break;
#      endif
       case _c2_RUNNING:
	 NodeToRun->QueueStatus = _c2_IDLE;
	 break;
       case _c2_NEEDSRUN:
	 NodeToRun->QueueStatus = _c2_RUNNING;

#        ifdef _C2_DBGR_
	 _c2_timeUcPutOnRdyQ(NodeToRun); /* performance measurement */
#        endif
#        ifdef DEBUG
	 printf("Worker %d Re-running a %d\n", ID, NodeToRun->UID);
	 fflush(stdout);
#        endif
	 ReRunCount++;
	 TotalCount++;
	 goto Again;
	 break;
       default:
	 fprintf(stderr, "Error: Illegal Q status in _c2_WorkerTask\n");
         fflush(stdout);
         fflush(stderr);
	 _c2_Terminated = 1;
	 break;
      }

      if (_c2_Terminated)   {
         pvm_initsend(PVMDATATYPE);
         pvm_pkint( (int *) 0, 0, 1);
         pvm_mcast(_c2_tids, _c2_nhost, 99);
      }
   }
   if (_c2_Terminated) {
#ifdef DEBUG
      printf("Worker %d: Total %d, Idle %d, Runs %d, Reruns %d\n",
	     ID, TotalCount, IdleCount, RunCount, ReRunCount);
      printf("Worker %d terminates\n", ID);
#endif
   }
}


#ifdef _C2_DBGR_
void _c2_RunDebugger(InitNode, argc, argv)
   _c2_NodeBase *InitNode;
     int argc;
     char **argv;
{
   /* tells debugger what the start node is */
   _c2_saveInitNode(InitNode);

   /*
    * tells the debugger the handle to the address map, initializes NewsQ, 
    * current state, set default mode, recording options, etc. : InitAllDebuggerState
    */
   _c2_ScopeInit(InitNode->MyGraph);

   /* used by the worker task to loop indefinitely : while (!terminated) {} */
   _c2_Terminated = 0;

   _c2_dbginstalled = 1;        /* install one debugger task also  */

   /*
    * for sequent compatibility : initializes the array of struct that track the
    * current state of each worker (like worker is idle); "0" is the maximum number
    *  of workers => currently dead wrong, 0 is only right for serial
    */
   _c2_initWrkrDbg(0);

   /*  the main dbx debugger */
   _c2_DebuggerTask(0, argc, argv); 
}


int _c2_Master = false;
int _c2_Slave = false;

void _c2_RunMasterDebugger(StartInstance, argc, argv)
   _c2_InstanceId StartInstance;
   int argc;
   char **argv;
{
   _c2_NodeBase *StartNode;

   /* 
    * the StartNode has already been created on the child/slave and 
    * a pvm message has already been sent to the parent/master. 
    * _c2_processSlaveMessage() will process the _c2_INSTANCE pvm 
    *  message for the StartNode
    */
   _c2_processSlaveMessage();
   StartNode = _c2_getNodeBaseMap(StartInstance);

/* _c2_saveInitNode(StartNode); _c2_ScopeInit(StartNode->MyGraph); */
   _c2_InitializeDebugger_RuntTimeIndependent(MainGraph, StartNode);
 
   _c2_Master = true; /* global variables to split       */
   _c2_Slave = false; /* the master/slave debugger logic */

   _c2_DebuggerTask(0, argc, argv); 
}

void _c2_RunSlaveDebugger(StartNode, argc, argv)
   _c2_NodeBase *StartNode;
   int argc;
   char **argv;
{
/* _c2_saveInitNode(StartNode); _c2_ScopeInit(StartNode->MyGraph); */
   _c2_InitializeDebugger_RuntTimeIndependent(MainGraph, StartNode);
 
/*   _c2_Terminated = 0; _c2_initWrkrDbg(0); */
   _c2_InitializeDebugger_RuntTimeDependent();

   _c2_Master = false; /* global variables to split       */
   _c2_Slave = true;   /* the master/slave debugger logic */
   _c2_DebuggerTask(0, argc, argv); 
}

void _c2_emptyRdyQ()
{
   while(_c2_PopNode())
     ;
}


/* Dummies for compatiblity with FastThreads */

void _c2_KillWorkers()
{
   _c2_StopAll();
}

void _c2_inthandler()
{
   int i;
}

void _c2_ChldHndler()
{ 
   int i;
}

#endif


