/* c2_workers.h */

#ifndef _C2_WORKERS_
#define _C2_WORKERS_

   /* structure for links in  ready Q-- actually LIFO */

typedef struct _c2_Link {
   _c2_NodeBase *Node;
   struct _c2_Link *Next;
} _c2_RQLink;

_c2_RQLink *_c2_Head;
_c2_RQLink *_c2_FreeList;

  /* Run a Pvm task worker in a loop */
extern
void 
_c2_WorkerTask(/* int ID */);

  /* Add a NodeTask to the list to be run */
extern
void 
_c2_EnQueue( /* _c2_NodeBase *Node */ );

  /* Signal end to computation */
extern
void 
_c2_StopAll(/* _c2_NodeBase *n*/ );

  /* Stop computation after error */
extern
void 
_c2_KillComp( /* int Reason */ );

  /* receives and processes PVM message from other tasks */
extern
void 
_c2_Message_Handler();


         /* AbEnd reasons */

#define _c2_CREPTWICE 1
#define _c2_RMFROMEMPTY 2

         /* Node queue states */

#define _c2_IDLE 1       /* Node is not running, and does not need to */
#define _c2_ONQUEUE 2    /* Node is queued to run, but has not started */
#define _c2_RUNNING 3    /* Node is running */
#define _c2_NEEDSRUN 4   /* Node needs to be queued to run again */

#ifdef _C2_DBGR_
#define _c2_ONDBGQ 5     /* node is stopped and on the debug Q */

/* Instead of running the workers, run the debugger first */
extern
void 
_c2_RunDebugger(/*_c2_NodeBase *InitNode, int argc, char **argv */);
extern
void 
_c2_RunMasterDebugger(/*_c2_InstanceId StartInstance, int argc, char **argv*/);
extern
void 
_c2_RunSlaveDebugger(/*int argc, char **argv*/);


/* empty the queue for a new run */
extern
void 
_c2_emptyRdyQ();

/* to handle sigsegv that can not be handled in sequent */
extern
void 
_c2_ChldHndler();

/* Kill all the workers on exit from the debugger */
extern
void 
_c2_KillWorkers();

/* handle the interrupt in c2dbgamin.c */

extern
void 
_c2_inthandler();
#endif /* _C2_DBGR_ */

#endif
