/* c2_misc.h      Things included in all files.
 * 
 */

#ifndef _C2_MISC_
#define _C2_MISC_

  /* Include FastThreads headers */

#include <stdio.h>
#include "c2_forward.h"

#ifdef _C2_DBGR_
#include <c2_udbg_intrf.h>		/* debugger's decl */
#endif 

  /* Things that we should not need but do */

extern char *_c2_shmalloc( /* unsigned size */ );


  /* Type to hold indices */

struct _c2_sIndex   {    /* A node instance is identified by a UID and */
   int NumInd;       /* up to seven indices */
   int Ind[7];
};

#include "c2_addrmap.h"

  /* Common data for all UC nodes, used by task manager */

enum _c2_ValueType 
 {_c2_IsAChar, _c2_IsAnInt, _c2_IsADouble, _c2_IsAStructPtr, _c2_IsAnArrayPtr};


  /* NSRel Link Set */

typedef struct _c2_sNSLink {
   _c2_NodeBase *Node;
   struct _c2_sNSLink *Next;
} _c2_NSLink;


typedef struct _c2_sLockSet {
   _c2_NSRelBase *NSRelAddr;
   void *SharedAddr;
   void *LocalAddr;
   enum _c2_ValueType TypeTag;
   struct _c2_sLockSet *Next;
#ifdef _C2_DBGR_
   _c2_NSLink **Q;		/* provision for replay during interactive debugging */
   _c2_List *psplist;
   int ReqType;
#endif
   int UID;
} _c2_LockSet;

   /* A UC Node */
 
struct _c2_sNodeBase { 
   int QueueStatus;
   int NSState;
   _c2_LockSet *HeadLock;  /* List of NS locks needed to run */
   _c2_LockSet *NextLock;  /* Next NS lock needed */
   int UID;
   int Crepped;
   _c2_GraphBase *MyGraph;
   _c2_Index Index;

   void (*InitProc)();
   void (*CompProc)();

   void *LocalData;    /* Pointer to struct with local variables */
#ifdef _C2_DBGR_
   _c2_DbgUc dbg;
#endif

};


 /* Common data structure for all graphs. */

struct _c2_sGraphBase {
   int UID;
   _c2_Index Index;

   _c2_GraphBase *Parent;   /* Pointer to calling graph */
   int CrepsToGo;           /* Count of unbound Creation Params */
   _c2_AddrMap *Map;

   void *LocalData;         /* Pointer to struct of creation params */
#ifdef _C2_DBGR_
   _c2_DbgGph dbg;
#endif
};


  /* Common data for all NSRel nodes */

struct _c2_sNSRelBase { 
   int UID;
   _c2_Index Index;
   int Crepped;
   _c2_GraphBase *MyGraph;

   void (*InitProc)();

   void *LocalData;    /* Pointer to struct with local variables */

};


 /* Test for index equality */

int _c2_EqIndex(/* _c2_Index *i1; _c2_Index *i2; */);

/* AddrHashTab stuff */


  /* add array with given address and size to size table */

extern int _c2_AddrHashTabAdd(/* char *Addr, int Size */);

  /* Remove entry from size table */

extern int _c2_AddrHashTabRemove(/* char *Addr */);

  /* Split entry in table into two-- for when arrays are "split" by
     array distribution functions.  SplittingPoint is in bytes */

extern int _c2_AddrHashTabSplit(/* char *Addr, int SplittingPoint */);

  /* Look up size of array at addr */

extern int asize(/* char *Addr */);

  /* Initialize size table-- call before using other size table
     routines */

extern void _c2_AddrHashTabInit();

  /* keep track of amount of space allocated on heap */
unsigned _c2_totalloc;

#ifdef _c2_DBGR_
void _c2_reinitAddrHashTab();
#endif

#endif

