proc parse {} {
    global env
    if {$env(REQUEST_METHOD) == "GET"} {
	global GET
	set GET $env(QUERY_STRING)
    } elseif {$env(REQUEST_METHOD) == "POST"} {
	global POST
	# parse out the post string.
	set str [read stdin $env(CONTENT_LENGTH)]
	set items [split $str &]
	foreach n $items {
	    # backslash everything as appropriate.
	    regsub -all {(\[|\]|\{|\}|\"|\$)} $n {\\\1} n
	    # convert pluses into spaces.
	    regsub -all {\+} $n " " n
	    # convert %XX from hex to ASCII and unbackslash.
	    regsub -all {%(..)} $n {[scan "%x" \1 d ; return [format "%c" $d]]} dummy
	    set n [subst $n]
	    # break into key/val pairs.
	    set kl [split $n =]
	    set key [lindex $kl 0]
	    set val [lindex $kl 1]
	    # append or store value.
	    if {[info exists POST($key)]} {
		set POST($key) "$POST($key)\0$val"
	    } else {
		set POST($key) $val
	    }
	}
    }
}
