/* c2_seqvar.h */

#ifndef _C2_SEQVAR_
#define _C2_SEQVAR_


#include "c2_misc.h"

typedef struct _c2_sSeqVar  _c2_SeqVar;
typedef struct _c2_sSeqVar *_c2_SeqVarQ[8];

typedef struct 
{
    enum _c2_ValueType type;
    union 
    {
        char   c;
        int    i;
        double d;
        void  *structure;
        void  *array;
    } u;
#ifdef _C2_DBGR_
    _c2_FpList fplist;
    _c2_Cmd cmd;
#endif
} _c2_Value;

struct _c2_sSeqVar 
{
    _c2_Value value;
    _c2_Index index;
    _c2_SeqVar *next;
};

struct _c2_CacheEntry {
   _c2_Index PortIndex;
   _c2_Index MappedPortIndex;
   _c2_SeqVar **QVar;
   _c2_NodeBase *NodeAddr;
};

#define _c2_CACHESIZE 16

struct _c2_Cache {
   int Current;
   int Len;
   struct _c2_CacheEntry Cache[_c2_CACHESIZE];
};

void _c2_Create(/*_c2_SeqVarQ Q*/);

void _c2_Insert(/*_c2_SeqVarQ Q, _c2_Index* I, _c2_Value *V*/);

int _c2_Check(/*_c2_SeqVarQ Q, _c2_Index *I*/);

int _c2_Remove(/*_c2_SeqVarQ Q, _c2_Index *I, _c2_Value *V*/);

/* routines for SeqVarQ caches */

void _c2_CacheInit( /* struct _c2_Cache *c */ );

void _c2_EnCache( /* struct _c2_Cache *c, _c2_Index *PortIndex,
                     _c2_Index *MappedPortIndex,  _c2_SeqVar **QVar,
		     _c2_NodeBase *NodeAddr */ );

int _c2_FindCache( /* struct _c2_Cache *c, _c2_Index *PortIndex,
		      _c2_Index *MappedPortIndex, _c2_SeqVar ***QVar,
		      _c2_NodeBase **NodeAddr */ );

#endif
