/* Quick Sort an array of integers */

#include <stdio.h>
#include "fthread.h"
#include "fsynch.h"

/* I don't care how many processors I have! */
#define ARRAY_SIZE 10
#define DOSERIAL 2
shared int toSort[ARRAY_SIZE];
void QuickSort();

Main ()
  {
  int i, tmp;

  srandom(0);
  for (i = 0; i < ARRAY_SIZE; i++)
    toSort[i] = i;
  for (i = 0; i < ARRAY_SIZE; i++)
	swap(&toSort[i], &toSort[i + (random() % (ARRAY_SIZE - i))]);
  QuickSort(toSort, ARRAY_SIZE);
  for (i = 0; i < ARRAY_SIZE; i++)
    if (toSort[i] != i)
      {
      printf("Unsorted at %d\n", i);
      ProgramDone();
      }
  printf("Sorted\n");
  ProgramDone();
  }

int Partition (a, n)
  int a[];
  int n;
  {
  register int pivot = a[0];
  register int *low = &a[1];
  register int *high = &a[n - 1];

  for (low = &a[1], high = &a[n - 1]; low <= high; ++low, --high)
    {
    while (*low <= pivot)
      if (++low > high)
		{
		swap(high, &a[0]);
		return(high - &a[0]);
		}
    while (*high > pivot)
      if (--high < low)
		{
		swap(high, &a[0]);
		return(high - &a[0]);
		}
    swap(low, high);
    }
  swap(high, &a[0]);
  return(high - &a[0]);
  }

void QuickSort (a, n)
  int a[];
  int n;
  {
  register int mid = Partition(a, n);
  Thread *t1 = NULL;
  Thread *t2 = NULL;

  if (n - (mid + 1) > DOSERIAL)
    t1 = ThreadStart(QuickSort, JOIN, NULL, 2, &a[mid + 1], n - (mid + 1));

  if (mid > DOSERIAL)
    t2 = ThreadStart(QuickSort, JOIN, NULL, 2, a, mid);

  if (!t1 && n - (mid + 1) > 1)
    QuickSort(&a[mid + 1], n - (mid + 1));

  if (!t2 && mid > 1)
    QuickSort(a, mid);

  if (t1)
    ThreadJoin(t1);
  if (t2)
    ThreadJoin(t2);
}


swap (a, b)
  int *a, *b;
  {
  int tmp = *a;

  *a = *b;
  *b = tmp;
  }
