#
# InInterfaceNode.tcl
# ------------------------------------------------------------------------
# The node which provides input to a subgraph.
# ------------------------------------------------------------------------
# @(#) $Id: InInterfaceNode.tcl,v 1.4 1996/01/11 21:15:39 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


class Code::InInterfaceNode {

    inherit Code::Node

    constructor {args} {
	if {!$_initialized} {
	    init
	}
	eval Code::Node::constructor $args
    } {
	addport OutputPort bottom 1
    }

    public method bitmap {}
    public method translate {ProgramAST GraphAST}
    public method thisimage {}

    protected method draw_node {x y}

    private method init {}


    public common image
    private common _initialized 0

    public variable Type ""
    protected variable attributes {Name Type}

}


body Code::InInterfaceNode::bitmap {} {
    return "@[$canvas info variable ReleaseDirectory -value]/bitmaps/InInterfaceNode.bit"
}


body Code::InInterfaceNode::draw_node {x y} {
    set node [$canvas create image $x $y \
	    -image [thisimage] \
	    -parent $this]
}


body Code::InInterfaceNode::init {} {
    global c2_ReleaseDirectory
    set image(0) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/InInterfaceNode.gif"]
    set image(1) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/InInterfaceNode-Selected.gif"]
    set _initialized 1
}


body Code::InInterfaceNode::thisimage {} {
    return $image($selected)
}


body Code::InInterfaceNode::translate {ProgramAST GraphAST} {
    return [c2_CreateInInterfaceNodeAST $ProgramAST $GraphAST $Name $id "$Type"]
}

