#
# InputPort.tcl
# ------------------------------------------------------------------------
# Derived from Port, this is an arrow going into a node.
# ------------------------------------------------------------------------
# @(#) $Id: InputPort.tcl,v 1.5 1996/02/01 02:38:36 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================

class Code::InputPort {

    inherit Code::Port

    # WORKAROUND - constructor could have parm list of
    # just {args}, but needed full port version to be
    # able to extract x and y for below draw_port workaround.

    constructor {w dir node x y args} {
	if {!$_initialized} {
	    init
	}
	eval Code::Port::constructor $w $dir $node $x $y $args
    } {}

    public method complete_arc {} {}
    public method draw_port {x y args}
    public method thisimage {}
    public method move {dx dy}

    protected common bitmapfile
    protected common image
    private common _initialized 0

    private method init {} {}
}


body Code::InputPort::constructor {w dir node x y args} {

    # WORKAROUND - this *should* be in Port.tcl constructor

    eval draw_port $x $y $args

    # bindings

    $canvas bind $this <Enter> "if \{ !\[string compare \[$canvas tool\] \"Arc\"\] && \[$this accepts\]\} \{ $this activate \}"
    $canvas bind $this <Leave> "if \{ !\[string compare \[$canvas tool\] \"Arc\"\] \} \{ $this deactivate \}"
    $canvas bind $this <Button-1> "if \{ !\[string compare \[$canvas tool\] \"Arc\"\] && \[$this accepts\] \} \{ $this complete_arc \}"

    eval itk_initialize $args
}


body Code::InputPort::complete_arc {} {
    global ::c2_ReshapeArcs

    set arc [$canvas info variable CurrentDrawingArcItem -value]
    if { [string compare $arc "{}"] } {
	$arc arc_end $this
	if {$c2_ReshapeArcs} {
	    $arc reshape
	}
	$this deactivate
	bind [info namespace tail $canvas] <Any-Motion> ""
	$canvas configure -currentDrawingArcItem ""
	Code::CodeCanvas::set_tool Select
    }
}


body Code::InputPort::draw_port {x y args} {
    set port [eval $canvas create image $x $y \
	    -image [thisimage] \
	    -parent $this]
    $canvas addtag InputPort withtag $port
    $canvas addtag $this withtag $port
    $this scale
}


# class initialization

body ::Code::InputPort::init {} {

    global ::c2_ReleaseDirectory
    set rdir $c2_ReleaseDirectory

    set bitmapfile(top,0)    "TopInputPort.gif"
    set bitmapfile(bottom,0) "BottomInputPort.gif"
    set bitmapfile(left,0)   "LeftInputPort.gif"
    set bitmapfile(right,0)  "RightInputPort.gif"

    set bitmapfile(top,1)    "TopInputPort-Selected.gif"
    set bitmapfile(bottom,1) "BottomInputPort-Selected.gif"
    set bitmapfile(left,1)   "LeftInputPort-Selected.gif"
    set bitmapfile(right,1)  "RightInputPort-Selected.gif"

    foreach j {top bottom left right} {
	set image($j,0) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$rdir/bitmaps/$bitmapfile($j,0)"]
    }

    foreach j {top bottom left right} {
	set image($j,1) [uplevel #0 image create photo -palette 256x256x256 -format GIF -file "$rdir/bitmaps/$bitmapfile($j,1)"]
    }

    set _initialized 1
}


body Code::InputPort::move {dx dy} {
    Code::Port::move $dx $dy
    foreach arc $attached_arcs {
	$arc arc_move_endpoints_by $dx $dy
    }
}


body Code::InputPort::thisimage {} {
    return [set image($direction,$active)]
}
