#include "UidTable.h"
#include "../exmodel/exmodel.h"


typedef struct uidlist {
   cAbsTree *node;
   struct uidlist *next;
} UidList, *pUidList;

#define pNullUidList ((pUidList)0)
static pUidList pFirstUidList = pNullUidList;
static pUidList pLastUidList = pNullUidList;


void
PrintUidList(pUidList This)
{
   cout << "   UID list node : abstree node UID = " << This->node->UID << " class is ";
   cout.flush();
   This->node->PrintId();
   //cout << "\n";
   cout.flush();
}

void
PrintWholeUidList()
{
   pUidList pThisUidList;

   cout << "Print the whole UID list :\n";

   for (pThisUidList = pFirstUidList; 
     pThisUidList != pNullUidList; 
     pThisUidList = pThisUidList->next) {

       PrintUidList( pThisUidList );

   }
}

void CreateUidTable()
{
   if (pFirstUidList != pNullUidList) {
      FreeUidTable();
   }

   // redundant
   pFirstUidList = pLastUidList = pNullUidList;
}

void FreeUidTable()
{
   pUidList pThisEntry, pNextEntry;

   if (pFirstUidList != pNullUidList) {
      pThisEntry = pFirstUidList;
      while (pThisEntry != pNullUidList) {
         pNextEntry = pThisEntry->next;

         // Delete storage for node in AST (incl symbol table).
	 delete pThisEntry->node;

         delete pThisEntry;  // delete table link
         pThisEntry = pNextEntry;
      }
   }

   pFirstUidList = pLastUidList = pNullUidList;
}

void InsertUidTable(cAbsTree *Node)
{
   pUidList pThisUidList;

   pThisUidList = new UidList;

   pThisUidList->node = Node;
   pThisUidList->next = pNullUidList;

   if (pLastUidList != pNullUidList) {
      pLastUidList->next = pThisUidList;
      pLastUidList = pThisUidList;
   } else {
      pFirstUidList = pLastUidList = pThisUidList;
   }
}

cAbsTree *FindUidTable(int Uid)
{
   pUidList pThisUidList;
   //ClassId AbsTreeID;

   for (pThisUidList = pFirstUidList; 
     pThisUidList != pNullUidList; 
     pThisUidList = pThisUidList->next) {

       //AbsTreeID = pThisUidList->node->IsA();

       if (pThisUidList->node->UID == Uid) return pThisUidList->node;
   }

   Die("I've fallen in cAbsTree *FindUidTable() and I can't get up.\n");
   return ((cAbsTree *)0); // makes compiler warning go away
}

const char *PathUidTable(int Uid) 
{
   // i) build linked list of cAbsTree of containing graph nodes
   // ii) traverse list in reverse order of insertion => outer to inner scope
   cObList Contain;
   cAbsTree *ThisNode;
   ClassId ObjectClassId;

   for (ThisNode = FindUidTable(Uid); ThisNode != ((cAbsTree *)0); 
     ThisNode = ThisNode->Parent) {

       ObjectClassId = ((cObject *)ThisNode)->IsA();

       switch ( ((cObject *)ThisNode)->IsA() ) {
       case Program:
       case Graph:
       case IntNode:
       case CrepNode:
       case UC:
       case CallNode:
       case NSRel:
       case Arc:
          Contain.Insert(ThisNode);
          break;
       default:
          break;
       }
   }

   cObIterator i;
   cObject *Object;
   static char GreatBigOString[1024];
   char *InsertionPt;

   GreatBigOString[0] = '\0';
   InsertionPt = GreatBigOString;
   for (Object = (cObject *)i.Init(Contain); i.MoreLeft(); Object = (cObject *)i.Next()) {
       switch ( Object->IsA() ) {
       case ::Program:
       {
          cProgram *Program = (cProgram *)Object;
          sprintf(InsertionPt, "Program \"%s\" ", 
            ( (Program->Name != "") ? (char *)Program->Name : "untitled"));
          InsertionPt = GreatBigOString + strlen(GreatBigOString);
       }
          break;
       case ::Graph:
       {
          cGraph *Graph = (cGraph *)Object;
          sprintf(InsertionPt, "+ Graph \"%s\" ", 
            ( (Graph->Name != "") ? (char *)Graph->Name : "untitled"));
          InsertionPt = GreatBigOString + strlen(GreatBigOString);
       }
          break;
       case ::IntNode:
       {
          cIntNode *IntNode = (cIntNode *)Object;
          sprintf(InsertionPt, "+ IntNode \"%s\" ", 
            ( (IntNode->Name != "") ? (char *)IntNode->Name : "untitled"));
          InsertionPt = GreatBigOString + strlen(GreatBigOString);
       }
          break;
       case ::CrepNode:
       {
          cCrepNode *CrepNode = (cCrepNode *)Object;
          sprintf(InsertionPt, "+ CrepNode \"%s\" ", 
            ( (CrepNode->Name != "") ? (char *)CrepNode->Name : "untitled"));
          InsertionPt = GreatBigOString + strlen(GreatBigOString);
       }
          break;
       case ::UC:
       {
          cUC *UC = (cUC *)Object;
          sprintf(InsertionPt, "+ UC \"%s\" ", 
            ( (UC->Name != "") ? (char *)UC->Name : "untitled"));
          InsertionPt = GreatBigOString + strlen(GreatBigOString);
       }
          break;
       case ::CallNode:
       {
          cCallNode *CallNode = (cCallNode *)Object;
          sprintf(InsertionPt, "+ CallNode \"%s\" ", 
            ( (CallNode->Name != "") ? (char *)CallNode->Name : "untitled"));
          InsertionPt = GreatBigOString + strlen(GreatBigOString);
       }
          break;
       case ::NSRel:
       {
          cNSRel *NSRel = (cNSRel *)Object;
          sprintf(InsertionPt, "+ NSRel \"%s\" ", 
            ( (NSRel->Name != "") ? (char *)NSRel->Name : "untitled"));
          InsertionPt = GreatBigOString + strlen(GreatBigOString);
       }
          break;
       case ::Arc:
       {
          cArc *Arc = (cArc *)Object;
          sprintf(InsertionPt, "+ Arc \"%s\" ", 
            ( (Arc->Name != "") ? (char *)Arc->Name : "untitled"));
          InsertionPt = GreatBigOString + strlen(GreatBigOString);
       }
          break;
       default:
          break;
       }
   }

   return GreatBigOString;
}
  

int GetContainingUid(int Uid)
{
   cAbsTree *ThisNode;
   ClassId ObjectClassId;

   for (ThisNode = FindUidTable(Uid); ThisNode != ((cAbsTree *)0); 
     ThisNode = ThisNode->Parent) {

       ObjectClassId = ThisNode->IsA();

       switch ( ObjectClassId ) {
       case Program:
       case Graph:
       case IntNode:
       case CrepNode:
       case UC:
       case CallNode:
       case NSRel:
       case Arc:
          return ThisNode->UID;
       default:
          break;
       }
   }

   return Uid;
 }
