#
# createDialogs.tcl
# ------------------------------------------------------------------------
# When "sourced", creates all of the dialog windows used by CODE.
# ------------------------------------------------------------------------
# @(#) $Id: createDialogs.tcl,v 1.10 1996/03/05 17:07:30 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


global c2_tmp c2_MonoFont

# these variables MUST be initialized to some value before
# they are used as a -variable argument (since that invokes
# a trace) in Scrolledtext.

set c2_tmp(Name) ""
set c2_tmp(Type) ""
set c2_tmp(text) ""
set c2_tmp(TraceCall) ""
set c2_tmp(GraphFunctionSignatures) ""
set c2_tmp(GraphFunctionDefinitions) ""
set c2_tmp(GraphDocumentation) ""
set c2_tmp(c2_PrintToPrinter) 0
set c2_tmp(c2_PVMHosts) ""
set c2_tmp(c2_GlobalTypes) ""
set c2_tmp(c2_GlobalFunctionSignatures) ""
set c2_tmp(c2_GlobalFunctionDefinitions) ""
set c2_tmp(c2_GlobalDocumentation) ""
set c2_tmp(c2_FilesToLink) ""
set c2_tmp(annotation) ""
set c2_tmp(Documentation) ""
set c2_tmp(Specification) ""
set c2_tmp(InitComputation) ""
set c2_tmp(Computation) ""
set c2_tmp(LocalVariables) ""
set c2_tmp(SharedVariables) ""
set c2_tmp(FiringRules) ""
set c2_tmp(InputPorts) ""
set c2_tmp(RoutingRules) ""
set c2_tmp(OutputPorts) ""
set c2_tmp(Docs) ""
set c2_tmp(SharedVars) ""
set c2_tmp(LocalVars) ""
set c2_tmp(InitComp) ""


# CallNode Annotations

Code::Dialog ._CallNodeattributes -title "Code: Call Node Annotations"
[._CallNodeattributes subwidget buttonbox] add _OK -text "OK" -command "._CallNodeattributes okcmd"
[._CallNodeattributes subwidget buttonbox] add _Cancel -text "Cancel" -command "._CallNodeattributes cancelcmd"

set attrframe [info namespace tail ._CallNodeattributes]
LabeledEntry $attrframe.name -label "Name:" -text c2_tmp(Name)
checkbutton $attrframe.isalias -relief flat -text "Alias to another container" -variable c2_tmp(IsAliasToGraph) -command {global c2_tmp ; if {$c2_tmp(IsAliasToGraph)} { c2_HierarchySelect alias .hierarchy c2_tmp(AliasGraph) ; set c2_tmp(AliasGraphName) [$c2_tmp(AliasGraph) info variable Name -value]} else { set c2_tmp(AliasGraphName) "(not an alias)"}}
set c2_tmp(AliasGraphName) "(not an alias)"
label $attrframe.aliasname -textvariable c2_tmp(AliasGraphName)
checkbutton $attrframe.trace -relief flat -text "Trace this node" -variable c2_tmp(TraceCall)
iwidgets::Scrolledtext $attrframe._GraphFunctionSignatures \
	-labeltext "Function signatures:" \
	-variable c2_tmp(GraphFunctionSignatures) \
	-visibleitems 40x4 -textfont $c2_MonoFont
iwidgets::Scrolledtext $attrframe._GraphFunctionDefinitions \
	-labeltext "Function definitions:" \
	-variable "c2_tmp(GraphFunctionDefinitions)" \
	-visibleitems 40x4 -textfont $c2_MonoFont
iwidgets::Scrolledtext $attrframe._GraphDocumentation \
	-labeltext "Documentation:" \
	-variable "c2_tmp(GraphDocumentation)" \
	-visibleitems 40x4 -textfont $c2_MonoFont
pack append $attrframe \
	$attrframe.name {top frame center expand fill} \
        $attrframe.isalias {top frame center expand} \
        $attrframe.aliasname {top frame center expand} \
	$attrframe.trace {top frame center expand} \
	$attrframe._GraphFunctionSignatures {top frame center expand fill} \
	$attrframe._GraphFunctionDefinitions {top frame center expand fill} \
	$attrframe._GraphDocumentation {top frame center expand fill}


#############################
#                           #
# set up all dialog windows #
#                           #


# about CODE

Code::Dialog .aboutdialog -title "Code: About CODE"
[.aboutdialog subwidget buttonbox] add _OK -text "OK" -command ".aboutdialog okcmd"
set f .aboutdialog

set splash [image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/code-screen-logo.gif"]

label $f.splash -image $splash -borderwidth 0
pack $f.splash -expand yes -fill both -anchor n
message $f.subtitle -width 10c -justify center \
	-font {-adobe-new century schoolbook-bold-i-normal-*-14-140-75-75-p-88-iso8859-1} \
	-text "version 2.1b1"
pack $f.subtitle -side top -anchor center
message $f.msg -width 10c -text "
GUI : Emery Berger
Back-ends : Emery Berger, Peter Newton, Rajeev Vokkarne, Brian West
Concept : Professor J.C. Browne" \
	-font {-adobe-new century schoolbook-medium-r-normal-*-14-140-75-75-p-82-iso8859-1}

message $f.http -width 10c -text "http://www.cs.utexas.edu/users/code" \
	-font -adobe-courier-medium-r-normal-*-14-140-75-75-m-90-iso8859-1

message $f.copyright -width 10c -text "Copyright \251 1995 The University of Texas at Austin" \
	-font -adobe-times-medium-i-normal-*-14-140-75-75-p-73-iso8859-1

pack $f.copyright -pady 10 -anchor center
pack $f.msg -anchor center
pack $f.http -pady 5 -anchor center


# error

Code::Dialog .error -title "Code: Error"
[.error subwidget buttonbox] add _OK -text "OK" -command ".error okcmd"


# new file


Code::Dialog .newdialog -title "Code: New file"
[.newdialog subwidget buttonbox] add _OK -text "OK" -command ".newdialog okcmd"
[.newdialog subwidget buttonbox] add _Cancel -text "Cancel" -command ".newdialog cancelcmd"

label .newdialog.image -bitmap question
label .newdialog.label -text "Are you sure? (This will erase any unsaved work.)" -height 3

pack .newdialog.image -side left -anchor w -expand yes -fill both -padx 10
pack .newdialog.label -anchor c -expand yes -fill both



# quit

Code::Dialog .quitdialog -title "Code: Quit Code"
[.quitdialog subwidget buttonbox] add _OK -text "OK" -command ".quitdialog okcmd"
[.quitdialog subwidget buttonbox] add _Cancel -text "Cancel" -command ".quitdialog cancelcmd"

label .quitdialog.image -bitmap question
label .quitdialog.label -text "Are you sure you want to quit?" -height 3

pack .quitdialog.image -side left -anchor w -expand yes -fill both -padx 10
pack .quitdialog.label -anchor c -expand yes -fill both


# not-implemented-yet

Code::Dialog .not_implemented_yet -title "Code: Unimplemented feature"
[.not_implemented_yet subwidget buttonbox] add _OK -text "OK" -command ".not_implemented_yet okcmd"
[.not_implemented_yet subwidget buttonbox] add _Cancel -text "Cancel" -command ".not_implemented_yet cancelcmd"

pack [label .not_implemented_yet.label -text "Sorry, this feature is not yet available."] -expand yes -fill both


# print

Code::Dialog .printdialog -title "Code: Printer Setup"
[.printdialog subwidget buttonbox] add _OK -text "OK" -command ".printdialog okcmd"
[.printdialog subwidget buttonbox] add _Cancel -text "Cancel" -command ".printdialog cancelcmd"

set printframe .printdialog

if 0 {
    optionmenu $printframe.printer \
	-labeltext "Choose printer:" -command "set c2_tmp(c2_PrinterName)" \
	-labelpos w -width 5
    
    pack $printframe.printer -side top -fill x -anchor w
    
    foreach printer [printers] {
	$printframe.printer insert end $printer $printer
    }
    
    global c2_PrinterName
    if { ![string compare $c2_PrinterName ""] } {
	set c2_PrinterName [lindex $printers 0]
    }
    
    $printframe.printer select "$c2_PrinterName"
}


frame $printframe.printto
pack $printframe.printto -side top -fill x

label $printframe.printto.dest -text "Print To:" -width 15

radiobutton $printframe.printto.printer -text "Printer" -variable c2_tmp(c2_PrintToPrinter) -value 1 -width 15
radiobutton $printframe.printto.file -text "File" -variable c2_tmp(c2_PrintToPrinter) -value 0 -width 15

trace variable c2_tmp(c2_PrintToPrinter) rw c2_update_print_dlog

proc c2_update_print_dlog {n e op} {
    global c2_tmp
    
    .printdialog.command configure -state [lindex {{disabled} {normal}} $c2_tmp(c2_PrintToPrinter)]
    .printdialog.filename configure -state [lindex {{disabled} {normal}} [expr !($c2_tmp(c2_PrintToPrinter))]]
}

pack $printframe.printto.dest $printframe.printto.printer $printframe.printto.file -in $printframe.printto -side left -fill x -expand yes

LabeledEntry $printframe.command -label "Print Command:" -text c2_tmp(c2_PrintCommand)
pack $printframe.command -side top -fill x -expand yes

LabeledEntry $printframe.filename -label "File Name:" -text c2_tmp(c2_PrintFilename)
pack $printframe.filename -side top -fill x -expand yes

tixLabelFrame $printframe._PageOptions -label ""
pack $printframe._PageOptions -side top -anchor w -expand yes -fill x
set f [$printframe._PageOptions subwidget frame]

if 0 {

frame $f._PrintOrder
pack $f._PrintOrder -side top -fill x

label $f._PrintOrder._Label -text "Print Order:" -width 15
radiobutton $f._PrintOrder._First -text "First Page First" -variable c2_tmp(c2_PrintFirstPageFirst) -value 1 -width 15
radiobutton $f._PrintOrder._Last  -text "Last Page First" -variable c2_tmp(c2_PrintFirstPageFirst) -value 0 -width 15

pack $f._PrintOrder._Label $f._PrintOrder._First $f._PrintOrder._Last -side left -fill x -expand yes
}

frame $f._PrintOrientation
pack $f._PrintOrientation -side top -fill x

label $f._PrintOrientation._Label -text "Orientation:" -width 15
radiobutton $f._PrintOrientation._Portrait -text "Portrait" -variable c2_tmp(c2_PrintPortraitMode) -value 1 -width 15
radiobutton $f._PrintOrientation._Landscape  -text "Landscape" -variable c2_tmp(c2_PrintPortraitMode) -value 0 -width 15

pack $f._PrintOrientation._Label $f._PrintOrientation._Portrait $f._PrintOrientation._Landscape -side left -fill x -expand yes


frame $f._PrintColor
pack $f._PrintColor -side top -fill both

label $f._PrintColor._Label -text "Print:" -width 15
radiobutton $f._PrintColor._Greyscale -text "Greyscale" -variable c2_tmp(c2_PrintGreyscale) -value 1 -width 15
radiobutton $f._PrintColor._Color  -text "Color" -variable c2_tmp(c2_PrintGreyscale) -value 0 -width 15

pack $f._PrintColor._Label $f._PrintColor._Greyscale $f._PrintColor._Color -side left -fill x -expand yes -anchor w

if 0 {

frame $f._PrintSize1
pack $f._PrintSize1 -side top -fill both
frame $f._PrintSize2
pack $f._PrintSize2 -side top -fill both
frame $f._PrintSize3
pack $f._PrintSize3 -side top -fill both

label $f._PrintSize1._Label -text "Paper Size:" -width 15
radiobutton $f._PrintSize1._Letter -text "Letter" -variable c2_tmp(c2_PrintPaperSize) -value 0 -width 15
radiobutton $f._PrintSize1._Legal  -text "Legal" -variable c2_tmp(c2_PrintPaperSize) -value 1 -width 15

pack $f._PrintSize1._Label $f._PrintSize1._Letter $f._PrintSize1._Legal -side left -fill x -expand yes -anchor w

label $f._PrintSize2._Empty -text "" -width 15
radiobutton $f._PrintSize2._Executive -text "Executive" -variable c2_tmp(c2_PrintPaperSize) -value 2 -width 15
radiobutton $f._PrintSize2._A4  -text "A4" -variable c2_tmp(c2_PrintPaperSize) -value 3 -width 15

pack $f._PrintSize2._Empty $f._PrintSize2._Executive $f._PrintSize2._A4 -side left -fill x -expand yes -anchor w
}


# machine setup

Code::Dialog ._MachineSetup -title "Code: Execution Setup"
[._MachineSetup subwidget buttonbox] add _OK -text "OK" -command "._MachineSetup okcmd"
[._MachineSetup subwidget buttonbox] add _Cancel -text "Cancel" -command "._MachineSetup cancelcmd"

set attrframe ._MachineSetup

set f [frame $attrframe._NPFrame]
pack $f -side top -fill x

tixLabelFrame $f._CompilerOptions -label "Compiler Options"
pack $f._CompilerOptions -padx 5 -side left -anchor center -fill y -expand yes
set g [$f._CompilerOptions subwidget frame]

checkbutton $g._OptimizeProgram -text "Optimize Program" -variable c2_tmp(c2_OptimizeProgram) -command { if $c2_tmp(c2_OptimizeProgram) { set c2_tmp(c2_DebuggerOn) 0 } }
checkbutton $g._DebuggerOn -text "Use Debugger" -variable c2_tmp(c2_DebuggerOn) -command { if $c2_tmp(c2_DebuggerOn) { set c2_tmp(c2_OptimizeProgram) 0 }}

pack $g._OptimizeProgram $g._DebuggerOn -side top -fill both -padx 5 -anchor w -expand yes


tixLabelFrame $f._TranslationTarget -label "Target architecture"
pack $f._TranslationTarget -padx 5 -side right -anchor center -fill y -expand yes

set g [$f._TranslationTarget subwidget frame]
radiobutton $g._Cray -text "Cray" -value {Cray} -variable c2_tmp(c2_TranslationTarget)
radiobutton $g._PVM -text "PVM" -value {PVM} -variable c2_tmp(c2_TranslationTarget)
radiobutton $g._Sequent -text "Sequent" -value {Sequent} -variable c2_tmp(c2_TranslationTarget)
radiobutton $g._Sparc -text "Sparc MP" -value {Sparc} -variable c2_tmp(c2_TranslationTarget)
radiobutton $g._Serial -text "Serial" -value {Serial} -variable c2_tmp(c2_TranslationTarget)

pack  $g._Cray $g._PVM $g._Sequent $g._Sparc $g._Serial -side top -fill both -anchor w -padx 5 -expand yes


# global Annotations

Code::Dialog ._Globalattributes -title "Code: Program Annotations"
[._Globalattributes subwidget buttonbox] add _OK -text "OK" -command "._Globalattributes okcmd"
[._Globalattributes subwidget buttonbox] add _Cancel -text "Cancel" -command "._Globalattributes cancelcmd"

set attrframe ._Globalattributes
tixNoteBook $attrframe._Options
$attrframe._Options add _Types -label "Types"
$attrframe._Options add _Signatures -label "Signatures"
$attrframe._Options add _Definitions -label "Definitions"
$attrframe._Options add _Documentation -label "Documentation"
$attrframe._Options add _Link -label "Link"

pack $attrframe._Options -side top -expand yes -fill both -padx 10 -pady 10

if 0 {
Code::Scrolledtext $attrframe._GlobalTypes -labeltext "Types:" -height 4 -width 40
}

set f [$attrframe._Options subwidget _Types]
iwidgets::Scrolledtext $f._GlobalTypes \
	 -labeltext "Types:" \
         -visibleitems 40x4  -textfont $c2_MonoFont \
	 -variable "c2_tmp(c2_GlobalTypes)"
pack append $f \
	$f._GlobalTypes {top frame center expand fill}

set f [$attrframe._Options subwidget _Signatures]
iwidgets::Scrolledtext $f._GlobalFunctionSignatures \
	-labeltext "Function signatures:" \
	-variable "c2_tmp(c2_GlobalFunctionSignatures)" \
	-visibleitems 40x4 -textfont $c2_MonoFont
pack append $f \
	$f._GlobalFunctionSignatures {top frame center expand fill}

set f [$attrframe._Options subwidget _Definitions]
iwidgets::Scrolledtext $f._GlobalFunctionDefinitions \
	-labeltext "Function definitions:" \
	-variable "c2_tmp(c2_GlobalFunctionDefinitions)" \
	-visibleitems 40x4 -textfont $c2_MonoFont
pack append $f \
	$f._GlobalFunctionDefinitions {top frame center expand fill}

set f [$attrframe._Options subwidget _Documentation]
iwidgets::Scrolledtext $f._GlobalDocumentation \
	-labeltext "Documentation:" \
	-variable "c2_tmp(c2_GlobalDocumentation)" \
	-visibleitems 40x4 -textfont $c2_MonoFont
pack append $f \
	$f._GlobalDocumentation {top frame center expand fill}

set f [$attrframe._Options subwidget _Link]
iwidgets::Scrolledtext $f._FilesToLink \
	-labeltext "Object files to link:" \
	-variable "c2_tmp(c2_FilesToLink)" \
	-visibleitems 40x4 -textfont $c2_MonoFont
pack append $f \
	$f._FilesToLink {top frame center expand fill}


####################


# arc Annotations (this one is huge)

Code::Dialog ._Arcattributes -title "Code: Arc Annotations"
[._Arcattributes subwidget buttonbox] add _OK -text "OK" -command "._Arcattributes okcmd"
[._Arcattributes subwidget buttonbox] add _Cancel -text "Cancel" -command "._Arcattributes cancelcmd"

set attrframe ._Arcattributes
frame $attrframe.topframe
frame $attrframe.bottomframe
pack $attrframe.topframe -side top -fill both -expand yes
pack $attrframe.bottomframe -side top -expand yes -pady 5 -padx 5

frame $attrframe.topframe.left
pack $attrframe.topframe.left -side left -fill x -expand yes

frame $attrframe.topframe.right
pack $attrframe.topframe.right -side right -fill x -expand yes

foreach i {left right} {
    frame $attrframe.topframe.$i.top
    frame $attrframe.topframe.$i.middle
    frame $attrframe.topframe.$i.bottom
    
    pack $attrframe.topframe.$i.top $attrframe.topframe.$i.middle $attrframe.topframe.$i.bottom -side top -fill x -expand yes

    #
    #  Display the appropriate message above the pane.
    #
    
    label $attrframe.topframe.$i.top.title -text "" -font "-adobe-times-medium-i-normal--18-*-*"
    pack $attrframe.topframe.$i.top.title -side top -anchor w -fill x -expand yes -padx 10

    #
    #  Display the icon and name of the node.
    #

    frame $attrframe.topframe.$i.top.node
    pack $attrframe.topframe.$i.top.node -side top -pady 10 -padx 10 -fill both -expand yes
    
    label $attrframe.topframe.$i.top.node.icon
    label $attrframe.topframe.$i.top.node.label
    pack $attrframe.topframe.$i.top.node.icon $attrframe.topframe.$i.top.node.label -side left -anchor w


    #
    #  Set up the list of ports.
    #

    tixScrolledHList $attrframe.topframe.$i.middle.ports
    [$attrframe.topframe.$i.middle.ports subwidget hlist] configure -selectmode browse

    pack $attrframe.topframe.$i.middle.ports -expand yes -fill both -padx 10 -pady 10
    

    #
    #  Create the index entry forms.
    #

    LabeledEntry $attrframe.topframe.$i.bottom.callindex -label "Call index:" -text c2_tmp(${i}callindex)

    LabeledEntry $attrframe.topframe.$i.bottom.nodeindex -label "Node index:" -text c2_tmp(${i}nodeindex)

    LabeledEntry $attrframe.topframe.$i.bottom.portindex -label "Port index:" -text c2_tmp(${i}portindex)

    pack $attrframe.topframe.$i.bottom.callindex $attrframe.topframe.$i.bottom.nodeindex $attrframe.topframe.$i.bottom.portindex  -side top -anchor w -padx 5 -expand yes -fill x

}


#
#  The updated arc annotation text
#

label $attrframe.bottomframe.arc_anno_title -text "Current Arc Annotation Expression" \
    -font "-adobe-helvetica-bold-o-normal--14-*-*"
pack $attrframe.bottomframe.arc_anno_title -side top -expand yes -pady 10 -padx 5

frame $attrframe.bottomframe.annoframe -borderwidth 2 -relief ridge
pack $attrframe.bottomframe.annoframe

label $attrframe.bottomframe.annoframe.arc_annotation -textvariable {c2_tmp(annotation)} \
    -font "-adobe-helvetica-bold-o-normal--14-*-*"
pack $attrframe.bottomframe.annoframe.arc_annotation -side top -expand yes -pady 5 -padx 10


#######################


# Comment Annotations

Code::Dialog ._Commentattributes -title "Code: Text"
[._Commentattributes subwidget buttonbox] add _OK -text "OK" -command "._Commentattributes okcmd"
[._Commentattributes subwidget buttonbox] add _Cancel -text "Cancel" -command "._Commentattributes cancelcmd"

set attrframe ._Commentattributes
LabeledEntry $attrframe.name -label "Text:" -text c2_tmp(text)
pack append $attrframe \
	$attrframe.name {top frame center expand fill}

# Label Annotations

Code::Dialog ._Labelattributes -title "Code: Text"
[._Labelattributes subwidget buttonbox] add _OK -text "OK" -command "._Labelattributes okcmd"
[._Labelattributes subwidget buttonbox] add _Cancel -text "Cancel" -command "._Labelattributes cancelcmd"

set attrframe ._Labelattributes
LabeledEntry $attrframe.name -label "Text:" -text c2_tmp(text)
pack append $attrframe \
	$attrframe.name {top frame center expand fill}


# InInterfaceNode Annotations

Code::Dialog ._InInterfaceNodeattributes -title "Code: In Interface Node Annotations"
[._InInterfaceNodeattributes subwidget buttonbox] add _OK -text "OK" -command "._InInterfaceNodeattributes okcmd"
[._InInterfaceNodeattributes subwidget buttonbox] add _Cancel -text "Cancel" -command "._InInterfaceNodeattributes cancelcmd"

set attrframe ._InInterfaceNodeattributes
LabeledEntry $attrframe.name -label "Name:" -text c2_tmp(Name)
LabeledEntry $attrframe.type -label "Type:" -text c2_tmp(Type)
pack append $attrframe \
	$attrframe.name {top frame center expand fill} \
	$attrframe.type {top frame center expand fill}

# OutInterfaceNode Annotations

Code::Dialog ._OutInterfaceNodeattributes -title "Code: Out Interface Node Annotations"
[._OutInterfaceNodeattributes subwidget buttonbox] add _OK -text "OK" -command "._OutInterfaceNodeattributes okcmd"
[._OutInterfaceNodeattributes subwidget buttonbox] add _Cancel -text "Cancel" -command "._OutInterfaceNodeattributes cancelcmd"

set attrframe ._OutInterfaceNodeattributes
LabeledEntry $attrframe.name -label "Name:" -text c2_tmp(Name)
LabeledEntry $attrframe.type -label "Type:" -text c2_tmp(Type)
pack append $attrframe \
	$attrframe.name {top frame center expand fill} \
	$attrframe.type {top frame center expand fill}

# CreationParameterNode Annotations

Code::Dialog ._CreationParameterNodeattributes \
	-title "Code: Creation Parameter Node Annotations"
[._CreationParameterNodeattributes subwidget buttonbox] add _OK -text "OK" -command "._CreationParameterNodeattributes okcmd"
[._CreationParameterNodeattributes subwidget buttonbox] add _Cancel -text "Cancel" -command "._CreationParameterNodeattributes cancelcmd"


set attrframe ._CreationParameterNodeattributes
LabeledEntry $attrframe.name -label "Name:" -text c2_tmp(Name)
LabeledEntry $attrframe.type -label "Type:" -text c2_tmp(Type)
pack append $attrframe \
	$attrframe.name {top frame center expand fill} \
	$attrframe.type {top frame center expand fill}

# CompNode Annotations

Code::Dialog ._CompNodeattributes -title "Code: Computation Node Annotations"
[._CompNodeattributes subwidget buttonbox] add _OK -text "OK" -command "._CompNodeattributes okcmd"
[._CompNodeattributes subwidget buttonbox] add _Cancel -text "Cancel" -command "._CompNodeattributes cancelcmd"

set attrframe ._CompNodeattributes

set f [frame $attrframe._NameFrame]
pack $f -side top -fill both -expand yes
LabeledEntry $f._Name -label "Name:" -text c2_tmp(Name)
pack $f._Name -side top

set f [frame $attrframe._NodeStatus]
pack $f -side top -fill both -expand yes -pady 5

checkbutton $f._IsStartNode -text "Start Node" -variable c2_tmp(IsStartNode)
checkbutton $f._IsTerminationNode -text "Stop Node" -variable c2_tmp(IsTerminationNode)
pack $f._IsStartNode $f._IsTerminationNode -side top -padx 5 -expand yes

iwidgets::Scrolledtext $f._Documentation -labeltext "Documentation:" \
    -variable "c2_tmp(Documentation)" -visibleitems 40x2 -textfont $c2_MonoFont
iwidgets::Scrolledtext $f._LocalVariables -labeltext "Local Variables:" \
    -variable "c2_tmp(LocalVariables)" -visibleitems 40x4  -textfont $c2_MonoFont
pack $f._Documentation $f._LocalVariables -side top -expand yes -fill both


tixNoteBook $attrframe._Computation
$attrframe._Computation add _Computation -label "Computation"
$attrframe._Computation add _Variables   -label "Variables"
$attrframe._Computation add _IO          -label "I/O"
# $attrframe._Computation add -label "Tracing"

# $attrframe._Computation subwidget nbframe configure -backpagecolor gray
pack $attrframe._Computation -side top -expand yes -fill both -padx 10 -pady 10

#set f [$attrframe._Computation childsite 0]
set f [$attrframe._Computation subwidget _Computation]

iwidgets::Scrolledtext $f._InitComputation -labeltext "Initial Computation:" \
    -variable "c2_tmp(InitComputation)" -visibleitems 40x4  -textfont $c2_MonoFont
iwidgets::Scrolledtext $f._Computation -labeltext "Every Computation:" \
    -variable "c2_tmp(Computation)" -visibleitems 40x4  -textfont $c2_MonoFont
pack append $f \
    $f._InitComputation {top frame center expand fill} \
    $f._Computation {top frame center expand fill}

set f [$attrframe._Computation subwidget _Variables]

iwidgets::Scrolledtext $f._SharedVariables -labeltext "Shared Variables:" \
    -variable "c2_tmp(SharedVariables)" -visibleitems 40x4  -textfont $c2_MonoFont

pack append $f \
    $f._SharedVariables {top frame center expand fill}


set f [$attrframe._Computation subwidget _IO]

tixNoteBook $f._IO
$f._IO add _Input -label "Input"
$f._IO add _Output -label "Output"

if 0 {
    iwidgets::tabnotebook $f._IO
    $f._IO add -label "Input"
    $f._IO add -label "Output"
    $f._IO select 0
}    

pack $f._IO -side top -padx 10 -pady 10 -expand yes -fill both


set g [$f._IO subwidget _Input]

# set g [$f._IO childsite 0]
# pack $g -side top -fill both

iwidgets::Scrolledtext $g._FiringRules -labeltext "Firing Rules:" \
    -variable "c2_tmp(FiringRules)" -visibleitems 40x4  -textfont $c2_MonoFont

iwidgets::Scrolledtext $g._InputPorts -labeltext "Input Ports:" \
    -variable "c2_tmp(InputPorts)" -visibleitems 40x4  -textfont $c2_MonoFont
pack $g._InputPorts $g._FiringRules -side top -fill both -expand yes


set g [$f._IO subwidget _Output]

# set g [$f._IO childsite 1]
# pack $g -side top

iwidgets::Scrolledtext $g._RoutingRules -labeltext "Routing Rules:" \
    -variable "c2_tmp(RoutingRules)" -visibleitems 40x4  -textfont $c2_MonoFont

iwidgets::Scrolledtext $g._OutputPorts -labeltext "Output Ports:" \
    -variable "c2_tmp(OutputPorts)" -visibleitems 40x4  -textfont $c2_MonoFont
pack $g._OutputPorts $g._RoutingRules -side top -fill both -expand yes



# disable tracing options for now.

if 0 {

    set f [$attrframe._Computation subwidget _Tracing]

tixLabelFrame $f._MainOptions -label ""
pack $f._MainOptions -padx 5 -side top
set g [$f._MainOptions subwidget frame]

checkbutton $g._TraceEnable -text "Enable tracing" -variable c2_tmp(TraceEnable)
checkbutton $g._IsBreakPoint -text "Make this a breakpoint" -variable c2_tmp(IsBreakPoint)
checkbutton $g._TracePointBeforeNode -text "Trace point before node" -variable c2_tmp(TracePointBeforeNode)
pack $g._TraceEnable $g._IsBreakPoint $g._TracePointBeforeNode -side top -anchor w -padx 5


tixLabelFrame $f._OtherOptions -label ""
pack $f._OtherOptions -padx 5 -side top -anchor center
set g [$f._OtherOptions subwidget frame]
LabeledEntry $g._TraceWhen -label "Trace when?" -text c2_tmp(TraceWhen)
LabeledEntry $g._TraceFrequency -label "Trace frequency:" -text c2_tmp(TraceFrequency)
LabeledEntry $g._VariablesToTrace -label "Variables to trace:" -text c2_tmp(VariablesToTrace) -width 20
pack $g._TraceWhen $g._TraceFrequency $g._VariablesToTrace -side top -fill x -padx 5

}


############### NameSharingNode

Code::Dialog ._NameSharingNodeattributes -title "Code: Name Sharing Node Annotations"
[._NameSharingNodeattributes subwidget buttonbox] add _OK -text "OK" -command "._NameSharingNodeattributes okcmd"
[._NameSharingNodeattributes subwidget buttonbox] add _Cancel -text "Cancel" -command "._NameSharingNodeattributes cancelcmd"

set attrframe ._NameSharingNodeattributes
LabeledEntry $attrframe._Name -label "Name:" -text c2_tmp(Name)
tixNoteBook $attrframe._Options
$attrframe._Options add _Documentation -label "Documentation"
$attrframe._Options add _SharedVariables -label "Shared Variables"
$attrframe._Options add _LocalVariables -label "Local Variables"
$attrframe._Options add _InitComputation -label "Initial Computation"

pack append $attrframe \
    $attrframe._Name {top frame center expand fill}

pack $attrframe._Options -side top -anchor center -expand yes -fill both -padx 10 -pady 10


set f [$attrframe._Options subwidget _Documentation]
iwidgets::Scrolledtext $f._Documentation -labeltext "Documentation:" \
    -variable "c2_tmp(Docs)" \
    -visibleitems 40x4  -textfont $c2_MonoFont
pack append $f \
	$f._Documentation {top frame center expand fill}

set f [$attrframe._Options subwidget _SharedVariables]
iwidgets::Scrolledtext $f._SharedVariables -labeltext "Shared Variables:" \
    -variable "c2_tmp(SharedVars)" \
    -visibleitems 40x4 -textfont $c2_MonoFont
pack append $f \
	$f._SharedVariables {top frame center expand fill}

set f [$attrframe._Options subwidget _LocalVariables]
iwidgets::Scrolledtext $f._LocalVariables -labeltext "Local Variables:" \
    -variable "c2_tmp(LocalVars)" \
    -visibleitems 40x4 -textfont $c2_MonoFont
pack append $f \
	$f._LocalVariables {top frame center expand fill}

set f [$attrframe._Options subwidget _InitComputation]
iwidgets::Scrolledtext $f._InitComputation -labeltext "Initial Computation:" \
    -variable "c2_tmp(InitComp)" \
    -visibleitems 40x4 -textfont $c2_MonoFont
pack append $f \
	$f._InitComputation {top frame center expand fill}


if 0 {

# Debugger Window "dialog"

Code::Dialog ._DebuggerWindow -title "Code: Debugger"
set attrframe ._DebuggerWindow

# build widget $attrframe.frame
frame $attrframe.frame \
	-relief {ridge} \
	-borderwidth 2

# build widget $attrframe.frame.horizscrollbar
scrollbar $attrframe.frame.horizscrollbar \
	-command "$attrframe.frame.canvas xview" \
	-orient {horizontal} \
	-relief {raised}

# build widget $attrframe.frame.vertscrollbar
scrollbar $attrframe.frame.vertscrollbar \
	-command "$attrframe.frame.canvas yview" \
	-relief {raised}

# build widget $attrframe.frame.canvas
global ::c2_DebuggerCanvas
set c2_DebuggerCanvas \
	[Code::DebuggerCodeCanvas $attrframe.frame.canvas \
	-closeenough {0.2} \
	-height {200} \
	-insertofftime {600} \
	-relief {sunken} \
	-scrollregion {0 0 1000 1000} \
	-width {360} \
	-xscrollcommand "$attrframe.frame.horizscrollbar set" \
	-yscrollcommand "$attrframe.frame.vertscrollbar set"]


# pack widget $attrframe.frame
pack append $attrframe.frame \
	$attrframe.frame.vertscrollbar {right frame center filly} \
	$attrframe.frame.canvas {top frame center expand fill} \
	$attrframe.frame.horizscrollbar {bottom frame center fillx}

pack $attrframe.frame -expand yes -fill both


._DebuggerWindow default Apply
._DebuggerWindow buttonconfigure OK -text "Close"
._DebuggerWindow buttonconfigure Apply -text "Run"
._DebuggerWindow buttonconfigure Cancel -text "Step"
._DebuggerWindow buttonconfigure Help -text "Options"

}

# hierarchy selector

Code::CodeHierarchy .hierarchy $c2_MainCanvas

# the focus will have shifted to the debugger canvas;
# set it back to where it should be (the main canvas).

Code::CodeCanvas::SetCurrentWindow $c2_MainCanvas
$c2_MainCanvas Canvas_Enter
