class Code::Dialog {

    inherit wigwam::itcl_toplevel

    itk_option define -title title Title "Code Dialog"

    constructor {args} { eval wigwam::itcl_toplevel::constructor $args } {}
    destructor {}

    public method activate {}
    public method cancelcmd {}
    public method okcmd {}
    public method popup {}
    public method popdown {}
    public method subwidget {widget}

    protected method center {}
    private variable oldthis

}


configbody Code::Dialog::title {
    wm title [info namespace tail $this] $itk_option(-title)
}


body Code::Dialog::constructor {args} {
    set oldthis [info namespace tail $this]
    tixButtonBox $oldthis.buttonbox
    pack $oldthis.buttonbox -side bottom -anchor s -fill both
    popdown
    eval itk_initialize $args
}


body Code::Dialog::activate {} {
    global ::dialog_status
    popup
    set dialog_status($this) 0
    tkwait variable dialog_status
    return $dialog_status($this)
}


body Code::Dialog::cancelcmd {} {
    global ::dialog_status

    popdown
    set dialog_status($this) 0
}

body Code::Dialog::center {} {
    wm sizefrom $oldthis user
    wm positionfrom $oldthis user

    set parent "."

    if {$parent != ""} {
	set pargeo [split [wm geometry $parent] "+x"]
	set parentW [lindex $pargeo 0]
	set parentH [lindex $pargeo 1]
	set parx [lindex $pargeo 2]
	set pary [lindex $pargeo 3]

	wm transient $oldthis $parent
    } else {
	set parentW [winfo screenwidth $oldthis]
	set parentH [winfo screenheight $oldthis]
	set parx 0
	set pary 0
	set parent [winfo parent $oldthis]
    }

    # What are is the offset of the virtual window
    set vrootx [winfo vrootx $parent]
    set vrooty [winfo vrooty $parent]

    # What are my dimensions ?
    set dialogW [winfo reqwidth $oldthis]
    set dialogH [winfo reqheight $oldthis]

    if {$dialogW < [expr $parentW-30] || $dialogW < [expr $parentH-30]} {
	set dialogx [expr $parx+($parentW-$dialogW)/2+$vrootx]
	set dialogy [expr $pary+($parentH-$dialogH)/2+$vrooty]
    } else {
	# This dialog is too big. Place it at (parentx, parenty) + (20,20)
	#
	set dialogx [expr $parx+20+$vrootx]
	set dialogy [expr $pary+20+$vrooty]
    }

    set maxx [expr "[winfo screenwidth  $parent] - $dialogW"]
    set maxy [expr "[winfo screenheight $parent] - $dialogH"]

    # Make sure it doesn't go off screen
    #
    if {$dialogx < 0} {
	set dialogx 0
    } else {
	if {$dialogx > $maxx} {
	    set dialogx $maxx
	}
    }
    if {$dialogy < 0} {
	set dialogy 0
    } else {
	if {$dialogy > $maxy} {
	    set dialogy $maxy
	}
    }

    # set my new position (and dimensions)
    #
    if {[wm geometry $oldthis] == "1x1+0+0"} {
	wm geometry $oldthis $dialogW\x$dialogH\+$dialogx\+$dialogy
    }
}


body Code::Dialog::okcmd {} {
    global ::dialog_status

    popdown
    set dialog_status($this) 1
}


body Code::Dialog::popup {} {
    update idletasks
    center
    wm deiconify $oldthis
}


body Code::Dialog::popdown {} {
    wm withdraw $oldthis
}


body Code::Dialog::subwidget {widget} {
    switch $widget {
	frame {
	    return [info namespace tail $this]
	}
	buttonbox {
	    return [info namespace tail $this.buttonbox]
	}
    }
}
