#
# mainscreen.tcl
# ------------------------------------------------------------------------
# Contains exactly one procedure, ShowWindow., which brings up the main
# CODE screen.
# ------------------------------------------------------------------------
# @(#) $Id: mainscreen.tcl,v 1.9 1996/03/15 18:01:29 emery Exp $
#
# ------------------------------------------------------------------------
# AUTHOR:
#
# Emery Berger                    | <http://www.cs.utexas.edu/users/emery>
# Systems Analyst                 @           <mailto:emery@cs.utexas.edu>
# Parallel Programming Group      |  <http://www.cs.utexas.edu/users/code>
# Department of Computer Sciences |             <http://www.cs.utexas.edu>
# University of Texas at Austin   |                <http://www.utexas.edu>
# ========================================================================


# procedure to show window .
proc ShowWindow. {args} {

    global \
	    c2_ReleaseDirectory \
	    c2_tmp \
	    c2_MenuFont \
	    tkVersion \
	    c2_SummaryStatistics \
	    c2_OptimizeProgram \
	    c2_DebuggerOn \
	    c2_BufferTraceEvents \
	    c2_TranslationTarget \
	    c2_ReshapeArcs
    
    tk appname CODE


    # Window manager configurations
    wm positionfrom . program
    wm sizefrom . program
    wm title . {CODE}
    wm protocol . WM_DELETE_WINDOW {c2_QuitProgram}


    # Put up a splash screen.
    
    set splash [image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/code-screen-logo.gif"]

    label .splash -image $splash -borderwidth 0
    pack .splash -expand yes -fill both -anchor c

    # Put the watch cursor up while the screen loads.
    
    tixBusy .splash on

    update idletasks
    

    # Create the icon for CODE (for when it's iconifed).

    set icon ".__Icon"
    toplevel $icon
    # Put a fancy border around it.
    frame $icon.f   -bd 2 -relief raised
    frame $icon.f.f -bd 2 -relief groove
    label $icon.f.f.l \
	-image [image create photo -palette 256x256x256 -format GIF -file "$c2_ReleaseDirectory/bitmaps/code-icon.gif"] \
	-anchor center
    
    pack $icon.f     -side top -fill both -expand y
    pack $icon.f.f   -side top -fill both -expand y
    pack $icon.f.f.l -side top -fill both -expand y

    wm iconwindow . $icon
    wm iconname   . CODE
    update idletasks

    # wm iconbitmap . "@$c2_ReleaseDirectory/bitmaps/code-icon.xbm"


    #####################
    #                   #
    # build main window #
    #                   #
    
    
    # build widget .frame0
    frame .frame0 \
	    -borderwidth {2} \
	    -relief {raised}

    # build widget .framesix
    frame .framesix \
	    -borderwidth {2} \
	    -relief {raised}
    
    # build widget .framesix.framezero
    frame .framesix.framezero \
	    -relief {raised}
    
    # build widget .framesix.framezero.scrollbar3
    scrollbar .framesix.framezero.scrollbar3 \
	    -command {.framesix.framezero.canvastwo xview} \
	    -orient {horizontal} \
	    -relief {raised}

    # build widget .framesix.framezero.scrollbar1
    scrollbar .framesix.framezero.scrollbar1 \
	    -command {.framesix.framezero.canvastwo yview} \
	    -relief {raised}

    # build widget .framesix.framezero.canvastwo
    set c2_MainCanvas \
	    [Code::CodeCanvas .framesix.framezero.canvastwo \
	    -closeenough {0.2} \
	    -insertofftime {600} \
	    -scrollregion {0 0 1000 1000} \
	    -xscrollcommand {.framesix.framezero.scrollbar3 set} \
	    -yscrollcommand {.framesix.framezero.scrollbar1 set}]

    #   -relief {sunken} -height {200} -width {360}

    build_menubar .frame0 $c2_MainCanvas

    # pack widget .framesix.framezero
    pack append .framesix.framezero \
	    .framesix.framezero.scrollbar1 {right frame center filly} \
	    .framesix.framezero.canvastwo {top frame center expand fill} \
	    .framesix.framezero.scrollbar3 {bottom frame center fillx}

    global c2_MenuFont
    label .framesix.statusbar -text "" -height 1 -relief sunken -borderwidth 2 -font $c2_MenuFont

    # pack widget .framesix
    pack append .framesix \
	    .framesix.framezero {top frame center expand fill} \
	    .framesix.statusbar {bottom frame s fillx}

    # build widget .frame1
    frame .frame1 \
	    -borderwidth {2} \
	    -relief {raised}

    build_iconbar .frame1 .framesix.statusbar

    # wait for the splash screen to come up

    update idletasks

    global c2_ReleaseDirectory
    source $c2_ReleaseDirectory/createDialogs.tcl

    destroy .splash

    wm geometry . 730x522
    wm title . {CODE - Untitled}

    # clean up and draw the main window

    pack append . \
	.frame0 {top frame nw fillx} \
	.framesix {right frame ne expand fill} \
	.frame1 {left frame nw fill}

    tixBusy . off
}
