proc build_menubar {w canvas} {

    global c2_MenuFont c2_MainCanvas

    # build widget $w.menubutton2
    menubutton $w.menubutton2 \
	    -menu "$w.menubutton2.m" \
	    -font "$c2_MenuFont" \
	    -text {File}
    
    # build widget $w.menubutton2.m
    menu $w.menubutton2.m \
	    -font "$c2_MenuFont" \
	    -tearoff 0
    
    $w.menubutton2.m add command -label {New} \
	    -accelerator {Alt+N} \
	    -command {c2_NewFile}
    $w.menubutton2.m add command -label {Open...} \
	    -accelerator {Alt+O} \
	    -command "$c2_MainCanvas open"
    $w.menubutton2.m add command -label {Insert...} \
	    -command "$canvas insert_file_dlog"

    $w.menubutton2.m add command -label {Close} \
	    -command "$canvas collapse"

    # Disable "Close" command if we are the main canvas.

    if {![string compare $canvas $c2_MainCanvas]} {
	$w.menubutton2.m entryconfigure 3 -state disabled
    }

    $w.menubutton2.m add separator

    $w.menubutton2.m add command -label {Save} \
	    -accelerator {Alt+S} \
	    -command "$c2_MainCanvas save_file"
    $w.menubutton2.m add command -label {Save As...} \
	    -command "$c2_MainCanvas save_as"
    $w.menubutton2.m add separator

    $w.menubutton2.m add command -label {Program Annotations...} \
	    -command {c2_GlobalAnnotations}

    if 0 {
	$w.menubutton2.m add command -label {Execution Preferences} \
	    -command {c2_ExecutionSetup}
    }

    $w.menubutton2.m add cascade -label {Target Architecture} \
	-menu "$w.menubutton2.m.m"

    menu $w.menubutton2.m.m -font "$c2_MenuFont" -tearoff 0

    global c2_TranslationTarget

    $w.menubutton2.m.m add radiobutton -label {Cray} -value {Cray} -variable c2_TranslationTarget
    $w.menubutton2.m.m add radiobutton -label {PVM} -value {PVM} -variable c2_TranslationTarget
    $w.menubutton2.m.m add radiobutton -label {Sequent} -value {Sequent} -variable c2_TranslationTarget
    $w.menubutton2.m.m add radiobutton -label {Sparc MP} -value {Sparc} -variable c2_TranslationTarget
    $w.menubutton2.m.m add radiobutton -label {Serial} -value {Serial} -variable c2_TranslationTarget


    $w.menubutton2.m add command -label {Compile} \
	    -command {c2_RunProgram}
    $w.menubutton2.m add separator

    $w.menubutton2.m add command -label {Printer Setup...} \
	    -command {c2_PrintSetup}
    $w.menubutton2.m add command -label {Print Graphs...} \
	    -command {c2_PrintCanvases}
    $w.menubutton2.m add command -label {Print Annotations...} \
	    -command {c2_PrintAnnotations}
    $w.menubutton2.m add separator

    $w.menubutton2.m add command -label {Quit} \
	    -accelerator {Alt+Q} \
	    -command {c2_QuitProgram}

    
    proc filemenu_post {w canvas} {
	global c2_MainCanvas

	#
	#  these should only be enabled when we
	#  have something in the main canvas:
	#    save, save as..., translate, run, print canvases
	#
	
	set enabled [string compare [winfo children $c2_MainCanvas] ""]
	
	foreach i {5 6 10 13 14} {
	    $w.menubutton2.m entryconfigure $i \
		    -state [lindex {{disabled} {normal}} $enabled]
	}
	
    }

    $w.menubutton2.m configure -postcommand "filemenu_post $w $canvas"


    # build widget $w.menubutton3
    menubutton $w.menubutton3 \
	    -font "$c2_MenuFont" \
	    -menu "$w.menubutton3.m" \
	    -text {Edit}
    
    # build widget $w.menubutton3.m
    menu $w.menubutton3.m \
	    -font "$c2_MenuFont" \
	    -tearoff 0
    
    # enable or disable menu items

    proc editmenu_post {w canvas} {

        set currentwin $canvas

        #
        #  cut, copy, clear, and duplicate
        #  should be enabled only when we have
        #  selected something
        #

        set enabled [string compare \
                [$currentwin selected_items] ""]

        foreach i {2 3 5 8} {
            $w.menubutton3.m entryconfigure $i \
                    -state [lindex {{disabled} {normal}} $enabled]
        }


        #
        #  select-all should only be enabled when we
        #  have something in the current canvas
        #

        set enabled [string compare [winfo children $currentwin] ""]

        $w.menubutton3.m entryconfigure 7 \
                -state [lindex {{disabled} {normal}} $enabled]


        #
        #  undo is enabled only when the last action is undoable
        #

        $w.menubutton3.m entryconfigure 0 \
                -state [lindex {{disabled} {normal}} [$currentwin undoable]]

        #
        #  paste is enabled only when there is something in the
        #  cut buffer
        #

        $w.menubutton3.m entryconfigure 4 \
                -state [lindex {{disabled} {normal}} [$currentwin can_paste]]
    }

    $w.menubutton3.m configure -postcommand "editmenu_post $w $canvas"
    
    $w.menubutton3.m add command \
	    -accelerator {Alt+Z} \
	    -command "$canvas undo" \
	    -label {Undo}
    $w.menubutton3.m add separator
    $w.menubutton3.m add command \
	    -accelerator {Alt+X} \
	    -command "$canvas cut" \
	    -label {Cut}
    $w.menubutton3.m add command \
	    -accelerator {Alt+C} \
	    -command "$canvas copy" \
	    -label {Copy}
    $w.menubutton3.m add command \
	    -accelerator {Alt+V} \
	    -command "$canvas paste" \
	    -label {Paste}
    $w.menubutton3.m add command \
	    -accelerator {Del} \
	    -command "$canvas delete_selected" \
	    -label {Clear}
    $w.menubutton3.m add separator
    $w.menubutton3.m add command \
	    -accelerator {Alt+A} \
	    -command "$canvas select_all" \
	    -label {Select All} \
	    -state {normal}
    $w.menubutton3.m add command \
	    -accelerator {Alt+D} \
	    -command "$canvas duplicate" \
	    -label {Duplicate}

    
    
    # build widget $w.menubutton4
    menubutton $w.menubutton4 \
	    -font "$c2_MenuFont" \
	    -menu "$w.menubutton4.m" \
	    -text {Arrange}
    
    # build widget $w.menubutton4.m
    menu $w.menubutton4.m \
	    -font "$c2_MenuFont" \
	    -tearoff 0
    
    # enable or disable menu items based on whether we have selected anything

    proc arrangemenu_post {w canvas} {
        set enabled [string compare [$canvas selected_items] ""]
        foreach i {0 1 2 3 5 6} {
            $w.menubutton4.m entryconfigure $i \
		-state [lindex {{disabled} {normal}} $enabled]
        }
    }
    
    $w.menubutton4.m configure -postcommand "arrangemenu_post $w $canvas"
    
    $w.menubutton4.m add command \
	    -accelerator {Alt+G} \
	    -command "$canvas group_selected" \
	    -label {Group} \
	    -state {disabled}
    $w.menubutton4.m add command \
	    -command "$canvas ungroup_selected" \
	    -label {Ungroup} \
	    -state {disabled}
    $w.menubutton4.m add command \
	    -command "$canvas lock" \
	    -label {Lock} \
	    -state {disabled}

    $w.menubutton4.m add command \
	    -command "$canvas unlock" \
	    -label {Unlock} \
	    -state {disabled}
    $w.menubutton4.m add separator
    $w.menubutton4.m add cascade \
	    -label {Vertical Alignment} \
	    -menu "$w.menubutton4.m.m" \
	    -state {disabled}
    $w.menubutton4.m add cascade \
	    -label {Horizontal Alignment} \
	    -menu "$w.menubutton4.m.m2" \
	    -state {disabled}

    # build widget $w.menubutton4.m.m
    menu $w.menubutton4.m.m \
	    -font "$c2_MenuFont" \
	    -tearoff 0
    $w.menubutton4.m.m add command \
	    -command "$canvas align top" \
	    -label {Top}
    $w.menubutton4.m.m add command \
	    -command "$canvas align vcenter" \
	    -label {Center}
    $w.menubutton4.m.m add command \
	    -command "$canvas align bottom" \
	    -label {Bottom}
    
    # build widget $w.menubutton4.m.m2
    menu $w.menubutton4.m.m2 \
	    -font "$c2_MenuFont" \
	    -tearoff 0
    $w.menubutton4.m.m2 add command \
	    -command "$canvas align left" \
	    -label {Left}
    $w.menubutton4.m.m2 add command \
	    -command "$canvas align hcenter" \
	    -label {Center}
    $w.menubutton4.m.m2 add command \
	    -command "$canvas align right" \
	    -label {Right}
    



    # build widget $w.menubutton5
    menubutton $w.menubutton5 \
	    -font "$c2_MenuFont" \
	    -menu $w.menubutton5.m \
	    -text {Windows}
    
    
    proc windowsmenu_post {w canvas} {

	global c2_MainCanvas

	# put up a list of all call node subgraph windows
	# (with the main canvas on the top)

	$w.menubutton5.m delete 0 last

	$w.menubutton5.m add command \
	    -command "$c2_MainCanvas expand" \
	    -label {Main Program}

	foreach dlog [winfo children .] {
	    if {[string match "*_CallNode*" $dlog]} {
		if {[winfo ismapped $dlog]} {
		    $w.menubutton5.m add command \
			-command "raise $dlog" \
			-label "[wm title $dlog]"
		}
	    }
	}
    }


    # build widget $w.menubutton5.m
    menu $w.menubutton5.m \
	    -font "$c2_MenuFont" \
	    -tearoff 0 \
	    -postcommand "windowsmenu_post $w $canvas"
    
    $w.menubutton5.m add command \
	    -command {} \
	    -label {no windows} \
	    -state {disabled}
    

    # build widget $w.menubutton6
    menubutton $w.menubutton6 \
	    -font "$c2_MenuFont" \
	    -menu "$w.menubutton6.m" \
	    -text {Special}
    
    # build widget $w.menubutton6.m
    menu $w.menubutton6.m \
	    -font "$c2_MenuFont" \
	    -tearoff 0

    $w.menubutton6.m add checkbutton \
	    -variable c2_ReshapeArcs \
	    -label {Show Arc Points}

    $w.menubutton6.m add separator
    
    $w.menubutton6.m add command \
	    -command {c2_GotoCallNode} \
	    -label "Hierarchy Browser..."

    if 0 {
	$w.menubutton6.m add command \
	    -command {c2_Debugger} \
	    -label "Debugger..."
    }


    # build widget $w.menubutton8
    menubutton $w.menubutton8 \
	    -font "$c2_MenuFont" \
	    -menu "$w.menubutton8.m" \
	    -text {Help}
    
    # build widget $w.menubutton8.m
    menu $w.menubutton8.m \
	    -font "$c2_MenuFont" \
	    -tearoff 0

    $w.menubutton8.m add command \
	    -command {.aboutdialog popup} \
	    -label {About Code...}

    if {0} {

	$w.menubutton8.m add command \
		-command "exec ghostview $c2_ReleaseDirectory/docs/userman/1-Intro.ps  &" \
		-label {Code Users Manual}

	$w.menubutton8.m add command \
		-command "exec ghostview $c2_ReleaseDirectory/docs/refman/2-RefMan.ps &" \
		-label {Code Reference Manual}
    }

    # pack widget $w
    pack append $w \
	    $w.menubutton2 {left frame center padx 5 fillx} \
	    $w.menubutton3 {left frame center padx 5} \
	    $w.menubutton4 {left frame center padx 5} \
	    $w.menubutton6 {left frame center padx 5} \
	    $w.menubutton8 {right frame center padx 5} \
	    $w.menubutton5 {right frame center padx 5 fillx}

}

