#include "c2_seqvar.h"

void
_c2_Create(Q) 
_c2_SeqVarQ Q;
{
    int i;
    for (i=0; i<8; i++)
        Q[i] = ((_c2_SeqVar *)0);
}

void 
_c2_Destory(Q) 
    _c2_SeqVarQ Q; 
{ 
    _c2_SeqVar *ThisSeqVar, *FreeSeqVar;
    int i;

    for (i=0; i<8; i++) {
        ThisSeqVar = Q[i];
        while (ThisSeqVar != ((_c2_SeqVar *)0)) {
            FreeSeqVar = ThisSeqVar;
            ThisSeqVar = ThisSeqVar->next;
            free(FreeSeqVar); 
 	}
        Q[i] = ((_c2_SeqVar *)0);
    }
};

void 
_c2_Insert(Q,  I, V) 
    _c2_SeqVarQ Q; 
    _c2_Index *I;
    _c2_Value *V; 
{
    _c2_SeqVar *ThisSeqVar, *LastSeqVar; 

    ThisSeqVar = (_c2_SeqVar *)_c2_shmalloc(sizeof(_c2_SeqVar));
    ThisSeqVar->value = *V;
    ThisSeqVar->index = *I;
    ThisSeqVar->next = ((_c2_SeqVar *)0);

    LastSeqVar = Q[I->NumInd];
    if (LastSeqVar != ((_c2_SeqVar *)0)) {
        while (LastSeqVar->next != ((_c2_SeqVar *)0))
             LastSeqVar = LastSeqVar->next;
        LastSeqVar->next = ThisSeqVar;
    } else {
        Q[I->NumInd] = ThisSeqVar;
    }
};

/*
 * There are two versions of _c2_Check() and _c2_Remove() below.
 * The version that is used by the debugger instrumention uses
 * an additional argument; address of the node whose input queues
 * are being checked/removed. This address and the list appended to the value
 *  in the current seqvar being checked, is passed to the debugger 
 * builtin action. The Builtin action checks
 * the predecessor identifier in the appended list with the 
 * predecessor id inside the _c2_NodeBase struct 
 * (that was recorded in an earlier execution). 
 * The action's return value indicates whether the checking
 * should proceed with  the indices of ThisSeqVar or the next
 * seqvar should be selected. See additional comments inside dbguc.c.
 */

#ifdef _C2_DBGR_
int _c2_Check(nodeaddr, Q, I) 
    _c2_NodeBase * nodeaddr;
#else
int _c2_Check(Q, I)
#endif
     _c2_SeqVarQ Q; 
     _c2_Index *I;
{
    _c2_SeqVar *ThisSeqVar;
    int i;

    ThisSeqVar = Q[I->NumInd];
    if (I->NumInd > 0) {
       while (ThisSeqVar != ((_c2_SeqVar *)0)) {
#         ifdef _C2_DBGR_
	  if (_c2_chkFpBpAct(nodeaddr, ThisSeqVar->value.fplist))
#         endif
	      {

		 for (i=0; i<I->NumInd; i++) {
		    if (ThisSeqVar->index.Ind[i] == I->Ind[i]) {
		       if (i == I->NumInd - 1) return 1;
		    } else
			break;
		 }
	      }
	  ThisSeqVar = ThisSeqVar->next;
       }
       return 0;
    } else {
       while (ThisSeqVar != ((_c2_SeqVar *)0)) { 
#          ifdef _C2_DBGR_	/* not reached when undefined */
	   if (_c2_chkFpBpAct(nodeaddr, ThisSeqVar->value.fplist)) 
#          endif 
	       {
		  return 1;
	       }
#          ifdef _C2_DBGR_
	   ThisSeqVar = ThisSeqVar->next; /* Here only in dbg replay mode */
#          endif
	} 
       return 0;
    }
};

#ifdef _C2_DBGR_
int 
_c2_Remove(nodeaddr, Q, I, V) 
    _c2_NodeBase * nodeaddr;
#else
int _c2_Remove(Q, I, V)
#endif
    _c2_SeqVarQ Q; 
    _c2_Index *I;
    _c2_Value *V;
{
   _c2_SeqVar *ThisSeqVar, *PrevSeqVar;
   int i;

   PrevSeqVar = ((_c2_SeqVar *)0);

   ThisSeqVar = Q[I->NumInd];
   if (I->NumInd > 0) {
      while (ThisSeqVar != ((_c2_SeqVar *)0)) {
#        ifdef _C2_DBGR_
	 if (_c2_chkFpBpAct(nodeaddr, ThisSeqVar->value.fplist)) 
#        endif
	     {
		for (i=0; i<I->NumInd; i++) {
		   if (ThisSeqVar->index.Ind[i] == I->Ind[i]) {
		      if (i == I->NumInd - 1) {
			 *V = ThisSeqVar->value; 
			 if (PrevSeqVar != ((_c2_SeqVar *)0))
			     PrevSeqVar->next = ThisSeqVar->next;
			 else 
			     Q[I->NumInd] = Q[I->NumInd]->next;
			 free(ThisSeqVar);
			 return 1;
		      }
		   } else
		       break;
		}
	     }
	 PrevSeqVar = ThisSeqVar;
	 ThisSeqVar = ThisSeqVar->next;
      }
      return 0;
   } else {
      while (ThisSeqVar != ((_c2_SeqVar *)0)) {
#        ifdef _C2_DBGR_
	 if (_c2_chkFpBpAct(nodeaddr, ThisSeqVar->value.fplist))
#        endif
	     {
		*V = ThisSeqVar->value; 
		if (PrevSeqVar != ((_c2_SeqVar *) 0) )
		    PrevSeqVar->next = ThisSeqVar->next;
		else 
		    Q[I->NumInd] = Q[I->NumInd]->next;
		free(ThisSeqVar);
		return 1;
	     }
#        ifdef _C2_DBGR_
	 PrevSeqVar = ThisSeqVar;
	 ThisSeqVar = ThisSeqVar->next; /* Here only in debugger replay mode */
#        endif
      }
      return 0;
   }
}




/* routines without the debugger code. Only here to make the above more 
   understandable.
int 
_c2_Check(Q, I) 
    _c2_SeqVarQ Q; 
    _c2_Index *I;
{
    _c2_SeqVar *ThisSeqVar;
    int i;

    ThisSeqVar = Q[I->NumInd];
    if (I->NumInd > 0) {
        while (ThisSeqVar != ((_c2_SeqVar *)0)) {
            for (i=0; i<I->NumInd; i++) {
                if (ThisSeqVar->index.Ind[i] == I->Ind[i]) {
                    if (i == I->NumInd - 1) return 1;
                } else
                    break;
	    }
            ThisSeqVar = ThisSeqVar->next;
        }
        return 0;
    } else {
        if (ThisSeqVar != ((_c2_SeqVar *)0)) 
            return 1;
        else
            return 0;
    }
};


int 
_c2_Remove(Q, I, V) 
    _c2_SeqVarQ Q; 
    _c2_Index *I;
    _c2_Value *V;
{
    _c2_SeqVar *ThisSeqVar, *PrevSeqVar;
    int i;

    PrevSeqVar = ((_c2_SeqVar *)0);

    ThisSeqVar = Q[I->NumInd];
    if (I->NumInd > 0) {
        while (ThisSeqVar != ((_c2_SeqVar *)0)) {
            for (i=0; i<I->NumInd; i++) {
                if (ThisSeqVar->index.Ind[i] == I->Ind[i]) {
                    if (i == I->NumInd - 1) {
                        *V = ThisSeqVar->value; 
                        if (PrevSeqVar != ((_c2_SeqVar *)0))
                            PrevSeqVar->next = ThisSeqVar->next;
                        else 
                            Q[I->NumInd] = Q[I->NumInd]->next;
                        free(ThisSeqVar);
                        return 1;
		      }
                } else
                    break;
	    }
            PrevSeqVar = ThisSeqVar;
            ThisSeqVar = ThisSeqVar->next;
        }
        return 0;
    } else {
        if (ThisSeqVar != ((_c2_SeqVar *)0)) {
            *V = ThisSeqVar->value; 
            Q[I->NumInd] = Q[I->NumInd]->next;
            free(ThisSeqVar);
            return 1;
        } else
            return 0;
    }
}

*/

/* routines for SeqVarQ caches */

void _c2_CacheInit(c)
   struct _c2_Cache *c;
{
   c->Current = 0;
   c->Len = 0;
}


void _c2_EnCache(c, PortIndex, MappedPortIndex, QVar, NodeAddr)
   struct _c2_Cache *c;
   _c2_Index *PortIndex;
   _c2_Index *MappedPortIndex;
   _c2_SeqVar **QVar;
   _c2_NodeBase *NodeAddr;
{
   c->Cache[c->Current].PortIndex = *PortIndex;
   c->Cache[c->Current].MappedPortIndex = *MappedPortIndex;
   c->Cache[c->Current].QVar = QVar;
   c->Cache[c->Current].NodeAddr = NodeAddr;
   c->Current += 1;
   if (c->Current >= _c2_CACHESIZE) c->Current = 0;
   c->Len += 1;
   if (c->Len > _c2_CACHESIZE) c->Len = _c2_CACHESIZE;
   
}


int _c2_FindCache(c, PortIndex, MappedPortIndex, QVar, NodeAddr)
   struct _c2_Cache *c;
   _c2_Index *PortIndex;
   _c2_Index *MappedPortIndex;
   _c2_SeqVar ***QVar;
   _c2_NodeBase **NodeAddr;
{
   int i;
   int j;

   i = c->Current - 1;
   if (i < 0) i = _c2_CACHESIZE - 1;

   for (j = 0; j < c->Len; j++) {
      if (_c2_EqIndex(&(c->Cache[i].PortIndex), PortIndex)) {
	 *QVar = c->Cache[i].QVar;
	 *MappedPortIndex = c->Cache[i].MappedPortIndex;
	 *NodeAddr = c->Cache[i].NodeAddr;
	 return 1;
      }
      i -= 1;
      if (i < 0) i = _c2_CACHESIZE - 1;
   }
   
   return 0;
}


