/* 
 * tclAppInit.c --
 *
 *	Provides a default version of the main program and Tcl_AppInit
 *	procedure for Tcl applications (without Tk).
 *
 * Copyright (c) 1993 The Regents of the University of California.
 * Copyright (c) 1994-1995 Sun Microsystems, Inc.
 * Copyright (c) 1994-1995 ICEM CFD, Inc.
 *
 * See the file "license.terms" for information on usage and redistribution
 * of this file, and for a DISCLAIMER OF ALL WARRANTIES.
 */

static char sccsid[] = "@(#) tclAppInit.c 1.13 95/06/08 10:55:54";

#include "tcl.h"
#include <stdlib.h>


/*
 *----------------------------------------------------------------------
 *
 * main --
 *
 *	This is the main program for the application.
 *
 * Results:
 *	None: Tcl_Main never returns here, so this procedure never
 *	returns either.
 *
 * Side effects:
 *	Whatever the application does.
 *
 *----------------------------------------------------------------------
 */

static int  main_argc   = 0;
static char **main_argv = NULL;

int
main(argc, argv)
    int argc;			/* Number of command-line arguments. */
    char **argv;		/* Values of command-line arguments. */
{
    
    /* Defeat the argv mechanism to avoid using the first argument as
     * a file name.  When compile a top-level script, don't want the
     * first argument to be treated as a file name.
     */
    
    char *temp_argv[2];
    main_argc = argc-1;
    main_argv = argv+1;
    
    temp_argv[0] = argv[0];
    temp_argv[1] = NULL;
    
    Tcl_Main(1, temp_argv, Tcl_AppInit);
    return 0;			/* Needed only to prevent compiler warning. */
}

/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

static char exp_init_auto_path[] = 
	"lappend auto_path $exp_library $exp_exec_library";

int
Tcl_AppInit(interp)
    Tcl_Interp *interp;		/* Interpreter for application. */
{
    /* Reset the command line arguments/count now before the
     * initialization calls.  This is right after when Tcl_Main
     * would have done it anyway.
     */
    
    char *args, *root, buffer[100];
    int ret = TCL_OK;
    
    args = Tcl_Merge(main_argc, main_argv);
    Tcl_SetVar(interp, "argv", args, TCL_GLOBAL_ONLY);
    ckfree(args);
    
    sprintf(buffer, "%d", main_argc);
    Tcl_SetVar(interp, "argc", buffer, TCL_GLOBAL_ONLY);
    
    if (Tcl_Init(interp) == TCL_ERROR) {
	ret = TCL_ERROR;
	goto error_exit;
    }

    /* Put all of your executable dependent initializations here */
    
    /* Script will add call to initialization function along with
       return here. */

    root = getenv("TCL_ROOT");
    if (root) {
	char* buf = malloc(strlen(root) + 64);
	
	sprintf(buf, "%s/lib/tcl", root);
	Tcl_SetVar2(interp, "env", "TCL_LIBRARY", buf, TCL_GLOBAL_ONLY);
	Tcl_SetVar(interp, "tcl_library", buf, TCL_GLOBAL_ONLY);
    }


    if (utils_Init(interp) == TCL_ERROR) { 
	ret = TCL_ERROR;
	goto error_exit;
    }

  error_exit:


    return ret;
}
