# itcl_window
# ----------------------------------------------------------------------
# Enhanced itcl_toplevel window class 
#
#   PUBLIC ATTRIBUTES:
#
#     All toplevel's options and wm's commands
#
#   METHODS:
#
#     All wm's comands
#
# ----------------------------------------------------------------------
#   AUTHOR:         Jim Wight <j.k.wight@newcastle.ac.uk>
#            Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
# ----------------------------------------------------------------------
# Copyright 1995 The University of Newcastle upon Tyne (see COPYRIGHT)
# ======================================================================

catch {wm foo .} msg
if {[regsub {unknown or ambiguous option.*must be (.*)} $msg {\1} methods] == 0} {
    puts stdout {Window: Format of "unknown option" error message has changed}
    puts stdout {Expected: unknown or ambiguous option "dummy":  must be etc.}
    puts stdout "     Got: $msg"
    puts stdout "\nPlease report this to your system administrator."
    exit
}      
    
regsub {(.*) or (.*)} $methods {\1 \2} methods
regsub -all "," $methods "" methods
set wmoptions {}
set wmmethods {}
foreach method $methods {
    switch $method {
    aspect    -
    client    -
    geometry {
        append wmoptions [list itk_option define -$method $method Wm "" "wm $method \$itk_interior \$itk_option(-$method)"] {;}
        }
    }

    append wmmethods [list method $method {args} "eval wm $method \$itk_interior \$args"] {;}
}

eval \
"class wigwam::itcl_window {
    inherit wigwam::itcl_toplevel

    $wmoptions
    $wmmethods
}"
