# ----------------------------------------------------------------------
# Implements [incr Tk] wrappers for Tk widgets and images.
#
#   PUBLIC ATTRIBUTES: 
#
#     None
#
#   METHODS: 
#
#     None
#
# ----------------------------------------------------------------------
#   AUTHOR:         Jim Wight <j.k.wight@newcastle.ac.uk>
#            Lindsay Marshall <lindsay.marshall@newcastle.ac.uk>
# ----------------------------------------------------------------------
# Copyright 1995 The University of Newcastle upon Tyne (see COPYRIGHT)
# ======================================================================

proc InitializeWrapper {type} {
    $type ._foo_
    set opts [._foo_ configure]
    catch {._foo_ _bar_} commands
    if {[regsub {bad option.* be (.*)} $commands {\1} commands] == 0} {
	puts {InitializeWrapper: Format of "bad option" error message has changed}
	puts {Expected: bad option "dummy":  must/should be ...}
	puts "     Got: $msg"
	puts "\nPlease report this to your system administrator."
	exit
    }      
    destroy ._foo_

    #
    # Create options corresponding to Tk widget options
    #
    set configs {}
    set options {}
    foreach option $opts {
	if {[string length [set opt [lindex $option 0]]] != 3} {
	    switch -- $opt {
		-class    -
		-colormap -
		-screen   -
		-visual   {continue}
		default {append options "$opt "}
	    }
	}
    }
    #
    # Create methods corresponding to Tk widget commands
    #
    regsub {bad option.* be (.*)} $commands {\1} commands
    regsub {(.*) or (.*)} $commands {\1 \2} commands
    regsub -all "," $commands "" commands
    set methods {}
    foreach method $commands {
        if {$method == "cget" || $method == "configure"} {
	    continue
        }
        append methods [list method $method {args} "eval \$itk_interior component hull $method \$args"] {;}
    }

    return [list $options $methods]
}

proc ItclClassFromWidget {type} {
    if {[info classes itcl_$type] != ""} {
	return
    }

    set wrapper [InitializeWrapper $type]

    eval \
    "class wigwam::itcl_$type {
        inherit itk::Archetype

        constructor {args} {
           set itk_hull \[info namespace tail \$this\]
# N.B Ought to set itk_interior
	   set rargs {}
	   set configs {}
	   set config {}
           if {\"$type\" == \"frame\" || \"$type\" == \"toplevel\"} {
   		set rargs {}
        	set config {}
        	foreach arg \$args {
        	    if {\$config != \"\"} {
        	        append configs \" \$arg \"
                        set \[string range \$config 1 end\] \$arg
        		set config {}
        		continue
        	    }
        	    switch -- \$arg {
        		-class    -
        		-colormap -
        		-screen   -
        		-visual   {append configs \$arg; set config \$arg}
        		-*        {append rargs \$arg}
        		default   {append rargs \" \$arg \"}
        	    }
               }
	       
	   }
           itk_component add hull {
               eval $type \$itk_hull \$configs
           } {
               keep [lindex $wrapper 0]
           }

	   # :: because context is wigwam::itcl_$type and canvas has bind,
	   #    and canvas and others have delete
           ::bind itk-delete-\$itk_hull <Destroy> \"::delete object \$this\"
           set tags \[bindtags \$itk_hull\]
           bindtags \$itk_hull \[linsert \$tags 0 itk-delete-\$itk_hull\]

	   for {set config 0} {\$config < \[llength \$configs\]} {incr config 2} {
	       configure \[lindex \$configs \$config\] \[lindex \$configs \[expr \$config + 1\]\]
	   }

	   set constructed 1
}
           # DISABLED by Emery Berger
           # eval itk_initialize \$rargs

        ::if {\"$type\" == \"frame\"} {
	    itk_option define -class class Class Frame {
		if {\$constructed} {
		   error \"can't modify -class option after widget is created\"
		}
	    }
	}	
        ::if {\"$type\" == \"toplevel\"} {
	    itk_option define -class class Class Toplevel
            itk_option define -colormap colormap Colormap {}
            itk_option define -screen screen Screen {}
            itk_option define -visual visual Visual {}
	}	

        destructor {
           if {\[winfo exists \$itk_hull\]} {
               set tags \[bindtags \$itk_hull\]
               set i \[lsearch \$tags itk-delete-\$itk_hull\]
               if {\$i >= 0} {
                   bindtags \$itk_hull \[lreplace \$tags \$i \$i\]
               }
               destroy \$itk_hull
           }
        }

        method config {args} {
	    eval configure \$args
        }

        [lindex $wrapper 1]

        private variable itk_hull {}
        private variable constructed 0
     }"
}

proc ItclClassFromImage {type} {
    image create $type _foo_
    set options [_foo_ configure]
    image delete _foo_
    set wrapper {}
    foreach option $options {
	set var [lindex $option 0]
	append wrapper [concat public variable [string range $var 1 end] \"[lindex $option 4]\" \{\$itk_hull configure $var \$[string range $var 1 end]\} "; "]
    }

    eval \
    "class wigwam::itcl_$type {
        constructor {args} {
	    set itk_hull \[info namespace tail \$this\]

	    image create $type \$itk_hull

            if {\$args != \"\"} {
                uplevel \$this configure \$args
            }
        }

        destructor {
           image delete \$itk_hull
        }

        $wrapper

        private variable itk_hull {}
    }"

    if {[lsearch [namespace wigwam {info comm}] image] == -1} {
        rename image wigwam::image
        proc image {command args} {
            switch $command {
                delete  {delete object $args}
                default {eval wigwam::image $command $args}
            }
        }
    }
}
