

(* ================== TempEst v1.2 ====================== *)

(* (C) 1995, 1996, Bell Laboratories and University of Texas *)

(* Carlos Puchol, cpg@cs.utexas.edu *)

(* Misc file and directory operations *)

(* Carlos Puchol, cpg@cs.utexas.edu, Feb 1996 *)

structure Directory =
struct

(********************************************

    Functions

 ********************************************)

(********************************************

	rmfile - remove a file silently, given its name.

 ********************************************)

    fun rmfile s =
	Posix.FileSys.unlink s
	handle SystemCall => ()

(********************************************

	revindex - return the index of the position (starting from l
	and going backwards) in s where ch is found. if it is not
	found the exception Subscript is raised (by sub()).

 ********************************************)

    fun revindex ch (s, l) =
	let
	    fun check pos = 
		if (String.sub(s, pos)) = ch then
		    pos
		else check (pos - 1)
	in
	    check l
	end


(********************************************

	Note that the following property holds

		((dirname s) ^ (basename s)) = s

	for any string s.

 ********************************************)

(********************************************

	basename - returns the last portion of an absolute file name.
	All from right to left of the name, until, *but not
	including*, the last '/', if any.

	basename "/usr/cddcd/cdcdc/cpg.cpg"	= "cpg.cpg"
	basename "/usr/cddcd/cdcdc/"		= ""
	basename "/usr/cddcd/cdcdc"		= "cdcdc"
	basename "/"				= ""
	basename ""				= ""
	basename "jhj"				= "jhj"	

 ********************************************)

    fun basename s =
	let
	    val l = size s
	    val i = revindex #"/" (s, l-1) handle _ => ~1
	in
	    substring(s, i+1, l-i-1) handle _ => s
	end

(********************************************

	dirname - returns the directory
	dirname "/usr/cddcd/cdcdc/cpg.cpg"	= "/usr/cddcd/cdcdc/"
	dirname "../../usr/cdcdc/cpg.cpg"	= "../../usr/cdcdc/"
	dirname "/usr/cddcd/cdcdc/"		= "/usr/cddcd/cdcdc/"
	dirname "/usr/cddcd/cdcdc"		= "/usr/cddcd/"
	dirname "/"				= "/"
	dirname ""				= ""
	dirname "jhj"				= ""	

 ********************************************)

    fun dirname s =
	let
	    val l = size s
	    val i = revindex #"/" (s, l-1) handle _ => ~1
	in
	    substring(s, 0, i+1) handle _ => s
	end

(********************************************

	remove_suffix - removes a given suffix, if it exists, from the
	end of a string

 ********************************************)

    fun remove_suffix (s, suffix) =
	let
	    val l1 = size s
	    val l2 = size suffix
	in
	    if l2 >= l1 then s
	    else
		(if (substring (s, l1 - l2, l2) = suffix) then
		     substring (s, 0, l1 - l2)
		 else s) handle _ => s
	end

end
