
(* ================== TempEst v1.2 ====================== *)

(* (C) 1995, 1996, Bell Laboratories and University of Texas *)

(* Carlos Puchol, cpg@cs.utexas.edu *)

signature INTERFACE =
sig
	type	pos
	val	line		: int ref
	val	init_line	: unit -> unit
	val	next_line	: int -> unit
	val	position	: int -> pos * pos
	val	argpos		: 'a -> int -> 'a * pos * pos
end

structure Interface : INTERFACE =
struct

	type	pos		= int * int
	val	line		= ref 1
	val	prevyypos	= ref 1
	fun	init_line ()	= (line :=1 ; prevyypos :=1)
	fun	next_line yypos	= ( line:= 1 + !line; prevyypos := yypos)
	fun	position yypos	= let
					val p = (!line, yypos - !prevyypos)
				  in
					(p, p)
				  end
	fun argpos x yypos	= let
					val p = (!line, yypos - !prevyypos)
				  in
					(x, p, p)
				  end
end

