

(* ================== TempEst v1.2 ====================== *)

(* (C) 1995, 1996, Bell Laboratories and University of Texas *)

(* Carlos Puchol, cpg@cs.utexas.edu *)

structure OC5parser : sig
			val parse : TextIO.instream -> OcCheck.state list
                 end = 
 struct
  structure OC5LrVals = OC5LrValsFun(structure Token = LrParser.Token
					structure Interface = Interface)
  structure OC5Lex = OC5LexFun(structure Tokens = OC5LrVals.Tokens
					structure Interface = Interface);

  structure OC5Parser = Join(structure LrParser = LrParser
		            structure ParserData = OC5LrVals.ParserData
		            structure Lex = OC5Lex)

    val makestring = Int.toString
    val output = TextIO.output
    val input = TextIO.inputN
    val std_err = TextIO.stdErr
    val open_in = TextIO.openIn
    val close_in = TextIO.closeIn

  val invoke = fn lexstream =>
    let val print_error2 = fn (s,l:int,c:int) =>
         output(std_err,"Line " ^ (makestring l) ^ ", column " ^
			(makestring c) ^ ": " ^ s ^ "\n")
    	val print_error = fn (s,(l1, c1):(int * int), (l2, c2): (int * int)) =>
         output(std_err,"Line " ^ (makestring l1) ^ "." ^ (makestring c1) ^ "-"
		^ (makestring l2) ^ "." ^ (makestring c2) ^ ": " ^ s ^ "\n")
    in OC5Parser.parse(0,lexstream,print_error, ())
    end

  val parse = fn (dev) => 
    let
	val lexer = OC5Parser.makeLexer (fn i => input(dev, i))
        val dummyEOF = OC5LrVals.Tokens.EOF((0,0),(0,0))
	val _ = Interface.init_line ();
        fun loop lexer =
	   let val (result,lexer) = invoke lexer
	       val (nextToken,lexer) = OC5Parser.Stream.get lexer
	   in if OC5Parser.sameToken(nextToken,dummyEOF) then result
	      else loop lexer
	   end
     in loop lexer before close_in dev
     end

end
