
(* Carlos Puchol, cpg@research.att.com, June 1994 *)

structure OcCheckMain:
    sig
	val main: string * string list -> OS.Process.status
	val dump_heap: string  -> unit
    end =
struct

(********************************************

    Variables

 ********************************************)

    val version = "@(#)occheck 0.1"

    val std_in = TextIO.stdIn
    val std_out = TextIO.stdOut
    val makestring = Int.toString
    val output = TextIO.output
    val input = TextIO.inputN
    val open_in = TextIO.openIn
    val open_out = TextIO.openOut
    val close_in = TextIO.closeIn
    val close_out = TextIO.closeOut
    val std_err = TextIO.stdErr
    val exportFn = SMLofNJ.exportFn

(********************************************

    Functions

 ********************************************)

    open Directory

    fun atoi x =
	case Int.fromString x of
	    SOME y	=> y
	  | _		=> 0


    and	main (something, argv) =	(* main: string list * string list -> unit *)
	let
	    exception OcCheck of string;

	    val signal =  (SOME (atoi(hd argv))) handle _ => NONE
	    fun do_check signal =
		let
		    (* val sname = remove_suffix (fullname, ".oc")
		    val iname = sname ^ ".oc" *)
		    val oname = "/dev/null"; (* (basename sname) ^ ".strl"; *)
		    val outputfile = std_out
		    val infile = std_in
		    val fsm = OC5parser.parse infile;
		    val fsm = ((tl fsm) @ [hd fsm]) handle _ => [];
		    val path = OcCheck.compute_path (signal, fsm);
		    val trace = OcCheck.trace_path(signal, path);
		in
		    ((OcCheck.print_trace(outputfile, trace)
		      before (close_out outputfile ;
			       close_in infile))
		     handle OcCheck.OcCheck s =>
			 (output(std_err, "occheck: " ^ s ^ "\n"); rmfile oname))
		    handle _ => rmfile oname
		end
	    val success = OS.Process.success
	    val failure = OS.Process.failure
	in
	    (case signal of
		 NONE	=> (output(std_err, "Usage: sml_check signal < file\n"); failure)
	       | SOME v	=> (do_check v; success)) handle OcCheck s =>
		 (output(std_err, "occheck: " ^ s ^ "\n"); failure)
	end

    fun dump_heap fname =
            (exportFn ( fname, main); ())


end
