
(* ================== TempEst v1.2 ====================== *)

(* (C) 1995, 1996, Bell Laboratories and University of Texas *)

(* Carlos Puchol, cpg@cs.utexas.edu *)

structure Tokens = Tokens
structure Interface = Interface

type pos = Interface.pos
type svalue = Tokens.svalue
type ('a,'b) token = ('a,'b) Tokens.token
type lexresult = (svalue, pos) token

val position = Interface.position
val argpos = Interface.argpos

val eof = fn () => Tokens.EOF(position 0)

fun atoi x =
    case Int.fromString x of
	SOME y		=> y
      | _		=> 0;

(* val atoi = StringCvt.atoi *)
	


%%

%header (functor OC5LexFun (structure Tokens : OC5_TOKENS structure Interface: INTERFACE));

digit=[0-9];
ws = [\ \t];

%%

\n			=> (lex());
{ws}+			=> (lex());
{digit}{digit}*		=> (Tokens.NUM(argpos (atoi yytext) yypos));
"haltset"		=> (Tokens.HALTSET(position yypos));
"emitted"		=> (Tokens.EMITTED(position yypos));
"%awaited"		=> (Tokens.AWAITED(position yypos));
":"			=> (Tokens.COLON(position yypos));
"("			=> (Tokens.LPAREN(position yypos));
")"			=> (Tokens.RPAREN(position yypos));
"<"			=> (Tokens.LT(position yypos));
">"			=> (Tokens.GT(position yypos));
"%"			=> (Tokens.PCT(position yypos));
.			=> (Tokens.NON_RECOGNIZED_TOKEN(position yypos));
