
(* ================== TempEst v1.2 ====================== *)

(* (C) 1995, 1996, Bell Laboratories and University of Texas *)

(* Carlos Puchol, cpg@cs.utexas.edu *)

structure Tlogic :
    sig
	val parse : string * TextIO.instream -> TlStruct.tl_assertion
    end = 
struct
    structure TlogicLrVals = TlogicLrValsFun(structure Token = LrParser.Token
					     structure Interface = Interface)
    structure TlogicLex = TlogicLexFun(structure Tokens = TlogicLrVals.Tokens
				       structure Interface = Interface);

    structure TlogicParser = Join(structure LrParser = LrParser
				  structure ParserData = TlogicLrVals.ParserData
				  structure Lex = TlogicLex)


    val makestring = Int.toString
    val output = TextIO.output
    val input = TextIO.inputN

    fun parse (name, dev) = 
	let
	    fun invoke lexstream =
		let val print_error2 = fn (s,l:int,c:int) =>
		    output(TextIO.stdErr,"Line " ^ (makestring l) ^ ", column " ^
			   (makestring c) ^ ": " ^ s ^ "\n")
		    val print_error = fn (s,(l1, c1):(int * int), (l2, c2): (int * int)) =>
			output(TextIO.stdErr, name ^ ": line " ^ (makestring l1) ^ "." ^ (makestring c1) ^ "-"
			       ^ (makestring l2) ^ "." ^ (makestring c2) ^ ": " ^ s ^ "\n")
		in
		    TlogicParser.parse(0,lexstream,print_error, ())
		end
	    val lexer = TlogicParser.makeLexer (fn i => input(dev, i))
	    val dummyEOF = TlogicLrVals.Tokens.EOF((0,0),(0,0))
	    val _ = Interface.init_line ();
	    fun loop lexer =
		let val (result,lexer) = invoke lexer
		    val (nextToken,lexer) = TlogicParser.Stream.get lexer
		in if TlogicParser.sameToken(nextToken,dummyEOF) then result
		   else loop lexer
		end
	in
	    loop lexer before TextIO.closeIn dev
	end
end
