
(* ================== TempEst v1.2 ====================== *)

(* (C) 1995, 1996, Bell Laboratories and University of Texas *)

(* Carlos Puchol, cpg@cs.utexas.edu *)

structure Tokens = Tokens
structure Interface = Interface

type pos = Interface.pos
type svalue = Tokens.svalue
type ('a,'b) token = ('a,'b) Tokens.token
type lexresult = (svalue, pos) token

val position = Interface.position
val argpos = Interface.argpos

val eof = fn () => Tokens.EOF(position 0)

fun atoi s =
    case Int.fromString s of
	SOME x	=> x
      | NONE	=> 0

fun tolower s = String.translate (fn x => String.str (Char.toLower x)) s

fun keyword (s, pos) =
    case  s of
	"Inputs"		=> Tokens.INPUTS(position pos)
      | "Signals"		=> Tokens.INPUTS(position pos)
      | "Relation"		=> Tokens.RELATION(position pos)
      | "Types"			=> Tokens.TYPES(position pos)
      | "Past"			=> Tokens.PAST(position pos)
      | "RespondsTo"		=> Tokens.RESPONDS(position pos)
      | "Yields"		=> Tokens.YIELDS(position pos)
      | "Holding"		=> Tokens.HOLDS(position pos)
      | "Always"		=> Tokens.ALWAYS(position pos)
      | "In"			=> Tokens.IN(position pos)
      | "Once"			=> Tokens.ONCE(position pos)
      | "AllPast"		=> Tokens.ALLPAST(position pos)
      | "Previous"		=> Tokens.PREVIOUS(position pos)
      | "Since"			=> Tokens.SINCE(position pos)
      | "BackTo"		=> Tokens.BACKTO(position pos)
      | "SubjectTo"		=> Tokens.SUBJECTTO(position pos)
      | "And"			=> Tokens.AND(position pos)
      | "Or"			=> Tokens.OR(position pos)
      | "Not"			=> Tokens.NOT(position pos)
      | "and"			=> Tokens.AND(position pos)
      | "or"			=> Tokens.OR(position pos)
      | "not"			=> Tokens.NOT(position pos)
      | "Implies"		=> Tokens.IMPLIES(position pos)
      | "implies"		=> Tokens.IMPLIES(position pos)
      | _			=> Tokens.ID(argpos s pos)

%%
%header (functor TlogicLexFun (	structure Tokens : Tlogic_TOKENS structure Interface: INTERFACE));

alpha=[A-Za-z_];
digit=[0-9];
ws = [\ \t];
comment = %.*\n;
%%

\n			=> (Interface.next_line yypos; lex());
{comment}		=> (Interface.next_line yypos; lex());
{ws}+			=> (lex());
"{"			=> (Tokens.LBRACE(position yypos));
"}"			=> (Tokens.RBRACE(position yypos));
"("			=> (Tokens.LPAREN(position yypos));
")"			=> (Tokens.RPAREN(position yypos));
";"			=> (Tokens.SEMICOLON(position yypos));
":"			=> (Tokens.COLON(position yypos));
","			=> (Tokens.COMMA(position yypos));
"!"			=> (Tokens.NOT(position yypos));
"#"			=> (Tokens.POUND(position yypos));
"=>"			=> (Tokens.THEN(position yypos));
"&"			=> (Tokens.AND(position yypos));
"|"			=> (Tokens.OR(position yypos));
"->"			=> (Tokens.IMPLIES(position yypos));
":="			=> (Tokens.EQ(position yypos));
{alpha}{alpha}*		=> (keyword (yytext, yypos));
{alpha}({alpha}|{digit})* => (Tokens.ID(argpos yytext yypos));
{digit}{digit}*		=> (Tokens.NUM(argpos (atoi yytext) yypos)); 
.			=> (Tokens.NON_RECOGNIZED_CHARACTER(position yypos));
