/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.cs.nn;

import edu.utexas.cs.nn.Point;
import java.io.Serializable;

public class Bounds
implements Serializable {
    private Point center;
    private double radius;

    public Bounds() {
        this.center = new Point();
        this.radius = 0.0;
    }

    public Bounds(Point center, double radius) {
        this.center = center;
        this.radius = radius;
    }

    public Bounds(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax) {
        this.center = new Point((xmax + xmin) / 2.0, (ymax + ymin) / 2.0, (zmax + zmin) / 2.0);
        double xrad = Math.abs((xmax - xmin) / 2.0);
        double yrad = Math.abs((ymax - ymin) / 2.0);
        double zrad = Math.abs((zmax - zmin) / 2.0);
        this.radius = Math.max(xrad, Math.max(yrad, zrad));
    }

    public Point getCenter() {
        return this.center;
    }

    public double getRadius() {
        return this.radius;
    }

    public boolean contains(Point p) {
        double dx = Math.abs(p.getX() - this.center.getX());
        double dy = Math.abs(p.getY() - this.center.getY());
        double dz = Math.abs(p.getZ() - this.center.getZ());
        return dx <= this.radius && dy <= this.radius && dz <= this.radius;
    }

    public double getMinX() {
        return this.center.getX() - this.radius;
    }

    public double getMinY() {
        return this.center.getY() - this.radius;
    }

    public double getMinZ() {
        return this.center.getZ() - this.radius;
    }

    public double getMaxX() {
        return this.center.getX() + this.radius;
    }

    public double getMaxY() {
        return this.center.getY() + this.radius;
    }

    public double getMaxZ() {
        return this.center.getZ() + this.radius;
    }

    public String toString() {
        return new String(this.center + "@" + this.radius);
    }
}

