/*
 * Decompiled with CFR 0.152.
 */
package edu.utexas.cs.nn;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;

public class ResourceFinder {
    private String name;
    private String path = null;

    public ResourceFinder(String name) {
        this.name = name;
    }

    public String getAbsolutePath() {
        if (this.path != null) {
            return this.path;
        }
        URL url = this.getClass().getResource(this.name);
        try {
            String uri = url.toURI().toString();
            this.path = uri.startsWith("jar:") ? this.copyToFile() : new File(uri).getAbsolutePath();
        }
        catch (URISyntaxException e) {
            this.path = new File(url.getPath()).getAbsolutePath();
        }
        return this.path;
    }

    private String copyToFile() {
        try {
            int len;
            File temp = File.createTempFile("utaustin", ".lap");
            temp.deleteOnExit();
            FileOutputStream output = new FileOutputStream(temp);
            InputStream input = this.getClass().getResourceAsStream(this.name);
            byte[] buf = new byte[1024];
            while ((len = input.read(buf)) > 0) {
                ((OutputStream)output).write(buf, 0, len);
            }
            input.close();
            ((OutputStream)output).close();
            System.out.println("Resource copied into temporary file: " + temp);
            return temp.getAbsolutePath();
        }
        catch (IOException e) {
            System.err.println("Could not copy resource " + this.name + " to a temporary file");
            e.printStackTrace();
            return null;
        }
    }
}

